/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.SeqFeatureI;
import apollo.gui.SelectableI;
import java.util.HashSet;
import java.util.Iterator;

public class SelectionItem {
    Object source;
    SeqFeatureI data;
    private HashSet selectionListenerSet;

    public SelectionItem(Object source, SeqFeatureI data) {
        this.source = source;
        this.data = data;
    }

    public SelectionItem(SelectionItem from) {
        this.source = from.getSource();
        this.data = from.getData();
        this.selectionListenerSet = from.selectionListenerSet;
    }

    public Object getSource() {
        return this.source;
    }

    public SeqFeatureI getData() {
        return this.data;
    }

    public void setData(SeqFeatureI data) {
        this.data = data;
    }

    void deselect() {
        if (this.selectionListenerSet == null) {
            return;
        }
        Iterator it = this.selectionListenerSet.iterator();
        while (it.hasNext()) {
            ((SelectableI)it.next()).setSelected(false);
        }
    }

    void select() {
        if (this.selectionListenerSet == null) {
            return;
        }
        Iterator it = this.selectionListenerSet.iterator();
        while (it.hasNext()) {
            ((SelectableI)it.next()).setSelected(true);
        }
    }

    public void addSelectionListener(SelectableI selectable) {
        if (this.selectionListenerSet == null) {
            this.selectionListenerSet = new HashSet(2);
        }
        this.selectionListenerSet.add(selectable);
    }
}

