/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.DetailInfo;
import apollo.gui.SelectionItem;
import apollo.util.FeatureIterator;
import apollo.util.FeatureList;
import java.util.HashSet;
import java.util.Vector;

public class Selection
extends FeatureList {
    public static final int FEATURE = 1;
    public static final int SET = 2;
    private Vector selectionItems = new Vector();

    public Selection() {
    }

    public Selection(FeatureList feats, Object source) {
        for (int i = 0; i < feats.size(); ++i) {
            this.add(new SelectionItem(source, feats.getFeature(i)));
        }
    }

    public void add(SelectionItem item) {
        if (!this.contains(item.getData())) {
            this.selectionItems.addElement(item);
            this.addFeature(item.getData());
        }
    }

    public void add(SelectionItem item, boolean deselectIfAlreadySelected) {
        if (deselectIfAlreadySelected && this.contains(item.getData())) {
            item.deselect();
            this.remove(item);
        } else {
            this.add(item);
        }
    }

    public void add(FeatureList feats, Object source, boolean deselectIfAlreadySelected) {
        FeatureIterator iter = feats.featureIterator();
        while (iter.hasNextFeature()) {
            this.add(new SelectionItem(source, iter.nextFeature()), deselectIfAlreadySelected);
        }
    }

    public void add(FeatureList feats, Object source) {
        this.add(feats, source, false);
    }

    public void add(Selection selection, boolean deselectIfAlreadySelected) {
        Vector selVec = selection.getSelected();
        for (int i = 0; i < selVec.size(); ++i) {
            SelectionItem si = (SelectionItem)selVec.elementAt(i);
            this.add(new SelectionItem(si), deselectIfAlreadySelected);
        }
    }

    public void add(Selection selection) {
        this.add(selection, false);
    }

    public void removeFeature(SeqFeatureI feat) {
        int index = this.indexOf(feat);
        if (index >= 0) {
            this.selectionItems.removeElementAt(index);
            this.remove(index);
        }
    }

    void remove(SelectionItem si) {
        int index = this.selectionItems.indexOf(si);
        if (index >= 0) {
            this.selectionItems.removeElementAt(index);
            this.remove(index);
        } else {
            this.removeFeature(si.getData());
        }
    }

    void replaceFeature(SeqFeatureI old_feat, SeqFeatureI new_feat) {
        int index = this.indexOf(old_feat);
        if (index >= 0) {
            SelectionItem si = (SelectionItem)this.selectionItems.elementAt(index);
            si.setData(new_feat);
            this.remove(index);
            this.add(index, new_feat);
        } else if (old_feat.canHaveChildren()) {
            FeatureSetI old_fs = (FeatureSetI)old_feat;
            FeatureSetI new_fs = (FeatureSetI)new_feat;
            for (int i = 0; i < old_fs.size(); ++i) {
                this.replaceFeature(old_fs.getFeatureAt(i), new_fs.getFeatureAt(i));
            }
        }
    }

    public Vector getSelected() {
        return this.selectionItems;
    }

    public FeatureList getListDescendedFromModel(SeqFeatureI model, boolean check) {
        Selection sel = this.getSelectionDescendedFromModel(model, check);
        return sel.getSelectedData();
    }

    public Selection getSelectionDescendedFromModel(SeqFeatureI model) {
        return this.getSelectionDescendedFromModel(model, false);
    }

    public Selection getSelectionDescendedFromModel(SeqFeatureI model, boolean checkForRedundantDescendants) {
        Selection descendants = new Selection();
        for (int i = 0; i < this.selectionItems.size(); ++i) {
            SelectionItem si = (SelectionItem)this.selectionItems.elementAt(i);
            SeqFeatureI newFeat = si.getData();
            if (!newFeat.descendsFrom(model)) continue;
            boolean notRedundantDescendant = true;
            if (checkForRedundantDescendants) {
                for (int j = descendants.size() - 1; j >= 0 && notRedundantDescendant; --j) {
                    SeqFeatureI sf = descendants.getSelectedData(j);
                    if (newFeat.descendsFrom(sf)) {
                        notRedundantDescendant = false;
                    }
                    if (!sf.descendsFrom(newFeat)) continue;
                    descendants.removeFeature(sf);
                }
            }
            if (!notRedundantDescendant) continue;
            descendants.add(si);
        }
        return descendants;
    }

    public boolean containsFeature(SeqFeatureI sf) {
        return this.contains(sf);
    }

    public FeatureList getSelectedData() {
        return this;
    }

    public Vector getSelectedVector() {
        return this.toVector();
    }

    public SeqFeatureI getSelectedData(int i) {
        return this.getFeature(i);
    }

    public SelectionItem getSelectionItem(int i) {
        return (SelectionItem)this.selectionItems.elementAt(i);
    }

    public SelectionItem getSelectionItem(SeqFeatureI sf) {
        int i = this.indexOf(sf);
        if (i >= 0) {
            return (SelectionItem)this.selectionItems.elementAt(i);
        }
        return null;
    }

    public int size() {
        return this.selectionItems.size();
    }

    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            SelectionItem si = this.getSelectionItem(i);
            si.deselect();
        }
        this.selectionItems.clear();
        super.clear();
    }

    void select() {
        for (int i = 0; i < this.size(); ++i) {
            this.getSelectionItem(i).select();
        }
    }

    public HashSet getSelectedVisualTypes() {
        HashSet<String> visualTypes = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            SeqFeatureI feat = this.getSelectedData(i);
            String visualType = DetailInfo.getPropertyType(feat);
            visualTypes.add(visualType);
        }
        return visualTypes;
    }
}

