/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.dataadapter.CGI;
import apollo.editor.UserName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.w3c.tools.codec.Base64Encoder;

public class ProxyDialog
extends JDialog
implements ActionListener {
    String proxyServer;
    String proxyPort;
    String userName;
    String userPassword;
    boolean hasAuthentication = false;
    boolean hasProxy = false;
    JTextField server;
    JTextField port;
    JTextField name;
    JPasswordField password;
    JCheckBox authBox;
    JCheckBox proxyBox;
    JPanel authP;
    JButton ok;
    JButton cancel;

    public ProxyDialog(JFrame frame) {
        super(frame, "Proxy settings", true);
        String setStr = System.getProperty("http.proxySet");
        if (setStr == null) {
            setStr = System.getProperty("proxySet");
        }
        if (setStr != null) {
            this.hasProxy = new Boolean(setStr);
        }
        this.proxyPort = System.getProperty("http.proxyPort");
        if (this.proxyPort == null) {
            this.proxyPort = System.getProperty("proxyPort");
        }
        this.proxyServer = System.getProperty("http.proxyHost");
        if (this.proxyServer == null) {
            this.proxyServer = System.getProperty("proxyHost");
        }
        this.init();
        if (frame == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.authBox) {
            this.hasAuthentication = this.authBox.isSelected();
            this.authP.setVisible(this.authBox.isSelected());
            this.name.setEnabled(this.hasAuthentication && this.hasProxy);
            this.password.setEnabled(this.hasAuthentication && this.hasProxy);
            this.pack();
        } else if (evt.getSource() == this.proxyBox) {
            this.hasProxy = this.proxyBox.isSelected();
            this.server.setEnabled(this.hasProxy);
            this.port.setEnabled(this.hasProxy);
            this.name.setEnabled(this.hasAuthentication && this.hasProxy);
            this.password.setEnabled(this.hasAuthentication && this.hasProxy);
            this.authBox.setEnabled(this.hasProxy);
        } else if (evt.getSource() == this.ok) {
            this.commitIfComplete();
        } else if (evt.getSource() == this.cancel) {
            this.hide();
            this.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitIfComplete() {
        block7: {
            block6: {
                if (!this.proxyBox.isSelected()) break block6;
                if (!this.server.getText().equals("") && !this.port.getText().equals("")) {
                    System.out.println("server = " + this.server.getText());
                    System.out.println("port   = " + this.port.getText());
                    try {
                        Integer.parseInt(this.port.getText(), 10);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "Port is not an integer", "Error", 0);
                        return;
                    }
                    if (this.hasAuthentication) {
                        if (this.name.getText().equals("") || this.password.getText().equals("")) {
                            JOptionPane.showMessageDialog(this, "You need to specify both name and password for authentication", "Error", 0);
                            return;
                        }
                        String authStr = this.name.getText() + ":" + this.password.getText();
                        Base64Encoder encoder = new Base64Encoder(authStr);
                        URLConnection.setDefaultRequestProperty("Proxy-Authorization", "Basic " + encoder.processString());
                        System.out.println("Processed string = " + encoder.processString());
                    }
                    Properties props = System.getProperties();
                    props.put("http.proxySet", "true");
                    props.put("http.proxyHost", this.server.getText());
                    props.put("http.proxyPort", this.port.getText());
                    break block7;
                } else {
                    JOptionPane.showMessageDialog(this, "You need to specify both server and port", "Error", 0);
                    return;
                }
            }
            Properties props = System.getProperties();
            props.put("http.proxySet", "false");
            props.put("proxySet", "false");
            props.remove("http.proxyHost");
            props.remove("http.proxyPort");
            props.remove("proxyHost");
            props.remove("proxyPort");
        }
        this.hide();
        this.dispose();
    }

    public void init() {
        this.server = new JTextField(30);
        this.server.setText(this.proxyServer);
        this.port = new JTextField(6);
        this.port.setText(this.proxyPort);
        this.server.setEnabled(this.hasProxy);
        this.port.setEnabled(this.hasProxy);
        this.authBox = new JCheckBox();
        this.authBox.setSelected(this.hasAuthentication);
        this.authBox.setEnabled(this.hasProxy);
        this.authBox.addActionListener(this);
        this.proxyBox = new JCheckBox();
        this.proxyBox.setSelected(this.hasProxy);
        this.proxyBox.addActionListener(this);
        this.name = new JTextField(30);
        this.name.setText(UserName.getUserName());
        this.password = new JPasswordField(30);
        this.name.setEnabled(this.hasAuthentication && this.hasProxy);
        this.password.setEnabled(this.hasAuthentication && this.hasProxy);
        JPanel mainP = new JPanel();
        mainP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        mainP.add((Component)new JLabel("Use Proxy"), gbc);
        gbc.gridwidth = 0;
        mainP.add((Component)this.proxyBox, gbc);
        gbc.gridwidth = 1;
        mainP.add((Component)new JLabel("Server"), gbc);
        gbc.gridwidth = 0;
        mainP.add((Component)this.server, gbc);
        gbc.gridwidth = 1;
        mainP.add((Component)new JLabel("Port"), gbc);
        gbc.gridwidth = 0;
        mainP.add((Component)this.port, gbc);
        gbc.gridwidth = 1;
        mainP.add((Component)new JLabel("Use Authentication"), gbc);
        gbc.gridwidth = 0;
        mainP.add((Component)this.authBox, gbc);
        this.authP = new JPanel();
        this.authP.setLayout(new GridBagLayout());
        gbc.gridwidth = 1;
        this.authP.add((Component)new JLabel("Username"), gbc);
        gbc.gridwidth = 0;
        this.authP.add((Component)this.name, gbc);
        gbc.gridwidth = 1;
        this.authP.add((Component)new JLabel("Password"), gbc);
        gbc.gridwidth = 0;
        this.authP.add((Component)this.password, gbc);
        JPanel enclosureP = new JPanel();
        enclosureP.setLayout(new BorderLayout());
        enclosureP.add((Component)mainP, "Center");
        enclosureP.add((Component)this.authP, "South");
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel buttonP = new JPanel();
        buttonP.add(this.ok);
        buttonP.add(this.cancel);
        this.getContentPane().add((Component)enclosureP, "Center");
        this.getContentPane().add((Component)buttonP, "South");
        this.authP.setVisible(false);
        this.pack();
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        JButton show = new JButton("Show");
        JButton get = new JButton("Get");
        show.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyDialog pd = new ProxyDialog(frame);
                pd.setVisible(true);
            }
        });
        get.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CGI cgi = new CGI("www.google.com", 80, "index.html", new Hashtable(), System.out);
                cgi.run();
                try {
                    BufferedReader d = new BufferedReader(new InputStreamReader(cgi.getInput()));
                    String data = d.readLine();
                    System.out.println("first line = " + data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        frame.getContentPane().setLayout(new GridLayout(2, 1));
        frame.getContentPane().add(show);
        frame.getContentPane().add(get);
        frame.pack();
        frame.setVisible(true);
    }
}

