/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.gui.ControlledObjectI;
import apollo.gui.ControlledPanel;
import apollo.gui.Controller;
import apollo.gui.SeqSelectorTable;
import apollo.gui.StatusPane;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.NumericKeyFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FindPanel
extends ControlledPanel
implements ActionListener,
ControlledObjectI,
DataLoadListener {
    JTextField seqField;
    JTextField nameField;
    JTextField positionField;
    JLabel seqLabel;
    JLabel nameLabel;
    JLabel positionLabel;
    JButton seqButton;
    JButton nameButton;
    JButton positionButton;
    JButton clearButton;
    JButton cancelButton;
    JCheckBox revStrand;
    JCheckBox regExp;
    BaseValidator seqValidator = new BaseValidator();
    GuiCurationState curationState;
    JTable resultTable;
    JScrollPane resultTableScroller;
    JPanel mainPanel;
    JPanel closePanel;
    Vector columns;
    SeqFeatureI sf;
    Vector features = new Vector();
    int currentFeatureType;
    protected static Color color = new Color(255, 255, 204);
    private StatusPane resultsPane;

    public FindPanel(GuiCurationState cs) {
        this.curationState = cs;
        this.setController(this.getController());
        SequenceI seq = this.getSZAP().getAnnotations().getRefSequence();
        this.setSequence(seq, this.getSZAP().getCurationSet());
        this.componentInit();
    }

    private StrandedZoomableApolloPanel getSZAP() {
        return this.curationState.getSZAP();
    }

    private void setSequence(SequenceI seq, RangeI range) {
        if (range != null) {
            this.setSequence(seq, range.getStart(), range.getEnd());
        } else if (seq != null) {
            this.setSequence(seq, 1, seq.getLength());
        }
    }

    private void setSequence(SequenceI seq, int start, int end) {
        this.sf = new SeqFeature(start, end, "sequence");
        this.sf.setRefSequence(seq);
    }

    public void setController(Controller c) {
        c.addListener(this);
    }

    public Controller getController() {
        return this.curationState.getController();
    }

    public void componentInit() {
        this.setBackground(color);
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(color);
        this.mainPanel.setForeground(Color.black);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setPreferredSize(new Dimension(400, 130));
        this.positionLabel = new JLabel(" Position ");
        this.positionLabel.setForeground(Color.black);
        this.nameLabel = new JLabel(" Name ");
        this.nameLabel.setForeground(Color.black);
        this.seqLabel = new JLabel(" Sequence ");
        this.seqLabel.setForeground(Color.black);
        this.positionField = new JTextField();
        this.nameField = new JTextField();
        this.seqField = new JTextField();
        this.positionButton = new JButton("Goto");
        this.nameButton = new JButton("Find");
        this.seqButton = new JButton("Find");
        this.clearButton = new JButton("Clear");
        this.cancelButton = new JButton("Cancel");
        Dimension buttonSize = new Dimension(90, 20);
        this.positionButton.setPreferredSize(buttonSize);
        this.nameButton.setPreferredSize(buttonSize);
        this.seqButton.setPreferredSize(buttonSize);
        this.clearButton.setPreferredSize(buttonSize);
        this.cancelButton.setPreferredSize(buttonSize);
        this.revStrand = new JCheckBox("Search reverse strand?");
        this.revStrand.setHorizontalAlignment(4);
        this.revStrand.setBackground(color);
        this.regExp = new JCheckBox("Use Regular Expressions?");
        this.regExp.setHorizontalAlignment(4);
        this.regExp.setBackground(color);
        this.resultsPane = new StatusPane(" Results ", "", color);
        this.resultsPane.setBackground(color);
        this.resultsPane.setPreferredSize(new Dimension(400, 24));
        this.resultsPane.setFont(this.getFont());
        this.columns = new Vector();
        this.columns.addElement("Position");
        this.columns.addElement("Sequence");
        this.resultTableScroller = new JScrollPane();
        Box posBox = new Box(0);
        posBox.add(this.positionLabel);
        posBox.add(this.positionField);
        posBox.add(this.positionButton);
        posBox.add(posBox.createHorizontalGlue());
        Box nameBox = new Box(0);
        nameBox.add(this.nameLabel);
        nameBox.add(this.nameField);
        nameBox.add(this.nameButton);
        nameBox.add(nameBox.createHorizontalGlue());
        Box seqBox = new Box(0);
        seqBox.add(this.seqLabel);
        seqBox.add(this.seqField);
        seqBox.add(this.seqButton);
        seqBox.add(seqBox.createHorizontalGlue());
        this.mainPanel.add(posBox);
        this.mainPanel.add(nameBox);
        this.mainPanel.add(seqBox);
        this.mainPanel.add(this.revStrand);
        this.mainPanel.add(this.regExp);
        this.mainPanel.add(Box.createVerticalStrut(50));
        this.mainPanel.add(Box.createVerticalGlue());
        this.positionButton.addActionListener(this);
        this.nameButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.seqButton.addActionListener(this);
        this.positionField.addActionListener(this);
        this.nameField.addActionListener(this);
        this.seqField.addActionListener(this);
        this.revStrand.addActionListener(this);
        this.regExp.addActionListener(this);
        this.positionField.addKeyListener(NumericKeyFilter.getFilter());
        this.seqField.addKeyListener(this.seqValidator);
        boolean got_seq = this.getSZAP().haveSequence();
        this.seqField.setEnabled(got_seq);
        this.seqButton.setEnabled(got_seq);
        this.revStrand.setSelected(this.getSZAP().isReverseComplement());
        this.closePanel = new JPanel();
        this.closePanel.setBackground(color);
        this.closePanel.setForeground(Color.black);
        this.closePanel.setLayout(new BorderLayout());
        this.closePanel.setPreferredSize(new Dimension(400, 30));
        this.closePanel.add((Component)this.clearButton, "West");
        this.closePanel.add((Component)this.cancelButton, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "North");
        this.add((Component)this.resultsPane, "Center");
        this.add((Component)this.closePanel, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.nameButton || evt.getSource() == this.nameField) {
            boolean selectionFound;
            if (this.resultTable != null) {
                this.resultTable.setVisible(false);
            }
            if (selectionFound = this.getSZAP().selectFeaturesByName(this.nameField.getText(), 0, this.regExp.isSelected())) {
                this.resultsPane.setText("Found " + this.nameField.getText());
            } else {
                this.resultsPane.setText("No features match pattern " + this.nameField.getText());
            }
        } else if (evt.getSource() == this.positionButton || evt.getSource() == this.positionField) {
            if (!this.positionField.getText().equals("")) {
                if (this.resultTable != null) {
                    this.resultTable.setVisible(false);
                }
                this.resultTableScroller.setEnabled(false);
                this.fireBaseFocusEvent(this.positionField.getText());
            }
        } else if (evt.getSource() == this.seqButton || evt.getSource() == this.seqField) {
            this.findSequence();
        } else if (evt.getSource() == this.cancelButton) {
            this.getController().removeListener(this);
            Window win = SwingUtilities.windowForComponent(this);
            win.hide();
            win.dispose();
        } else if (evt.getSource() == this.clearButton) {
            if (this.resultTable != null) {
                this.resultTable.setVisible(false);
            }
            this.positionField.setText("");
            this.nameField.setText("");
            this.seqField.setText("");
        }
    }

    private void findSequence() {
        String tmpString = this.seqField.getText().toUpperCase();
        if (tmpString.equals("")) {
            return;
        }
        this.resultsPane.setText("Searching for sequence on " + (this.revStrand.isSelected() ? "reverse" : "forward") + " strand");
        SeqSelectorTable seqTab = new SeqSelectorTable(this.sf, tmpString, this.revStrand.isSelected(), this.getSZAP(), this.resultsPane, this.regExp.isSelected());
        this.resultTable = seqTab.getTable();
        this.resultTableScroller.setViewportView(this.resultTable);
        this.resultTable.setVisible(true);
        this.mainPanel.setPreferredSize(new Dimension(400, 300));
        this.mainPanel.remove(this.resultTableScroller);
        this.mainPanel.add((Component)this.resultTableScroller, "Center");
        this.mainPanel.validate();
        Window win = SwingUtilities.windowForComponent(this.resultTableScroller);
        win.validate();
        win.pack();
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        this.getController().removeListener(this);
        Window win = SwingUtilities.windowForComponent(this);
        win.hide();
        win.dispose();
        return true;
    }

    public void addNotify() {
        super.addNotify();
    }

    public void fireBaseFocusEvent(String pos) {
        try {
            int position = Integer.parseInt(pos);
            this.fireBaseFocusEvent(position);
        }
        catch (Exception e) {
            System.err.println("Not an integer: " + pos);
        }
    }

    public void fireBaseFocusEvent(int pos) {
        BaseFocusEvent evt = new BaseFocusEvent(this, pos, new SeqFeature());
        this.getController().handleBaseFocusEvent(evt);
        this.resultsPane.setText("Centering on base " + this.positionField.getText());
    }

    private void _beep() {
        byte[] beep = new byte[]{7};
        System.out.print(new String(beep));
    }

    class BaseValidator
    extends KeyAdapter {
        BaseValidator() {
        }

        public void keyTyped(KeyEvent evt) {
            if (FindPanel.this.regExp.isSelected()) {
                switch (evt.getKeyChar()) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case '?': 
                    case 'A': 
                    case 'C': 
                    case 'G': 
                    case 'N': 
                    case 'T': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case 'a': 
                    case 'c': 
                    case 'g': 
                    case 'n': 
                    case 't': 
                    case '{': 
                    case '|': 
                    case '}': {
                        break;
                    }
                    default: {
                        if (!Character.isISOControl(evt.getKeyChar())) {
                            evt.consume();
                            FindPanel.this._beep();
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                switch (evt.getKeyChar()) {
                    case 'A': 
                    case 'C': 
                    case 'G': 
                    case 'N': 
                    case 'T': 
                    case 'a': 
                    case 'c': 
                    case 'g': 
                    case 'n': 
                    case 't': {
                        break;
                    }
                    default: {
                        if (Character.isISOControl(evt.getKeyChar())) break;
                        evt.consume();
                        FindPanel.this._beep();
                    }
                }
            }
        }
    }
}

