/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.TierProperty;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Evidence;
import apollo.datamodel.EvidenceFinder;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.gui.DetailRange;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DetailInfo {
    public static final int GENOMIC_LENGTH = 0;
    public static final int MATCH_LENGTH = 1;
    public static final int GENOMIC_RANGE = 2;
    public static final int MATCH_RANGE = 3;
    public static final int SCORE = 4;
    public static final int ID = 5;
    public static final int TYPE = 6;
    public static final int TIER = 7;
    public static final int NAME = 8;
    public static final int EVIDENCE = 9;
    public static final int GENOMIC_SEQUENCE = 10;
    public static final int MATCH_SEQUENCE = 11;
    public static final int START = 12;
    public static final int END = 13;
    public static final int LOW = 14;
    public static final int HIGH = 15;
    public static final int STRAND = 16;
    public static final int Type = 17;
    public static final int Range = 18;
    public static final int PHASE = 19;
    public static final int BIOTYPE = 20;
    private static final Hashtable stringMapping = new Hashtable();
    private static final Hashtable prettyNameMapping = new Hashtable();

    public static Integer getPropertyForString(String name) {
        return (Integer)stringMapping.get(name);
    }

    public static Enumeration getAllProperties() {
        return stringMapping.elements();
    }

    public static Enumeration getAllPropertyStrings() {
        return stringMapping.keys();
    }

    public static String getPrettyNameForString(String key) {
        Integer value = (Integer)stringMapping.get(key);
        if (value == null) {
            return key;
        }
        return (String)prettyNameMapping.get(value);
    }

    public static String getPrettyNameForProperty(Integer key) {
        return (String)prettyNameMapping.get(key);
    }

    public static Vector getPrettyNamesFromStrings(Vector values) {
        Vector<String> out = new Vector<String>();
        for (int i = 0; i < values.size(); ++i) {
            out.addElement(DetailInfo.getPrettyNameForString((String)values.elementAt(i)));
        }
        return out;
    }

    public static Vector getRow(Vector def, SeqFeatureI feature) {
        Vector<Object> out = new Vector<Object>();
        for (int i = 0; i < def.size(); ++i) {
            String prop = (String)def.elementAt(i);
            out.addElement(DetailInfo.getPropertyForFeature(prop, feature));
        }
        return out;
    }

    public static Object getPropertyForFeature(String prop, SeqFeatureI feature) {
        Integer val = (Integer)stringMapping.get(prop);
        if (val == null) {
            String property;
            if (prop.equals("query_frame")) {
                property = "" + feature.getFrame();
            } else {
                property = feature.getProperty(prop);
                if ((property == null || property.equals("")) && feature.getRefFeature() != null) {
                    property = feature.getRefFeature().getProperty(prop);
                }
                if (property == null || property.equals("")) {
                    Double score = (Double)DetailInfo.getScore(feature, prop);
                    property = score != -1.0 ? score.toString() : "";
                }
            }
            return property;
        }
        int command = val;
        switch (command) {
            case 0: {
                return DetailInfo.getGenomicLength(feature);
            }
            case 1: {
                return DetailInfo.getMatchLength(feature);
            }
            case 2: 
            case 18: {
                return DetailInfo.getGenomicRange(feature);
            }
            case 3: {
                return DetailInfo.getMatchRange(feature);
            }
            case 4: {
                return DetailInfo.getScore(feature);
            }
            case 6: {
                return DetailInfo.getType(feature);
            }
            case 20: {
                return DetailInfo.getBioType(feature);
            }
            case 7: {
                return DetailInfo.getTier(feature);
            }
            case 17: {
                return DetailInfo.getPropertyType(feature);
            }
            case 8: {
                return DetailInfo.getName(feature);
            }
            case 5: {
                return DetailInfo.getID(feature);
            }
            case 9: {
                return DetailInfo.getEvidence(feature);
            }
            case 10: {
                return DetailInfo.getGenomicSequence(feature);
            }
            case 11: {
                return DetailInfo.getMatchSequence(feature);
            }
            case 12: {
                return DetailInfo.getStart(feature);
            }
            case 13: {
                return DetailInfo.getEnd(feature);
            }
            case 14: {
                return DetailInfo.getLow(feature);
            }
            case 15: {
                return DetailInfo.getHigh(feature);
            }
            case 16: {
                return DetailInfo.getStrand(feature);
            }
            case 19: {
                return DetailInfo.getPhase(feature);
            }
        }
        return "";
    }

    public static Object getStrand(SeqFeatureI feature) {
        if (feature.getStrand() < 0) {
            return "-";
        }
        return "+";
    }

    public static Object getLow(SeqFeatureI feature) {
        return new Integer(feature.getLow());
    }

    public static Object getHigh(SeqFeatureI feature) {
        return new Integer(feature.getHigh());
    }

    public static Object getStart(SeqFeatureI feature) {
        return new Integer(feature.getStart());
    }

    public static Object getEnd(SeqFeatureI feature) {
        return new Integer(feature.getEnd());
    }

    public static Object getPhase(SeqFeatureI feature) {
        return new Integer(feature.getPhase());
    }

    public static Object getEvidence(SeqFeatureI feature) {
        AnnotatedFeatureI gi;
        EvidenceFinder finder;
        StringBuffer evidenceFeatures = new StringBuffer();
        if (feature instanceof AnnotatedFeatureI && (finder = (gi = (AnnotatedFeatureI)feature).getEvidenceFinder()) != null) {
            Vector evidence = gi.getEvidence();
            for (int i = 0; i < evidence.size(); ++i) {
                Evidence e = (Evidence)evidence.elementAt(i);
                String evidenceId = e.getFeatureId();
                SeqFeatureI evidenceSF = finder.findEvidence(evidenceId);
                if (evidenceSF != null) {
                    if (i > 0) {
                        evidenceFeatures.append(", ");
                    }
                    evidenceFeatures.append(evidenceSF.toString());
                    continue;
                }
                System.err.println("Could not find evidence " + evidenceId);
                evidenceFeatures.append(e.toString());
            }
        }
        return evidenceFeatures;
    }

    public static Object getTranslationLength(SeqFeatureI feature) {
        if (feature instanceof Transcript) {
            return new Integer(((Transcript)feature).translate().length());
        }
        return "";
    }

    public static String getTranslation(SeqFeatureI feature) {
        if (feature instanceof Transcript) {
            return ((Transcript)feature).translate();
        }
        return "";
    }

    public static String getMatchSequence(SeqFeatureI feature) {
        SeqFeatureI hit = DetailInfo.getHitFeature(feature);
        if (hit == null) {
            return "";
        }
        return DetailInfo.getGenomicSequence(hit);
    }

    public static String getGenomicSequence(SeqFeatureI feature) {
        return feature.getResidues();
    }

    public static String getID(SeqFeatureI feature) {
        return feature.getId();
    }

    public static String getName(SeqFeatureI feature) {
        return Config.getDisplayPrefs().getDisplayName(feature);
    }

    public static Object getScore(SeqFeatureI feature) {
        return new Double(feature.getScore());
    }

    private static Object getScore(SeqFeatureI feature, String scorename) {
        if (scorename.equals("score") && feature.getScore(scorename) == -1.0) {
            return new Double(feature.getScore("total_score"));
        }
        return new Double(feature.getScore(scorename));
    }

    public static Object getGenomicLength(SeqFeatureI feature) {
        return new Integer(feature.length());
    }

    public static Object getMatchLength(SeqFeatureI feature) {
        SeqFeatureI hit = DetailInfo.getHitFeature(feature);
        if (hit == null) {
            return "";
        }
        return DetailInfo.getGenomicLength(hit);
    }

    public static Object getGenomicRange(SeqFeatureI feature) {
        return new DetailRange(feature.getStart(), feature.getEnd());
    }

    public static Object getMatchRange(SeqFeatureI feature) {
        SeqFeatureI hit = DetailInfo.getHitFeature(feature);
        if (hit == null) {
            return "";
        }
        return DetailInfo.getGenomicRange(hit);
    }

    public static Object getType(SeqFeatureI feature) {
        return feature.getFeatureType();
    }

    public static String getBioType(SeqFeatureI feature) {
        return feature.getTopLevelType();
    }

    public static Object getTier(SeqFeatureI feature) {
        TierProperty property = null;
        for (SeqFeatureI sf = feature; property == null && sf != null; sf = sf.getRefFeature()) {
            property = Config.getPropertyScheme().getTierProperty(sf.getFeatureType(), false);
        }
        return property != null ? property.getLabel() : "??";
    }

    public static String getPropertyType(SeqFeatureI feature) {
        String biotype = feature.getTopLevelType();
        if (biotype == null) {
            return null;
        }
        FeatureProperty property = Config.getPropertyScheme().getFeatureProperty(biotype);
        String type = property.getDisplayType();
        return type;
    }

    protected static SeqFeatureI getHitFeature(SeqFeatureI feature) {
        if (feature instanceof FeaturePairI) {
            return ((FeaturePairI)feature).getHitFeature();
        }
        return null;
    }

    static {
        stringMapping.put("GENOMIC_LENGTH", new Integer(0));
        stringMapping.put("MATCH_LENGTH", new Integer(1));
        stringMapping.put("GENOMIC_RANGE", new Integer(2));
        stringMapping.put("MATCH_RANGE", new Integer(3));
        stringMapping.put("SCORE", new Integer(4));
        stringMapping.put("TYPE", new Integer(6));
        stringMapping.put("BIOTYPE", new Integer(20));
        stringMapping.put("TIER", new Integer(7));
        stringMapping.put("NAME", new Integer(8));
        stringMapping.put("ID", new Integer(5));
        stringMapping.put("EVIDENCE", new Integer(9));
        stringMapping.put("GENOMIC_SEQUENCE", new Integer(10));
        stringMapping.put("START", new Integer(12));
        stringMapping.put("END", new Integer(13));
        stringMapping.put("LOW", new Integer(14));
        stringMapping.put("HIGH", new Integer(15));
        stringMapping.put("STRAND", new Integer(16));
        stringMapping.put("Type", new Integer(17));
        stringMapping.put("Range", new Integer(18));
        stringMapping.put("PHASE", new Integer(19));
        prettyNameMapping.put(new Integer(0), "Genomic Length");
        prettyNameMapping.put(new Integer(1), "Match Length");
        prettyNameMapping.put(new Integer(2), "Genomic Range");
        prettyNameMapping.put(new Integer(3), "Match Range");
        prettyNameMapping.put(new Integer(4), "Score");
        prettyNameMapping.put(new Integer(6), "Type");
        prettyNameMapping.put(new Integer(20), "Type");
        prettyNameMapping.put(new Integer(7), "Tier");
        prettyNameMapping.put(new Integer(8), "Name");
        prettyNameMapping.put(new Integer(5), "Id");
        prettyNameMapping.put(new Integer(9), "Evidence");
        prettyNameMapping.put(new Integer(10), "Genomic Sequence");
        prettyNameMapping.put(new Integer(11), "Match Sequence");
        prettyNameMapping.put(new Integer(12), "Start");
        prettyNameMapping.put(new Integer(13), "End");
        prettyNameMapping.put(new Integer(14), "Low");
        prettyNameMapping.put(new Integer(15), "High");
        prettyNameMapping.put(new Integer(16), "Strand");
        prettyNameMapping.put(new Integer(17), "Type");
        prettyNameMapping.put(new Integer(18), "Range");
        prettyNameMapping.put(new Integer(19), "Phase");
    }
}

