/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.PropSchemeChangeEvent;
import apollo.config.PropSchemeChangeListener;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.editor.ResultChangeEvent;
import apollo.editor.ResultChangeListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.BaseFocusListener;
import apollo.gui.event.ChainedRepaintEvent;
import apollo.gui.event.ChainedRepaintListener;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.event.LazyLoadEvent;
import apollo.gui.event.LazyLoadListener;
import apollo.gui.event.NamedFeatureSelectionEvent;
import apollo.gui.event.NamedFeatureSelectionListener;
import apollo.gui.event.OrientationEvent;
import apollo.gui.event.OrientationListener;
import apollo.gui.event.ReverseComplementEvent;
import apollo.gui.event.ReverseComplementListener;
import apollo.gui.event.ScrollEvent;
import apollo.gui.event.ScrollListener;
import apollo.gui.event.SetActiveCurStateEvent;
import apollo.gui.event.SetActiveCurStateListener;
import apollo.gui.event.ZoomEvent;
import apollo.gui.event.ZoomListener;
import apollo.gui.synteny.SyntenyLinkPanel;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;

public class Controller
implements BaseFocusListener,
AnnotationChangeListener,
FeatureSelectionListener,
LazyLoadListener,
NamedFeatureSelectionListener,
SetActiveCurStateListener,
OrientationListener,
DataLoadListener,
ResultChangeListener,
ReverseComplementListener,
PropSchemeChangeListener,
WindowListener,
ScrollListener,
ZoomListener {
    Vector listeners;
    Hashtable windowHash = new Hashtable();
    boolean annotations_changed = false;
    boolean curation_loaded = false;
    private static Controller masterController;

    public Controller() {
        this.listeners = new Vector();
    }

    public static Controller getMasterController() {
        if (masterController == null) {
            masterController = new Controller();
        }
        return masterController;
    }

    public boolean hasListener(EventListener l) {
        return this.listeners.contains(l);
    }

    public void addListener(EventListener l) {
        Window w = null;
        Object wobj = null;
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
        if (l instanceof ControlledObjectI) {
            wobj = ((ControlledObjectI)((Object)l)).getControllerWindow();
            if (wobj instanceof Window) {
                w = (Window)wobj;
            } else if (wobj != null) {
                System.err.println(l.getClass().getName() + ".getControllerWindow() returned Non Window for " + l.getClass().getName() + " is " + wobj);
            }
        }
        if (w != null) {
            ControlledWindow cw = null;
            if (this.windowHash.containsKey(w)) {
                cw = (ControlledWindow)this.windowHash.get(w);
            } else {
                w.addWindowListener(this);
                cw = new ControlledWindow(w);
                this.windowHash.put(w, cw);
            }
            if (cw != null) {
                cw.addChild(l);
            }
        }
    }

    public Vector getWindowList() {
        return this.getWindowList(null);
    }

    public Vector getWindowList(Window skipMe) {
        Vector<Window> out = new Vector<Window>();
        Enumeration e = this.windowHash.keys();
        while (e.hasMoreElements()) {
            Window win = (Window)e.nextElement();
            if (win.equals(skipMe)) continue;
            out.addElement(win);
        }
        return out;
    }

    public void clear(boolean keepListenerToMaster) {
        this.listeners.clear();
        this.windowHash.clear();
        if (keepListenerToMaster && this != Controller.getMasterController()) {
            this.addListener(Controller.getMasterController());
        }
    }

    public void removeListener(EventListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
        if (l instanceof ControlledObjectI) {
            ControlledObjectI coi = (ControlledObjectI)((Object)l);
            Object win = coi.getControllerWindow();
            if (win == null) {
                return;
            }
            ControlledWindow cw = (ControlledWindow)this.windowHash.get(win);
            if (cw != null) {
                cw.removeChild(l);
            }
        }
    }

    public Vector getListeners() {
        return this.listeners;
    }

    public boolean isAnnotationChanged() {
        return this.annotations_changed;
    }

    public boolean isCurationSetLoaded() {
        return this.curation_loaded;
    }

    public void setAnnotationChanged(boolean un_saved) {
        this.annotations_changed = un_saved;
    }

    public void curationSetIsLoaded(boolean loaded) {
        if (loaded) {
            this.curation_loaded = loaded;
        }
    }

    public boolean handleZoomEvent(ZoomEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof ZoomListener) || l == evt.getSource()) continue;
            ((ZoomListener)l).handleZoomEvent(evt);
        }
        return true;
    }

    public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof AnnotationChangeListener) || l == evt.getSource()) continue;
            ((AnnotationChangeListener)l).handleAnnotationChangeEvent(evt);
        }
        this.annotations_changed = true;
        return this.annotations_changed;
    }

    public boolean handleSetActiveCurStateEvent(SetActiveCurStateEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof SetActiveCurStateListener) || l == evt.getSource()) continue;
            ((SetActiveCurStateListener)l).handleSetActiveCurStateEvent(evt);
        }
        return true;
    }

    public boolean handleNamedFeatureSelectionEvent(NamedFeatureSelectionEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof NamedFeatureSelectionListener) || l == evt.getSource()) continue;
            ((NamedFeatureSelectionListener)l).handleNamedFeatureSelectionEvent(evt);
        }
        return true;
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        FeatureSelectionEvent newEvent = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof FeatureSelectionListener) || l == evt.getSource()) continue;
            if (!(l instanceof SyntenyLinkPanel)) {
                ((FeatureSelectionListener)l).handleFeatureSelectionEvent(evt);
                continue;
            }
            newEvent = new FeatureSelectionEvent((Object)this, evt.getSelection());
            ((FeatureSelectionListener)l).handleFeatureSelectionEvent(newEvent);
        }
        return true;
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        Vector listenersClone = (Vector)this.listeners.clone();
        for (int i = 0; i < listenersClone.size(); ++i) {
            EventListener l = (EventListener)listenersClone.elementAt(i);
            if (!(l instanceof DataLoadListener) || l == evt.getSource()) continue;
            ((DataLoadListener)l).handleDataLoadEvent(evt);
        }
        return true;
    }

    public boolean handleReverseComplementEvent(ReverseComplementEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof ReverseComplementListener) || l == evt.getSource()) continue;
            ((ReverseComplementListener)l).handleReverseComplementEvent(evt);
        }
        return true;
    }

    public boolean handleOrientationEvent(OrientationEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof OrientationListener) || l == evt.getSource()) continue;
            ((OrientationListener)l).handleOrientationEvent(evt);
        }
        return true;
    }

    public boolean handleLazyLoadEvent(LazyLoadEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof LazyLoadListener) || l == evt.getSource()) continue;
            ((LazyLoadListener)l).handleLazyLoadEvent(evt);
        }
        return true;
    }

    public boolean handleResultChangeEvent(ResultChangeEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof ResultChangeListener) || l == evt.getSource()) continue;
            ((ResultChangeListener)l).handleResultChangeEvent(evt);
        }
        return true;
    }

    public boolean handlePropSchemeChangeEvent(PropSchemeChangeEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof PropSchemeChangeListener) || l == evt.getSource()) continue;
            ((PropSchemeChangeListener)l).handlePropSchemeChangeEvent(evt);
        }
        return true;
    }

    public boolean handleBaseFocusEvent(BaseFocusEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof BaseFocusListener) || l == evt.getSource()) continue;
            ((BaseFocusListener)l).handleBaseFocusEvent(evt);
        }
        return true;
    }

    public boolean handleChainedRepaintEvent(ChainedRepaintEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListener l = (EventListener)this.listeners.elementAt(i);
            if (!(l instanceof ChainedRepaintListener) || l == event.getSource()) continue;
            ((ChainedRepaintListener)l).handleChainedRepaint(event);
        }
        return true;
    }

    public boolean handleScrollEvent(ScrollEvent event) {
        ScrollEvent newScrollEvent = new ScrollEvent(this, event.getValue());
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object l = this.listeners.elementAt(i);
            if (!(l instanceof ScrollListener) || l == event.getSource()) continue;
            ((ScrollListener)l).handleScrollEvent(newScrollEvent);
        }
        return true;
    }

    public void windowClosed(WindowEvent e) {
        this.windowClosing(e);
    }

    public void windowClosing(WindowEvent e) {
        ControlledWindow cw = (ControlledWindow)this.windowHash.get(e.getSource());
        if (cw != null) {
            int i;
            Vector children = cw.getChildren();
            for (i = 0; i < children.size(); ++i) {
                ControlledObjectI co;
                EventListener l = (EventListener)children.elementAt(i);
                if (!(l instanceof ControlledObjectI) || (co = (ControlledObjectI)((Object)l)).needsAutoRemoval()) continue;
                return;
            }
            for (i = 0; i < children.size(); ++i) {
                this.removeListener((EventListener)children.elementAt(i));
            }
            this.windowHash.remove(e.getSource());
            cw.getWindow().removeWindowListener(this);
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    class ControlledWindow {
        Window window;
        Vector children;

        public ControlledWindow(Window w) {
            this.window = w;
            this.children = new Vector();
        }

        public void addChild(Object child) {
            this.children.addElement(child);
        }

        public void removeChild(Object child) {
            if (child == null) {
                return;
            }
            this.children.remove(child);
        }

        public Vector getChildren() {
            return this.children;
        }

        public Window getWindow() {
            return this.window;
        }

        public void finalize() {
        }
    }
}

