/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.datamodel.CompositeDataHolder;
import apollo.gui.synteny.CurationManager;

public class AutoSaveThread
extends Thread {
    private String autosaveFile;
    private boolean halt;
    private long saveInterval;
    private ApolloDataAdapterI adapter;

    public AutoSaveThread(String autosaveFile, int saveIntervalMinutes) {
        this.autosaveFile = autosaveFile;
        this.saveInterval = 60000 * saveIntervalMinutes;
        this.setDaemon(true);
    }

    public void setDataAdapter(ApolloDataAdapterI adapter) {
        this.adapter = adapter;
    }

    public void halt() {
        this.halt = true;
        this.interrupt();
    }

    public void run() {
        while (!this.halt) {
            try {
                AutoSaveThread.sleep(this.saveInterval);
                System.err.print("autosaving to " + this.autosaveFile + "...");
                System.err.flush();
                CompositeDataHolder cdh = CurationManager.getCurationManager().getCompositeDataHolder();
                if (cdh != null) {
                    this.adapter.commitChanges(cdh);
                }
                System.err.println("done");
            }
            catch (InterruptedException e) {
            }
            catch (ApolloAdapterException e) {
                Exception realException = (Exception)ApolloAdapterException.getRealException(e);
                System.err.println("Unable to autosave because of: " + realException.toString());
                realException.printStackTrace();
            }
        }
    }
}

