/*
 * Decompiled with CFR 0.152.
 */
package apollo.external;

import apollo.config.Config;
import apollo.datamodel.GenomicRange;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.menus.LinksMenu;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class IgbBridge
implements FeatureSelectionListener {
    private String chromosome;
    private String organism;
    private int igbPort = -1;
    private static final int FIRST_PORT_TO_TRY = 7085;
    private static final int NUMBER_OF_PORTS_TO_TRY = 5;

    public IgbBridge(GenomicRange genRng) {
        this.setGenomicRange(genRng);
    }

    public void setGenomicRange(GenomicRange genRng) {
        this.chromosome = genRng.getChromosome();
        this.organism = genRng.getOrganism();
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        if (!LinksMenu.igbLinksEnabled()) {
            return false;
        }
        if (Config.DEBUG) {
            if (!this.igbIsRunning()) {
                this.dp("cant send off selection to IGB - its not running");
                return false;
            }
            SeqFeatureI selectedFeat = evt.getFeature();
            if (selectedFeat == null) {
                return false;
            }
            try {
                URL url = this.makeRegionUrl(selectedFeat);
                this.dp("Connecting to IGB with URL " + url);
                URLConnection conn = url.openConnection();
                conn.connect();
                conn.getInputStream().close();
            }
            catch (MalformedURLException me) {
                this.dp("malformed url " + me);
                return false;
            }
            catch (IOException ie) {
                System.out.println("unable to connect to igb " + ie);
                return false;
            }
        }
        return true;
    }

    private void connectToUrl(URL url) {
    }

    private boolean igbIsRunning() {
        this.findIgbLocalhostPort();
        return this.igbPort != -1;
    }

    private void findIgbLocalhostPort() {
        for (int i = 0; i < 5 && this.igbPort == -1; ++i) {
            int port = 7085 + i;
            try {
                URL url = this.makePingUrl(port);
                URLConnection conn = url.openConnection();
                conn.connect();
                this.dp("Found an igb port " + port);
                this.igbPort = port;
                continue;
            }
            catch (MalformedURLException e) {
                this.dp("malformed url");
                return;
            }
            catch (IOException e) {
                this.dp("No port found at " + port + " " + e);
            }
        }
    }

    private URL makeRegionUrl(SeqFeatureI selectedFeat) throws MalformedURLException {
        int padding = 400;
        int low = selectedFeat.getLow() - padding;
        if (low < 1) {
            low = 1;
        }
        int high = selectedFeat.getHigh() + padding;
        String urlPrefix = this.makeUrlPrefix();
        String u = urlPrefix + "seqid=chr" + this.chromosome + "&start=" + low + "&end=" + high + "&version=D_melanogaster_Apr_2004 ";
        URL url = new URL(u);
        return url;
    }

    private URL makePingUrl(int port) throws MalformedURLException {
        String pingString = this.makeUrlPrefix(port) + "ping";
        this.dp("pinging " + pingString);
        return new URL(pingString);
    }

    private String makeUrlPrefix() {
        return this.makeUrlPrefix(this.igbPort);
    }

    private String makeUrlPrefix(int port) {
        return "http://localhost:" + port + "/UnibrowControl?";
    }

    private void dp(String s) {
        if (!Config.DEBUG) {
            return;
        }
        System.out.println(s);
    }
}

