/*
 * Decompiled with CFR 0.152.
 */
package apollo.external;

import apollo.config.Config;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.util.MultiException;

public class ApolloControlServer {
    private static final int DEFAULT_SERVER_PORT = 8085;
    private static final String SERVLET_NAME = "ApolloControl";

    public ApolloControlServer() {
        int serverPort = 8085;
        HttpServer httpServer = new HttpServer();
        SocketListener listener = new SocketListener();
        listener.setPort(serverPort);
        httpServer.addListener((HttpListener)listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        ServletHandler servlets = new ServletHandler();
        context.addHandler((HttpHandler)servlets);
        String servletClassName = "apollo.external.ApolloControlServlet";
        ServletHolder sholder = servlets.addServlet(SERVLET_NAME, "/ApolloControl/*", servletClassName);
        sholder.setInitOrder(1);
        httpServer.addContext(context);
        try {
            httpServer.start();
        }
        catch (MultiException e) {
            System.out.println("Http server wont start\n" + (Object)((Object)e));
            e.printStackTrace();
        }
        String s = "http://localhost:" + serverPort + "/" + SERVLET_NAME;
        this.debugPrint("Http server started at " + s);
    }

    private void debugPrint(String m) {
        if (Config.DEBUG) {
            System.out.println(m);
        }
    }
}

