/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.SeqFeatureI;
import apollo.editor.AddTransaction;
import apollo.editor.CompoundTransaction;
import apollo.editor.DeleteTransaction;

public class UpdateParentTransaction
extends CompoundTransaction {
    private SeqFeatureI child;
    private SeqFeatureI oldParent;
    private SeqFeatureI newParent;

    public UpdateParentTransaction(Object src, SeqFeatureI child, SeqFeatureI oldParent) {
        super(src);
        this.child = child;
        this.oldParent = oldParent;
        this.newParent = child.getRefFeature();
        this.addTransaction(this.createDeleteTransaction());
        this.addTransaction(this.createAddTransaction());
    }

    public boolean hasCompoundType() {
        return true;
    }

    public boolean isUpdateParent() {
        return true;
    }

    public String toString() {
        return "CompoundTrans num kids " + this.size() + " UPDATE PARENT";
    }

    protected boolean flattenOnAddingToCompTrans() {
        return false;
    }

    private DeleteTransaction createDeleteTransaction() {
        return new DeleteTransaction(this.child, this.oldParent);
    }

    private AddTransaction createAddTransaction() {
        return new AddTransaction(this.child);
    }
}

