/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.editor.AddTransaction;
import apollo.editor.AnnotationAddEvent;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.editor.AnnotationDeleteEvent;
import apollo.editor.AnnotationEditor;
import apollo.editor.AnnotationUpdateEvent;
import apollo.editor.DeleteTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.TransactionUtil;
import apollo.editor.UpdateTransaction;
import apollo.editor.UserName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransactionManager
implements AnnotationChangeListener,
Serializable {
    private List unflattenedTransactions;
    private List flattenedTransactions;
    private String author = UserName.getUserName();
    private boolean needCoalescence;
    private boolean isCoalescedDone = true;
    private transient AnnotationChangeListener undoListener;

    public TransactionManager() {
        this.unflattenedTransactions = new ArrayList();
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void addTransaction(Transaction trans) {
        this.unflattenedTransactions.add(trans);
    }

    private void addTransaction(AnnotationChangeEvent event) {
        Transaction transaction;
        Iterator it;
        List tns = this.generateTransaction(event);
        if (tns.size() > 0) {
            if (this.needCoalescence) {
                it = tns.iterator();
                while (it.hasNext()) {
                    transaction = (Transaction)it.next();
                    this.coalesceTransaction(transaction, this.unflattenedTransactions);
                }
            } else {
                this.unflattenedTransactions.addAll(tns);
                this.isCoalescedDone = false;
                this.invalidateFlattenedTransactions();
            }
        }
        if (Config.DEBUG) {
            if (tns.size() == 0) {
                System.out.println("No transaction is generated for this type of event: " + event.getClass());
                return;
            }
            it = tns.iterator();
            while (it.hasNext()) {
                transaction = (Transaction)it.next();
                this.debugPrintTrans(transaction);
            }
        }
    }

    private void debugPrintTrans(Transaction trans) {
        if (!AnnotationEditor.DEBUG) {
            return;
        }
        if (trans.isCompound()) {
            this.debugPrintCompoundTrans(trans);
        } else {
            System.out.println("Added new transaction: " + trans.getClass().toString());
            System.out.println("Object class: " + trans.getObjectClassAsString() + "\nOperation: " + trans.getOperationString() + "\nSubpart: " + trans.getSubpart() + "\n" + "Feat: " + trans.getSeqFeature());
            if (trans.isAddPeptide()) {
                System.out.println("isAddPeptide: true");
            }
            System.out.println("\n");
        }
    }

    private void debugPrintCompoundTrans(Transaction compoundTrans) {
        if (!AnnotationEditor.DEBUG) {
            return;
        }
        System.out.println("\nBEGIN of " + compoundTrans + "\n");
        for (int i = 0; i < compoundTrans.size(); ++i) {
            this.debugPrintTrans(compoundTrans.getTransaction(i));
        }
        System.out.println("\nEnd of " + compoundTrans + "\n");
    }

    private void replaceSeqFeature(FeatureSet replacedFeature, FeatureSet newFeature) {
        Transaction tran = null;
        Iterator it = this.unflattenedTransactions.iterator();
        while (it.hasNext()) {
            tran = (Transaction)it.next();
            if (tran.getSeqFeature() == replacedFeature) {
                tran.setSeqFeature(newFeature);
                continue;
            }
            if (!replacedFeature.contains(tran.getSeqFeature())) continue;
            int index = replacedFeature.getFeatureIndex(tran.getSeqFeature());
            tran.setSeqFeature(newFeature.getFeatureAt(index));
        }
    }

    private void coalesceTransaction(Transaction transaction, List list) {
        if (transaction.isCompound()) {
            for (int i = 0; i < transaction.size(); ++i) {
                this.coalesceTransaction(transaction.getTransaction(i), list);
            }
        } else if (transaction.isAdd()) {
            boolean checkForBackwardsCoalesence = !transaction.hasSubpart();
            boolean haveParent = this.haveParentAddTransaction(transaction, list, checkForBackwardsCoalesence);
            if (haveParent) {
                return;
            }
            list.add(transaction);
        } else if (transaction instanceof UpdateTransaction) {
            int index = this.searchAddTransaction(transaction, list);
            if (index >= 0) {
                return;
            }
            index = this.searchUpdateTransaction(transaction, list);
            if (index == -1) {
                list.add(transaction);
            } else {
                UpdateTransaction prevTn = (UpdateTransaction)list.get(index);
                UpdateTransaction newTn = (UpdateTransaction)transaction;
                newTn.setOldSubpartValue(prevTn.getOldSubpartValue());
                list.add(newTn);
                list.remove(index);
            }
        } else if (transaction.isDelete()) {
            SeqFeatureI deletedFeat = transaction.getSeqFeature();
            boolean haveParent = this.haveParentAddTransaction(transaction, list);
            if (haveParent) {
                return;
            }
            if (!transaction.hasSubpart()) {
                boolean isNew = false;
                Transaction tx = null;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    SeqFeatureI originalParent;
                    tx = (Transaction)it.next();
                    SeqFeatureI txFeat = tx.getSeqFeature();
                    if (!isNew && tx.isAdd() && !tx.hasSubpart() && deletedFeat.isIdentical(txFeat)) {
                        isNew = true;
                    }
                    if (deletedFeat.isAncestorOf(txFeat) || deletedFeat.isSameFeat(txFeat)) {
                        it.remove();
                        continue;
                    }
                    if (!tx.isDelete() || (originalParent = tx.getParentFeature()) == null || !deletedFeat.isAncestorOf(originalParent) && !deletedFeat.isIdentical(originalParent)) continue;
                    it.remove();
                }
                if (!isNew) {
                    list.add(transaction);
                }
            } else {
                TransactionSubpart subpart = transaction.getSubpart();
                Object deletedValue = ((DeleteTransaction)transaction).getNewSubpartValue();
                boolean isNew = false;
                Transaction tx = null;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    tx = (Transaction)it.next();
                    SeqFeatureI tmp = tx.getSeqFeature();
                    if (!isNew && tx instanceof AddTransaction && tx.getSubpart() == subpart && tmp == deletedFeat && ((AddTransaction)tx).getNewSubpartValue() == deletedValue) {
                        isNew = true;
                    }
                    if (!this.shouldRemoveTransaction(tx, subpart, deletedFeat, deletedValue)) continue;
                    it.remove();
                }
                if (!isNew) {
                    list.add(transaction);
                }
            }
        }
    }

    private void checkSplitInvalidation(SeqFeatureI delFeat, Transaction addTrans) {
        if (!delFeat.hasAnnotatedFeature()) {
            return;
        }
        AnnotatedFeatureI delAnnot = delFeat.getAnnotatedFeature();
        if (!delAnnot.isAnnotTop()) {
            return;
        }
    }

    private boolean isPartOfSplit(Transaction tx) {
        if (tx.isSplit()) {
            return true;
        }
        if (!tx.hasParentTransaction()) {
            return false;
        }
        return this.isPartOfSplit(tx.getParentTransaction());
    }

    private boolean shouldRemoveTransaction(Transaction tx, TransactionSubpart subpart, SeqFeatureI deletedFeature, Object deletedValue) {
        if (tx.getSeqFeature() != deletedFeature) {
            return false;
        }
        if (tx.getSubpart() != subpart) {
            return false;
        }
        if (tx instanceof AddTransaction) {
            Object addedValue = ((AddTransaction)tx).getNewSubpartValue();
            return addedValue == deletedValue;
        }
        if (tx instanceof UpdateTransaction) {
            // empty if block
        }
        return false;
    }

    public void coalesce() {
        if (this.isCoalescedDone) {
            return;
        }
        ArrayList list = new ArrayList();
        Transaction tn = null;
        for (int i = 0; i < this.getFlattenedSize(); ++i) {
            tn = this.getFlattenedTransaction(i);
            this.coalesceTransaction(tn, list);
        }
        this.flattenedTransactions.clear();
        this.flattenedTransactions.addAll(list);
        this.invalidateUnflattenedTransactions();
        this.isCoalescedDone = true;
    }

    private int searchUpdateTransaction(Transaction newUpdate, List list) {
        Transaction tn = null;
        int index = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            tn = (Transaction)it.next();
            if (tn instanceof UpdateTransaction && tn.getSeqFeature() == newUpdate.getSeqFeature() && tn.getSubpart() == newUpdate.getSubpart()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int searchAddTransaction(Transaction srcTn, List list) {
        Transaction tn = null;
        int index = 0;
        SeqFeatureI feature = srcTn.getSeqFeature();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            tn = (Transaction)it.next();
            if (tn instanceof AddTransaction && this.canAbsorbUpdateTn(tn, srcTn)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean canAbsorbUpdateTn(Transaction addTn, Transaction updateTn) {
        if (addTn.getSeqFeature() == updateTn.getSeqFeature() && addTn.getSubpart() == updateTn.getSubpart() && addTn.getSubpartRank() == updateTn.getSubpartRank()) {
            return true;
        }
        return addTn.getSeqFeature().contains(updateTn.getSeqFeature()) && addTn.getSubpart() == null;
    }

    private boolean haveParentAddTransaction(Transaction transaction, List list) {
        return this.haveParentAddTransaction(transaction, list, false);
    }

    private boolean haveParentAddTransaction(Transaction transaction, List transactions, boolean checkForBackwardsCoalesence) {
        SeqFeatureI feature = transaction.getSeqFeature();
        if (transaction.isDelete() && !transaction.hasSubpart()) {
            feature = transaction.getParentFeature();
        }
        Transaction tn = null;
        int index = 0;
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            tn = (Transaction)it.next();
            if (tn.isAdd()) {
                SeqFeatureI addedFeature = tn.getSeqFeature();
                if (addedFeature.isAncestorOf(feature) && !tn.hasSubpart()) {
                    return true;
                }
                if (checkForBackwardsCoalesence && feature.isAncestorOf(addedFeature)) {
                    if (Config.DEBUG) {
                        System.out.println("backward remove " + addedFeature);
                    }
                    it.remove();
                }
            }
            ++index;
        }
        return false;
    }

    protected List generateTransaction(AnnotationChangeEvent e) {
        ArrayList<Transaction> rtn = new ArrayList<Transaction>(2);
        boolean needAddToList = true;
        Transaction transaction = null;
        if (e.hasTransaction()) {
            if (e.getTransaction().isCompound() && !e.getTransaction().hasKids()) {
                return rtn;
            }
            rtn.add(e.getTransaction());
            return rtn;
        }
        if (e.isAdd()) {
            if (e.getSubpart() == null) {
                transaction = new AddTransaction(e.getAddedFeature());
            } else {
                int index = e.getSubpartRank();
                Object newValue = null;
                if (e.getSubpart() == TransactionSubpart.SYNONYM) {
                    newValue = ((AnnotatedFeatureI)e.getAddedFeature()).getSynonyms().get(index);
                } else if (e.getSubpart() == TransactionSubpart.COMMENT) {
                    newValue = ((AnnotatedFeatureI)e.getAddedFeature()).getComments().get(index);
                } else if (e.getSubpart() == TransactionSubpart.DBXREF) {
                    newValue = ((AnnotatedFeatureI)e.getAddedFeature()).getDbXrefs().get(index);
                }
                transaction = new AddTransaction(e.getAddedFeature(), e.getSubpart(), newValue);
                transaction.setSubpartRank(index);
            }
        } else if (e.isDelete()) {
            if (e.getSubpart() == null) {
                transaction = new DeleteTransaction((SeqFeatureI)e.getDeletedFeature(), e.getParentFeature());
            } else {
                AnnotationDeleteEvent deleteEvent = (AnnotationDeleteEvent)e;
                if (deleteEvent.getSubpart() == TransactionSubpart.COMMENT) {
                    transaction = new DeleteTransaction(deleteEvent.getChangedFeature(), deleteEvent.getSubpart(), (Object)deleteEvent.getOldComment());
                } else if (deleteEvent.getSubpart() == TransactionSubpart.SYNONYM) {
                    transaction = new DeleteTransaction(deleteEvent.getChangedFeature(), deleteEvent.getSubpart(), (Object)deleteEvent.getOldString());
                }
                transaction.setSubpartRank(e.getSubpartRank());
            }
        } else if (e.isUpdate()) {
            if (e.getSubpart() == null) {
                throw new IllegalStateException("TransactionManager.generateTransaction(): No subpart for AnnotationChangeEvent");
            }
            transaction = new UpdateTransaction(e.getChangedFeature(), e.getSubpart());
            SeqFeatureI changedFeature = e.getChangedFeature();
            TransactionSubpart subpart = e.getSubpart();
            AnnotationUpdateEvent updateEvent = (AnnotationUpdateEvent)e;
            if (changedFeature instanceof ExonI) {
                if (subpart == TransactionSubpart.LIMITS) {
                    RangeI range = updateEvent.getOldRange();
                    ((UpdateTransaction)transaction).setOldSubpartValue(range);
                    this.updateExonID(changedFeature);
                }
            } else if (changedFeature.getFeatureType().equals("transcript") || changedFeature.getAnnotatedFeature().isAnnotTop()) {
                this.extractPreValue(updateEvent, subpart, (UpdateTransaction)transaction);
            }
        }
        if (transaction != null) {
            transaction.setSource(e.getSource());
            if (needAddToList) {
                rtn.add(transaction);
            }
        }
        return rtn;
    }

    public List getFlattenedTransactions() {
        if (this.flattenedTransactions == null) {
            this.flattenedTransactions = new ArrayList(this.size());
            if (this.unflattenedTransactions == null) {
                return this.flattenedTransactions;
            }
            for (int i = 0; i < this.size(); ++i) {
                Transaction unflatTrans = this.getUnflattenedTransaction(i);
                this.flattenedTransactions.addAll(unflatTrans.getLeafTransactions());
            }
        }
        return this.flattenedTransactions;
    }

    private void invalidateFlattenedTransactions() {
        this.flattenedTransactions = null;
    }

    private Transaction getFlattenedTransaction(int i) {
        return (Transaction)this.getFlattenedTransactions().get(i);
    }

    private int getFlattenedSize() {
        return this.getFlattenedTransactions().size();
    }

    public void replaceIdUpdatesWithDelAndAdd() {
        ArrayList<Transaction> newFlatTransactions = new ArrayList<Transaction>(this.getFlattenedSize());
        boolean transChanged = false;
        for (int i = 0; i < this.getFlattenedSize(); ++i) {
            Transaction trans = this.getFlattenedTransaction(i);
            if (trans.isUpdate() && trans.getSubpart().isId()) {
                AnnotatedFeature deletedFeat = new AnnotatedFeature();
                deletedFeat.setId(trans.getOldString());
                SeqFeatureI parent = trans.getSeqFeature().getRefFeature();
                Transaction tr = new DeleteTransaction((SeqFeatureI)deletedFeat, parent, (Object)this);
                newFlatTransactions.add(tr);
                tr = new AddTransaction(trans.getSeqFeature());
                newFlatTransactions.add(tr);
                transChanged = true;
                if (!AnnotationEditor.DEBUG) continue;
                System.out.println("id update->del,add");
                continue;
            }
            newFlatTransactions.add(trans);
        }
        this.flattenedTransactions = newFlatTransactions;
        if (transChanged) {
            this.invalidateUnflattenedTransactions();
            this.isCoalescedDone = false;
        }
    }

    private boolean isNewFeature(SeqFeatureI feature) {
        Transaction tn = null;
        Iterator it = this.unflattenedTransactions.iterator();
        while (it.hasNext()) {
            tn = (Transaction)it.next();
            if (!tn.isAdd() || tn.getSubpart() != null || !tn.getSeqFeature().isIdentical(feature)) continue;
            return true;
        }
        return false;
    }

    private void updateExonID(SeqFeatureI exon) {
        Transcript transcript = (Transcript)exon.getParent();
        AnnotatedFeatureI gene = transcript.getGene();
        exon.setId(gene.getId() + ":" + exon.getStart() + "-" + exon.getEnd());
    }

    private void extractPreValue(AnnotationUpdateEvent updateEvent, TransactionSubpart subpart, UpdateTransaction transaction) {
        Object oldValue = null;
        if (updateEvent.isIntUpdate()) {
            oldValue = new Integer(updateEvent.getOldInt());
        } else if (updateEvent.isStringUpdate()) {
            oldValue = updateEvent.getOldString();
        } else if (updateEvent.isBooleanUpdate()) {
            oldValue = new Boolean(!TransactionUtil.getBoolean(updateEvent.getChangedAnnot(), subpart));
        } else if (updateEvent.isCommentUpdate()) {
            oldValue = updateEvent.getOldComment();
            transaction.setSubpartRank(updateEvent.getSubpartRank());
        } else if (updateEvent.isRangeUpdate()) {
            oldValue = updateEvent.getOldRange();
        }
        transaction.setOldSubpartValue(oldValue);
    }

    public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
        if (evt.getSource() == this) {
            return false;
        }
        this.addTransaction(evt);
        return true;
    }

    public void setTransactions(List list) {
        this.unflattenedTransactions.clear();
        this.flattenedTransactions = null;
        if (list != null) {
            this.unflattenedTransactions.addAll(list);
        }
    }

    public List getTransactions() {
        if (this.unflattenedTransactions == null && this.flattenedTransactions != null) {
            this.unflattenedTransactions = this.makeUnflattenedFromFlattened();
        }
        return this.unflattenedTransactions;
    }

    private void invalidateUnflattenedTransactions() {
        this.unflattenedTransactions = this.flattenedTransactions;
    }

    private List makeUnflattenedFromFlattened() {
        if (AnnotationEditor.DEBUG) {
            System.out.println("DEBUG: Just using flattened trans - make sure ok");
            new Throwable().printStackTrace();
        }
        return this.flattenedTransactions;
    }

    public void undo(Object source) {
        for (int i = this.numberOfTransactions() - 1; i >= 0; --i) {
            Transaction trans = this.getTransaction(i);
            if (trans.getSource() != source) continue;
            this.undo(trans);
            return;
        }
    }

    private void undo(Transaction t) {
        if (t.isCompound()) {
            this.undoCompound(t);
            this.unflattenedTransactions.remove(t);
            this.invalidateFlattenedTransactions();
            return;
        }
        if (!t.getSeqFeature().hasAnnotatedFeature()) {
            return;
        }
        if (!t.hasSubpart()) {
            return;
        }
        if (t.isUpdate()) {
            this.undoUpdate((UpdateTransaction)t);
        } else if (t.isAdd()) {
            this.undoAdd(t);
        } else if (t.isDelete()) {
            this.undoDelete(t);
        }
        this.unflattenedTransactions.remove(t);
        this.invalidateFlattenedTransactions();
    }

    private void undoCompound(Transaction t) {
        t.undo();
        AnnotationChangeEvent a = t.generateAnnotationChangeEvent(this);
        this.fireAnnotEvent(a);
    }

    private void undoUpdate(UpdateTransaction trans) {
        AnnotatedFeatureI af = trans.getSeqFeature().getAnnotatedFeature();
        TransactionSubpart ts = trans.getSubpart();
        if (ts.isBoolean()) {
            TransactionUtil.flipBoolean(af, ts);
        } else if (ts.isName()) {
            this.nameUndoTempHack(trans);
        } else if (ts.isType()) {
            this.typeUndoTempHack(trans);
        } else if (ts.isId()) {
            trans.undo();
        } else if (ts.isComment()) {
            TransactionUtil.undoUpdateComment(trans, af);
        } else {
            return;
        }
        boolean isSingularEvent = true;
        AnnotationUpdateEvent au = new AnnotationUpdateEvent(this, af, ts, isSingularEvent);
        this.fireAnnotEvent(au);
    }

    private void undoAdd(Transaction trans) {
        TransactionSubpart ts = trans.getSubpart();
        if (ts.isComment()) {
            TransactionUtil.undoAddComment(trans);
        } else if (ts.isSynonym()) {
            trans.undo();
        } else {
            return;
        }
        AnnotatedFeatureI af = trans.getAnnotatedFeature();
        boolean isSingularEvent = true;
        AnnotationDeleteEvent ad = new AnnotationDeleteEvent(this, af, ts, isSingularEvent);
        this.fireAnnotEvent(ad);
    }

    private void undoDelete(Transaction trans) {
        TransactionSubpart ts = trans.getSubpart();
        if (ts.isComment()) {
            TransactionUtil.undoDeleteComment(trans);
        } else if (ts.isSynonym()) {
            trans.undo();
        } else {
            return;
        }
        AnnotatedFeatureI af = trans.getAnnotatedFeature();
        boolean isSingularEvent = true;
        AnnotationAddEvent ad = new AnnotationAddEvent(this, af, ts, isSingularEvent);
        this.fireAnnotEvent(ad);
    }

    private void nameUndoTempHack(UpdateTransaction nameTrans) {
        nameTrans.undo();
        int index = this.unflattenedTransactions.indexOf(nameTrans);
        Transaction nextTrans = this.getTransaction(index - 1);
        if (nextTrans != null && nextTrans.hasSubpart() && nextTrans.getSubpart().isName()) {
            this.nameUndoTempHack((UpdateTransaction)nextTrans);
            this.unflattenedTransactions.remove(nextTrans);
        }
    }

    private void typeUndoTempHack(UpdateTransaction typeTrans) {
        typeTrans.undo();
    }

    public void setAnnotationChangeListener(AnnotationChangeListener acl) {
        this.undoListener = acl;
    }

    private void fireAnnotEvent(AnnotationChangeEvent a) {
        if (this.undoListener == null) {
            System.err.println("no undo listener in TranManager for undo");
            return;
        }
        this.undoListener.handleAnnotationChangeEvent(a);
    }

    public boolean hasTransactions() {
        return (this.unflattenedTransactions != null || this.flattenedTransactions != null) && this.numberOfTransactions() > 0;
    }

    public int numberOfTransactions() {
        return this.unflattenedTransactions.size();
    }

    public int size() {
        return this.numberOfTransactions();
    }

    public Transaction getTransaction(int i) {
        if (i < 0 || i >= this.numberOfTransactions()) {
            return null;
        }
        return (Transaction)this.unflattenedTransactions.get(i);
    }

    private Transaction getUnflattenedTransaction(int i) {
        return this.getTransaction(i);
    }

    public boolean isCoalescedDone() {
        return this.isCoalescedDone;
    }

    public void emptyTransactions() {
        this.clear();
    }

    public void clear() {
        if (this.unflattenedTransactions != null) {
            this.unflattenedTransactions.clear();
        }
        this.flattenedTransactions = null;
    }

    public boolean featureHasBeenEdited(SeqFeatureI feat) {
        for (int i = 0; i < this.numberOfTransactions(); ++i) {
            Transaction t = this.getTransaction(i);
            if (!(t.isCompound() ? this.featInCompoundTrans(feat, t) : t.getSeqFeature() != null && t.getSeqFeature().descendsFrom(feat))) continue;
            return true;
        }
        return false;
    }

    private boolean featInCompoundTrans(SeqFeatureI feat, Transaction compTrans) {
        for (int i = 0; i < compTrans.size(); ++i) {
            Transaction kidTrans = compTrans.getTransaction(i);
            if (kidTrans.isCompound()) {
                return this.featInCompoundTrans(feat, kidTrans);
            }
            if (kidTrans.getSeqFeature() == null) {
                if (AnnotationEditor.DEBUG) {
                    System.out.println("DEBUG error: transaction with no feat, trace:");
                    new Throwable().printStackTrace();
                }
                return false;
            }
            if (!compTrans.getTransaction(i).getSeqFeature().descendsFrom(feat)) continue;
            return true;
        }
        return false;
    }
}

