/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.config.Config;
import apollo.dataadapter.gamexml.GAMESave;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationEditor;
import apollo.editor.CompoundTransaction;
import apollo.editor.FeatureChangeEvent;
import apollo.editor.TransactionClass;
import apollo.editor.TransactionOperation;
import apollo.editor.TransactionSubpart;
import apollo.editor.UserName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class Transaction
implements Serializable {
    protected Date date;
    protected String author;
    private TransactionClass transactionClass;
    private TransactionOperation transactionOperation;
    private TransactionSubpart transactionSubpart;
    private Object newSubpartValue;
    private Object oldSubpartValue;
    protected Hashtable oldProperties = new Hashtable(1, 1.0f);
    protected Hashtable newProperties = new Hashtable(1, 1.0f);
    private CompoundTransaction parentTransaction;
    public static int OLD = 1;
    public static int NEW = 2;
    private SeqFeatureI feature;
    private transient Object source;
    private int subpartRank;
    private String oldId = null;
    private String newId;

    public Transaction(FeatureChangeEvent ace) {
        this();
        this.setOperation(ace.getOperationAsString());
        this.setObjectClass(ace.getObjectClassAsString());
        this.feature = ace.getChangedFeature();
    }

    public Transaction() {
        this.date = new Date();
        this.author = UserName.getUserName();
    }

    void undo() {
        if (AnnotationEditor.DEBUG) {
            System.out.println("Transaction subclass needs to implement undo " + this);
        }
    }

    public void setDate(String date) {
        try {
            this.date = new SimpleDateFormat().parse(date);
        }
        catch (Exception ex) {
            this.date = new Date();
        }
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setAuthor(String name) {
        this.author = name;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean isUpdate() {
        return false;
    }

    public boolean isAdd() {
        return false;
    }

    public boolean isAddPeptide() {
        return false;
    }

    public boolean isDelete() {
        return false;
    }

    public boolean isCompound() {
        return false;
    }

    public boolean isSplit() {
        return false;
    }

    public boolean isMerge() {
        return false;
    }

    public boolean isUpdateParent() {
        return false;
    }

    public AnnotatedFeatureI getNewSplitFeature() {
        return null;
    }

    public SeqFeatureI getDeletedFeature() {
        if (!this.isDelete()) {
            return null;
        }
        return this.feature;
    }

    public void setSubpart(TransactionSubpart transactionSubpart) {
        this.transactionSubpart = transactionSubpart;
    }

    private void setSubpart(String subpartString) {
        this.transactionSubpart = TransactionSubpart.stringToSubpart(subpartString);
    }

    public TransactionSubpart getSubpart() {
        return this.transactionSubpart;
    }

    boolean hasSubpart() {
        return this.getSubpart() != null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.transactionSubpart != null) {
            this.setSubpart(this.transactionSubpart.toString());
        }
    }

    public AnnotationChangeEvent generateAnnotationChangeEvent(Object source) {
        this.setSource(source);
        AnnotationChangeEvent ace = this.generateAnnotationChangeEvent();
        ace.setSource(source);
        return ace;
    }

    AnnotationChangeEvent generateAnnotationChangeEvent() {
        if (AnnotationEditor.DEBUG) {
            System.out.println("DEBUG WARNING: subclass not overriding Transaction.genACE()" + this);
        }
        return new AnnotationChangeEvent(this);
    }

    public void setSeqFeature(SeqFeatureI feature) {
        this.feature = feature;
        if (AnnotationEditor.DEBUG && feature == null) {
            System.out.println("Transaction set with null feature. StackTrace:");
            new Throwable().printStackTrace();
        }
    }

    public SeqFeatureI getSeqFeature() {
        return this.feature;
    }

    AnnotatedFeatureI getAnnotatedFeature() {
        return this.getSeqFeature().getAnnotatedFeature();
    }

    SeqFeatureI getParentFeature() {
        return null;
    }

    public void setSource(Object src) {
        this.source = src;
    }

    Object getSource() {
        return this.source;
    }

    public void setOldSubpartValue(Object preValue) {
        this.oldSubpartValue = preValue;
    }

    boolean hasOldSubpartValue() {
        return this.getOldSubpartValue() != null;
    }

    public Object getOldSubpartValue() {
        return this.oldSubpartValue;
    }

    private boolean isComment() {
        return this.transactionSubpart == TransactionSubpart.COMMENT;
    }

    public Comment getOldComment() {
        if (!this.isComment()) {
            return null;
        }
        return (Comment)this.getOldSubpartValue();
    }

    public String getOldString() {
        if (!(this.getOldSubpartValue() instanceof String)) {
            return null;
        }
        return (String)this.getOldSubpartValue();
    }

    public void setOldId(String id) {
        this.oldId = id;
    }

    public String getOldId() {
        return this.oldId;
    }

    public void setNewId(String newId) {
        this.newId = newId;
    }

    public String getNewId() {
        return this.newId;
    }

    public void setSubpartRank(int rank) {
        this.subpartRank = rank;
    }

    public int getSubpartRank() {
        return this.subpartRank;
    }

    public void setNewSubpartValue(Object obj) {
        this.newSubpartValue = obj;
        if (Config.DEBUG && obj == null) {
            System.out.println("Transaction subpart value set to null, stacktrace:");
            new Throwable().printStackTrace();
        }
    }

    public Object getNewSubpartValue() {
        return this.newSubpartValue;
    }

    public boolean subpartIsString() {
        return this.getNewSubpartValue() instanceof String;
    }

    public String getSubpartString() {
        if (!this.subpartIsString()) {
            System.out.println("Error: subpart is not string");
        }
        return (String)this.getNewSubpartValue();
    }

    public int size() {
        return 0;
    }

    public boolean hasKids() {
        return this.size() > 0;
    }

    public Transaction getTransaction(int i) {
        return null;
    }

    void setParentTransaction(CompoundTransaction parent) {
        this.parentTransaction = parent;
    }

    public CompoundTransaction getParentTransaction() {
        return this.parentTransaction;
    }

    public boolean hasParentTransaction() {
        return this.getParentTransaction() != null;
    }

    public List getLeafTransactions() {
        ArrayList<Transaction> leaves = new ArrayList<Transaction>(1);
        leaves.add(this);
        return leaves;
    }

    public String toString() {
        String s = "\nOperation: " + this.getOperationString() + "\nClass: " + this.getClassString();
        if (this.hasSubpart()) {
            s = s + "\nSubpart: " + this.getSubpart();
        }
        return s;
    }

    protected String getOperationString() {
        return null;
    }

    public String getClassString() {
        return this.feature.getFeatureType();
    }

    public void setOperation(TransactionOperation operation) {
        this.transactionOperation = operation;
    }

    public void setOperation(String operation) {
        this.transactionOperation = TransactionOperation.stringToOperation(operation);
    }

    public TransactionOperation getOperation() {
        return this.transactionOperation;
    }

    public void setObjectClass(String objectClass) {
        this.transactionClass = TransactionClass.stringToClass(objectClass);
    }

    public TransactionClass getObjectClass() {
        return this.transactionClass;
    }

    String getObjectClassAsString() {
        if (this.isCompound()) {
            return "COMPOUND";
        }
        if (this.getSeqFeature() == null) {
            return null;
        }
        return this.getSeqFeature().getClass().toString();
    }

    public void addProperty(String name, String value, int oldOrNew) {
        Hashtable properties = oldOrNew == OLD ? this.oldProperties : this.newProperties;
        if (value != null && !value.equals("")) {
            Vector values;
            if (properties.get(name) == null) {
                values = new Vector();
                properties.put(name, values);
            } else {
                values = (Vector)properties.get(name);
            }
            values.addElement(value);
        }
    }

    public String getProperty(String name, int oldOrNew) {
        Hashtable properties = oldOrNew == OLD ? this.oldProperties : this.newProperties;
        if (properties == null || properties.get(name) == null) {
            return "";
        }
        Vector values = (Vector)properties.get(name);
        return (String)values.lastElement();
    }

    private Vector getPropertyMulti(String name, int oldOrNew) {
        Hashtable properties = oldOrNew == OLD ? this.oldProperties : this.newProperties;
        if (properties == null) {
            return null;
        }
        return (Vector)properties.get(name);
    }

    public String toString(String indent) {
        StringBuffer buf = new StringBuffer();
        buf.append(indent + "<transaction>\n");
        buf.append(GAMESave.writeDate(indent + indent, this.getDate(), ""));
        buf.append(indent + indent + "<author>" + this.getAuthor() + "</author>\n");
        buf.append(indent + indent + "<object_class>" + this.getObjectClass() + "</object_class>\n");
        buf.append(indent + indent + "<operation>" + this.getOperation() + "</operation>\n");
        String transactionInfo = this.transactionInfo(indent);
        if (transactionInfo.equals("")) {
            return "";
        }
        buf.append(transactionInfo);
        buf.append(indent + "</transaction>\n");
        return buf.toString();
    }

    private String transactionInfo(String indent) {
        String prop;
        Vector<String> list = new Vector<String>();
        Enumeration e = this.oldProperties.keys();
        while (e.hasMoreElements()) {
            prop = (String)e.nextElement();
            if (list.contains(prop)) continue;
            list.addElement(prop);
        }
        e = this.newProperties.keys();
        while (e.hasMoreElements()) {
            prop = (String)e.nextElement();
            if (list.contains(prop)) continue;
            list.addElement(prop);
        }
        return this.infoBlock(indent, list);
    }

    private String infoBlock(String indent, Vector keys) {
        int j;
        String key;
        int i;
        StringBuffer buf = new StringBuffer();
        boolean haveContent = false;
        buf.append(this.startTag("before", indent + indent));
        for (i = 0; i < keys.size(); ++i) {
            key = (String)keys.elementAt(i);
            Vector valuesBefore = this.getPropertyMulti(key, OLD);
            for (j = 0; valuesBefore != null && j < valuesBefore.size(); ++j) {
                String valueBefore = (String)valuesBefore.elementAt(j);
                if (valueBefore == null || valueBefore.equals("")) continue;
                buf.append(indent + indent + indent + "<" + key + ">" + valueBefore + "</" + key + ">\n");
                haveContent = true;
            }
        }
        buf.append(this.endTag("before", indent + indent));
        buf.append(this.startTag("after", indent + indent));
        for (i = 0; i < keys.size(); ++i) {
            key = (String)keys.elementAt(i);
            Vector valuesAfter = this.getPropertyMulti(key, NEW);
            for (j = 0; valuesAfter != null && j < valuesAfter.size(); ++j) {
                String valueAfter = (String)valuesAfter.elementAt(j);
                if (valueAfter == null || valueAfter.equals("")) continue;
                buf.append(indent + indent + indent + "<" + key + ">" + valueAfter + "</" + key + ">\n");
                haveContent = true;
            }
        }
        buf.append(this.endTag("after", indent + indent));
        if (!haveContent) {
            return "";
        }
        return buf.toString();
    }

    private String startTag(String tag, String indent) {
        return indent + "<" + tag + ">\n";
    }

    private String endTag(String tag, String indent) {
        return indent + "</" + tag + ">\n";
    }
}

