/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.util.FeatureList;
import java.util.HashMap;
import java.util.Vector;
import org.bdgp.util.Comparator;
import org.bdgp.util.VectorUtil;

class SelectionSet {
    private Vector leafFeatures;
    private FeatureList leafFeatList;
    private Vector sets;
    private Vector transcripts;
    private Vector annots;
    private Vector originalFeatures;
    private boolean used = false;
    private RangeCompare rangeComparator = new RangeCompare();

    SelectionSet(Vector df) {
        this.init(df);
    }

    private void init(Vector feat_vect) {
        if (feat_vect != null) {
            this.originalFeatures = feat_vect;
            this.leafFeatures = this.findLeafFeatures(feat_vect);
            this.sets = this.findSets(this.leafFeatures);
            this.findTranscriptsAndAnnots(this.leafFeatures);
        } else {
            this.originalFeatures = new Vector(0);
            this.leafFeatures = new Vector(0);
            this.sets = new Vector(0);
            this.transcripts = new Vector(0);
            this.annots = new Vector(0);
        }
        this.setUsed(false);
    }

    void setUsed(boolean state) {
        this.used = state;
    }

    Vector getLeafFeatures() {
        return this.leafFeatures;
    }

    FeatureList getLeafFeatList() {
        if (this.leafFeatList == null) {
            this.leafFeatList = new FeatureList(this.leafFeatures);
        }
        return this.leafFeatList;
    }

    SeqFeatureI getLeafFeat(int index) {
        Object elem = this.leafFeatures.elementAt(index);
        if (elem instanceof SeqFeatureI) {
            return (SeqFeatureI)elem;
        }
        System.err.println("Non SeqFeatureI in features");
        return null;
    }

    Vector getSets() {
        return this.sets;
    }

    Vector getTranscripts() {
        return this.transcripts;
    }

    FeatureList getTranscriptList() {
        return new FeatureList(this.transcripts);
    }

    int getTranscriptsSize() {
        return this.transcripts.size();
    }

    Transcript getTranscript(int index) {
        Object elem = this.transcripts.elementAt(index);
        if (elem instanceof Transcript) {
            return (Transcript)elem;
        }
        System.err.println("Non Transcript in transcripts");
        return null;
    }

    public Transcript getFirstFullySelectedTranscript() {
        HashMap<Transcript, Integer> transToExonNum = new HashMap<Transcript, Integer>(5);
        for (int i = 0; i < this.originalFeatures.size(); ++i) {
            SeqFeatureI sf = (SeqFeatureI)this.originalFeatures.elementAt(i);
            if (sf instanceof Transcript) {
                return (Transcript)sf;
            }
            if (!(sf instanceof ExonI)) continue;
            Transcript trans = (Transcript)sf.getRefFeature();
            int numExons = 1;
            if (transToExonNum.containsKey(trans)) {
                numExons += ((Integer)transToExonNum.get(trans)).intValue();
            }
            if (trans.getFeatures().size() == numExons) {
                return trans;
            }
            transToExonNum.remove(trans);
            transToExonNum.put(trans, new Integer(numExons));
        }
        return null;
    }

    Vector getGenes() {
        return this.annots;
    }

    FeatureList getGeneList() {
        return new FeatureList(this.annots);
    }

    public AnnotatedFeatureI getGene(int index) {
        Object elem = this.annots.elementAt(index);
        AnnotatedFeatureI sf = null;
        if (elem instanceof AnnotatedFeatureI && !(sf = (AnnotatedFeatureI)elem).isAnnotTop()) {
            sf = null;
        }
        if (sf == null) {
            System.err.println("Non Gene in genes");
        }
        return sf;
    }

    private void findTranscriptsAndAnnots(Vector features) {
        this.transcripts = new Vector();
        this.annots = new Vector();
        for (int i = 0; i < features.size(); ++i) {
            Object elem = features.elementAt(i);
            SeqFeatureI sf = null;
            if (elem instanceof DrawableSeqFeature) {
                DrawableSeqFeature dsf = (DrawableSeqFeature)elem;
                sf = dsf.getFeature();
            } else if (elem instanceof SeqFeatureI) {
                sf = (SeqFeatureI)elem;
            } else {
                System.out.println("ERROR: Non DrawableSeqFeature, non SeqFeatureI in findTranscripts");
            }
            if (sf == null) continue;
            if (sf.isExon()) {
                this.addTranscript(sf.getRefFeature());
                continue;
            }
            if (sf.isTranscript()) {
                this.addTranscript(sf);
                continue;
            }
            if (!sf.isAnnot()) continue;
            int j = 0;
            while (i < sf.getNumberOfChildren()) {
                this.addTranscript(sf.getFeatureAt(j));
                ++j;
            }
            this.addAnnot(sf);
        }
        this.sortRanges(this.transcripts);
        this.sortRanges(this.annots);
    }

    private void sortRanges(Vector ranges) {
        VectorUtil.sort((Vector)ranges, (Comparator)this.rangeComparator);
    }

    private void addTranscript(SeqFeatureI trans) {
        if (trans != null && !this.transcripts.contains(trans)) {
            this.transcripts.add(trans);
        }
        this.addAnnot(trans.getRefFeature());
    }

    private void addAnnot(SeqFeatureI annot) {
        if (annot != null && !this.annots.contains(annot)) {
            this.annots.add(annot);
        }
    }

    private Vector findLeafFeatures(Vector features) {
        Vector sets = new Vector();
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI sf = (SeqFeatureI)features.elementAt(i);
            this.addLeafFeats(sf, sets);
        }
        return sets;
    }

    private void addLeafFeats(SeqFeatureI sf, Vector sets) {
        if (sf.hasKids()) {
            FeatureSetI fs = (FeatureSetI)sf;
            int fs_size = fs.size();
            for (int i = 0; i < fs_size; ++i) {
                this.addLeafFeats(fs.getFeatureAt(i), sets);
            }
        } else {
            sets.addElement(sf);
        }
    }

    private Vector findSets(Vector features) {
        Vector<FeatureSetI> sets = new Vector<FeatureSetI>();
        for (int i = 0; i < features.size(); ++i) {
            Object elem = features.elementAt(i);
            SeqFeatureI sf = null;
            if (elem instanceof DrawableSeqFeature) {
                DrawableSeqFeature dsf = (DrawableSeqFeature)elem;
                sf = dsf.getFeature();
            } else if (elem instanceof SeqFeatureI) {
                sf = (SeqFeatureI)elem;
            } else {
                System.out.println("ERROR: Non DrawableSeqFeature, non SeqFeatureI in findSets");
            }
            if (sf == null) continue;
            FeatureSetI set = null;
            set = sf.canHaveChildren() ? (FeatureSetI)sf : (FeatureSetI)sf.getRefFeature();
            if (set == null || sets.contains(set)) continue;
            sets.addElement(set);
        }
        return sets;
    }

    private Vector findAnnots(Vector tran) {
        Vector<SeqFeatureI> annots = new Vector<SeqFeatureI>();
        for (int i = 0; i < tran.size(); ++i) {
            Transcript t = (Transcript)tran.elementAt(i);
            if (annots.contains(t.getRefFeature())) continue;
            annots.addElement(t.getRefFeature());
        }
        return annots;
    }

    public void dump(String desc) {
        int i;
        System.out.println("Dumping " + desc);
        System.out.println(" Features vector:");
        for (i = 0; i < this.leafFeatures.size(); ++i) {
            System.out.println("  " + (SeqFeatureI)this.leafFeatures.elementAt(i));
        }
        System.out.println(" Sets vector:");
        for (i = 0; i < this.sets.size(); ++i) {
            System.out.println("  " + (FeatureSetI)this.sets.elementAt(i));
        }
        System.out.println(" Transcripts vector:");
        for (i = 0; i < this.transcripts.size(); ++i) {
            System.out.println("  " + (Transcript)this.transcripts.elementAt(i));
        }
        System.out.println(" Gene vector:");
        for (i = 0; i < this.annots.size(); ++i) {
            System.out.println("  " + (AnnotatedFeatureI)this.annots.elementAt(i));
        }
        System.out.println(" Used flag = " + this.used);
    }

    private class RangeCompare
    implements Comparator {
        private RangeCompare() {
        }

        public int compare(Object a, Object b) {
            if (a instanceof RangeI && b instanceof RangeI) {
                RangeI ta = (RangeI)a;
                RangeI tb = (RangeI)b;
                if (ta.getStart() == tb.getStart()) {
                    return 0;
                }
                if (ta.getStrand() == 1) {
                    return ta.getStart() < tb.getStart() ? -1 : 1;
                }
                return ta.getStart() > tb.getStart() ? -1 : 1;
            }
            System.out.println("Comparing a " + a.getClass().getName() + " to b " + b.getClass().getName());
            return 0;
        }
    }
}

