/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationCompoundEvent;
import apollo.editor.AnnotationEditor;
import apollo.editor.Transaction;
import java.util.ArrayList;
import java.util.List;

public class CompoundTransaction
extends Transaction {
    private List childTransactions;
    private AnnotatedFeatureI newSplitFeature;
    static final int SPLIT = 1;
    static final int MERGE = 2;
    static final int NO_TYPE = -1;
    private int compoundType = -1;

    public CompoundTransaction(Object source) {
        this.setSource(source);
    }

    CompoundTransaction(int type, Object source) {
        this(source);
        this.setCompoundType(type);
    }

    void setCompoundType(int type) {
        this.compoundType = type;
    }

    public boolean hasCompoundType() {
        return this.compoundType != -1;
    }

    public boolean isSplit() {
        return this.compoundType == 1;
    }

    public boolean isMerge() {
        return this.compoundType == 2;
    }

    public boolean isCompound() {
        return true;
    }

    void undo() {
        for (int i = 0; i < this.size(); ++i) {
            this.getTransaction(i).undo();
        }
    }

    public void addTransaction(Transaction childTrans) {
        if (childTrans == null) {
            return;
        }
        this.addTrans(childTrans);
    }

    private void addTrans(Transaction childTrans) {
        if (this.childTransactions == null) {
            this.childTransactions = new ArrayList();
        }
        this.childTransactions.add(childTrans);
        childTrans.setParentTransaction(this);
        if (this.getSource() != null) {
            childTrans.setSource(this.getSource());
        }
    }

    public void addTransaction(CompoundTransaction addedTrans) {
        if (addedTrans == null) {
            return;
        }
        if (addedTrans == this) {
            System.out.println("Error: Cant add self as kid in CompoundTransaction.addTrans()");
            return;
        }
        if (!addedTrans.hasKids()) {
            return;
        }
        if (!addedTrans.flattenOnAddingToCompTrans()) {
            this.addTrans(addedTrans);
        } else {
            for (int i = 0; i < addedTrans.size(); ++i) {
                this.addTrans(addedTrans.getTransaction(i));
            }
        }
    }

    protected boolean flattenOnAddingToCompTrans() {
        return !this.hasCompoundType();
    }

    public Transaction getTransaction(int i) {
        return (Transaction)this.childTransactions.get(i);
    }

    public int size() {
        if (this.childTransactions == null) {
            return 0;
        }
        return this.childTransactions.size();
    }

    public String toString() {
        String s = "CompoundTrans num kids " + this.size() + " ";
        if (this.hasCompoundType()) {
            if (this.isSplit()) {
                s = s + "SPLIT";
            }
            if (this.isMerge()) {
                s = s + "MERGE";
            }
            if (this.isUpdateParent()) {
                s = s + "UPDATE PARENT";
            }
        } else {
            s = s + "NO TYPE";
        }
        return s;
    }

    public List getTransactions() {
        return this.childTransactions;
    }

    public void removeTransaction(Transaction transaction) {
        if (this.childTransactions != null) {
            this.childTransactions.remove(transaction);
        }
    }

    public void setSource(Object source) {
        super.setSource(source);
        for (int i = 0; i < this.size(); ++i) {
            this.getTransaction(i).setSource(source);
        }
    }

    AnnotationChangeEvent generateAnnotationChangeEvent() {
        if (this.getSource() == null) {
            if (AnnotationEditor.DEBUG) {
                String m = "DEBUG: Compound trans without src is generating annot cng evt.  Setting src to self for now. Heres a stack trace: ";
                System.out.println(m);
                new Throwable().printStackTrace();
            }
            this.setSource(this);
        }
        return new AnnotationCompoundEvent(this);
    }

    public List getLeafTransactions() {
        ArrayList<Transaction> leaves = new ArrayList<Transaction>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Transaction child = this.getTransaction(i);
            if (child.isCompound()) {
                leaves.addAll(child.getLeafTransactions());
                continue;
            }
            leaves.add(child);
        }
        return leaves;
    }

    void setNewSplitFeature(AnnotatedFeatureI newSplitFeat) {
        this.newSplitFeature = newSplitFeat;
    }

    public AnnotatedFeatureI getNewSplitFeature() {
        return this.newSplitFeature;
    }
}

