/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.CompoundTransaction;
import apollo.editor.Transaction;

public class AnnotationCompoundEvent
extends AnnotationChangeEvent {
    private CompoundTransaction compoundTransaction;

    public AnnotationCompoundEvent(CompoundTransaction ct) {
        super(ct.getSource());
        this.compoundTransaction = ct;
        this.setTransaction(ct);
    }

    public boolean isCompound() {
        return true;
    }

    public int getNumberOfChildren() {
        if (!this.hasTransaction()) {
            return 0;
        }
        return this.getTransaction().size();
    }

    public void addTransaction(Transaction trans) {
        this.compoundTransaction.addTransaction(trans);
    }

    public AnnotationChangeEvent getChildChangeEvent(int i) {
        if (!this.hasTransaction()) {
            return null;
        }
        return this.getTransaction().getTransaction(i).generateAnnotationChangeEvent();
    }

    public boolean isEndOfEditSession() {
        return true;
    }

    public AnnotatedFeatureI getAnnotTop() {
        if (this.getNumberOfChildren() == 0) {
            return null;
        }
        return this.getChildChangeEvent(0).getAnnotTop();
    }

    public boolean isMove() {
        return this.getTransaction().isUpdateParent();
    }
}

