/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationAddEvent;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;

public class AddTransaction
extends Transaction {
    private boolean isPeptide = false;
    private String residues = null;

    public AddTransaction() {
    }

    public AddTransaction(SeqFeatureI feature) {
        this.setSeqFeature(feature);
    }

    AddTransaction(Object source, SeqFeatureI feat) {
        this(feat);
        this.setSource(source);
    }

    AddTransaction(Object source, SeqFeatureI transcript, boolean isPeptide) {
        this(source, transcript);
        this.isPeptide = isPeptide;
    }

    public AddTransaction(SeqFeatureI feature, TransactionSubpart subpart) {
        this.setSeqFeature(feature);
        this.setSubpart(subpart);
    }

    public AddTransaction(SeqFeatureI feature, TransactionSubpart subpart, Object addedValue) {
        this(feature, subpart);
        this.setNewSubpartValue(addedValue);
    }

    public AddTransaction(Object src, SeqFeatureI feat, TransactionSubpart subpart, Object addedValue) {
        this(feat, subpart, addedValue);
        this.setSource(src);
    }

    public AddTransaction(SeqFeatureI feature, TransactionSubpart subpart, Object addedValue, int subpartRank) {
        this(feature, subpart, addedValue);
        this.setSubpartRank(subpartRank);
    }

    public AddTransaction(Object source, SeqFeatureI feature, TransactionSubpart subpart, Object addedValue, int subpartRank) {
        this(feature, subpart, addedValue, subpartRank);
        this.setSource(source);
    }

    public SeqFeatureI getAddedFeature() {
        return this.getSeqFeature();
    }

    public boolean isAddPeptide() {
        return this.isPeptide;
    }

    public String getResidues() {
        return this.residues;
    }

    public void setResidues(String res) {
        this.residues = res;
    }

    public boolean isAdd() {
        return true;
    }

    public AnnotationChangeEvent generateAnnotationChangeEvent() {
        return new AnnotationAddEvent(this);
    }

    public void editModel() {
        if (!this.hasSubpart()) {
            throw new IllegalStateException("no editModel on add whole feats yet");
        }
        boolean isAdd = true;
        this.getSubpart().setValue(this.getSeqFeature(), this.getNewSubpartValue(), isAdd);
    }

    public void undo() {
        boolean isAdd = false;
        this.getSubpart().setValue(this.getSeqFeature(), this.getNewSubpartValue(), isAdd);
    }

    protected String getOperationString() {
        return "ADD";
    }
}

