/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.config.Config;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.DataUtil;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import apollo.seq.io.FastaFile;
import apollo.util.HTMLUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class SRSSequence
extends AbstractLazySequence
implements LazySequenceI {
    public SRSSequence(String id, Controller c) {
        super(id, c);
        this.length = -1;
    }

    public SequenceI getSubSequence(int start, int end) {
        return new Sequence(this.getName(), this.getResidues(start, end));
    }

    public int getLength() {
        if (this.length == -1) {
            this.length = DataUtil.getLengthFromSRS(this.getName());
        }
        return this.length;
    }

    protected String getResiduesFromSourceImpl(int low, int high) {
        String out = "";
        try {
            String host = Config.getSRSServer();
            int port = 80;
            String baseId = this.getName();
            int dotInd = baseId.lastIndexOf(46);
            if (dotInd > 0) {
                baseId = baseId.substring(0, dotInd);
            }
            String urlstr = "http://" + host + ":" + port + "/srs6bin/cgi-bin/wgetz?-f+AccNumber+-f+Sequence+-sf+fasta+[embl-sv:\"" + this.getName() + "\"]|[embl-AccNumber:\"" + this.getName() + "\"]|[swall-AccNumber:\"" + baseId + "\"]";
            URL url = new URL(urlstr);
            URLConnection urlconn = url.openConnection();
            DataInputStream in = new DataInputStream(urlconn.getInputStream());
            System.out.println("in = " + in);
            try {
                String data;
                boolean hadId = false;
                while ((data = in.readLine()) != null) {
                    if ((data = HTMLUtil.removeHtml(data)).indexOf("AC ") == 0) {
                        if (data.indexOf(baseId) > -1) {
                            data = in.readLine();
                        }
                        out = out + data + "\n";
                        hadId = true;
                    } else if (hadId) {
                        out = out + data + "\n";
                    }
                    System.out.println("Dehtmledline = " + data);
                }
            }
            catch (IOException ioex) {
                System.out.println("Exception " + ioex);
            }
            in.close();
        }
        catch (MalformedURLException ex) {
            System.out.println("Exception " + ex);
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
        catch (Exception ex) {
            System.out.println("Exception " + ex);
            ex.printStackTrace();
        }
        System.out.println("FASTA string = " + out);
        FastaFile fa = new FastaFile(out);
        return ((SequenceI)fa.getSeqs().elementAt(0)).getResidues(low + 1, high + 1);
    }

    public static void main(String[] argv) {
        Controller c = new Controller();
        SRSSequence seq = new SRSSequence("AK001640", c);
        seq.getCacher().setMinChunkSize(1000);
        System.out.println("Sequence first 10 = " + seq.getResidues(1, 10));
        System.out.println("Sequence next 10 = " + seq.getResidues(11, 20));
        System.out.println("Sequence 100-110 = " + seq.getResidues(100, 110));
    }
}

