/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.config.Config;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.DataUtil;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class PFetchSequence
extends AbstractLazySequence
implements LazySequenceI {
    public PFetchSequence(String id, Controller c) {
        super(id, c);
        this.length = -1;
    }

    public RangeI getRange() {
        if (this.genomicRange == null) {
            this.setRange(new Range(this.getName(), 1, this.getLength()));
        }
        return this.genomicRange;
    }

    public void setRange(RangeI loc) {
        this.genomicRange = loc;
    }

    public SequenceI getSubSequence(int start, int end) {
        return new Sequence(this.getName(), this.getResidues(start, end));
    }

    public int getLength() {
        if (this.length == -1) {
            this.length = DataUtil.getLengthFromPFetch(this.getName());
        }
        return this.length;
    }

    protected String getResiduesFromSourceImpl(int low, int high) {
        String finalStr = "";
        try {
            Socket t = new Socket(Config.getPFetchServer(), 22100);
            t.setSendBufferSize(1000);
            DataOutputStream sos = new DataOutputStream(t.getOutputStream());
            String allArgs = new String();
            allArgs = "-s " + low + " -e " + high + " -q " + this.getName() + "\n";
            sos.write(allArgs.getBytes());
            DataInputStream is = new DataInputStream(t.getInputStream());
            boolean more = true;
            while (more) {
                String str = is.readLine();
                if (str == null) {
                    more = false;
                    continue;
                }
                finalStr = finalStr + str;
            }
        }
        catch (IOException e) {
            System.out.println("PFetchSequence.getResiduesFromSourceImpl: error: " + e);
        }
        return finalStr;
    }

    public static void main(String[] argv) {
        Controller c = new Controller();
        PFetchSequence seq = new PFetchSequence("AK001640", c);
        seq.getCacher().setMinChunkSize(1000);
        System.out.println("Sequence first 10 = " + seq.getResidues(1, 10));
        System.out.println("Sequence next 10 = " + seq.getResidues(11, 20));
        System.out.println("Sequence 100-110 = " + seq.getResidues(100, 110));
    }
}

