/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.CurationSet;
import apollo.datamodel.LinkSet;
import apollo.datamodel.SeqFeatureI;
import apollo.util.FeatureList;

public class SpeciesComparison {
    private String species1;
    private CurationSet curationSet1;
    private String species2;
    private CurationSet curationSet2;
    private LinkSet linkSet;

    public SpeciesComparison() {
    }

    public SpeciesComparison(String species1, CurationSet curationSet1) {
        this.curationSet1 = curationSet1;
        this.species1 = species1;
    }

    public SpeciesComparison(String s1, CurationSet c1, String s2, CurationSet c2) {
        this(s1, c1);
        this.species2 = s2;
        this.curationSet2 = c2;
    }

    public SpeciesComparison(String s1, CurationSet c1, LinkSet l, String s2, CurationSet c2) {
        this(s1, c1, s2, c2);
        this.linkSet = l;
    }

    public void setCurationSet1(String name, CurationSet cs) {
        this.species1 = name;
        this.curationSet1 = cs;
    }

    public CurationSet getCurationSet1() {
        return this.curationSet1;
    }

    public void setCurationSet2(String name, CurationSet cs) {
        this.species2 = name;
        this.curationSet2 = cs;
    }

    public CurationSet getCurationSet2() {
        return this.curationSet2;
    }

    public void setCurationSet(int index, String name, CurationSet cs) {
        if (index < 0 || index > 1) {
            return;
        }
        if (index == 0) {
            this.setCurationSet1(name, cs);
        } else if (index == 1) {
            this.setCurationSet2(name, cs);
        }
    }

    public CurationSet getCurationSet(String species) {
        if (this.species1.equals(species)) {
            return this.curationSet1;
        }
        if (this.species2.equals(species)) {
            return this.curationSet2;
        }
        return null;
    }

    public void setLinks(LinkSet links) {
        this.linkSet = links;
        this.linkSet.setSpecies1(this.species1);
        this.linkSet.setSpecies2(this.species2);
    }

    public void setLinks(FeatureList links) {
        this.linkSet = new LinkSet(links, this.species1, this.species2);
    }

    LinkSet getLinkSet() {
        return this.linkSet;
    }

    public String getSpecies1() {
        return this.species1;
    }

    public String getSpecies2() {
        return this.species2;
    }

    public boolean hasBothSpecies() {
        return this.curationSet1 != null && this.curationSet2 != null;
    }

    public boolean hasSecondSpecies() {
        return this.curationSet2 != null;
    }

    public boolean hasLinkSet() {
        return this.linkSet != null;
    }

    boolean hasNonEmptyLinkSet() {
        return this.hasLinkSet() && this.linkSet.hasLinks();
    }

    public boolean featFromCurSet1(SeqFeatureI feat) {
        return this.curationSet1.getOrganism().equals(feat.getRefSequence().getOrganism());
    }
}

