/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comparable;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Identifier;
import apollo.datamodel.Protein;
import apollo.datamodel.Range;
import apollo.datamodel.Score;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.TranslationI;
import apollo.util.FeatureList;
import apollo.util.QuickSort;
import apollo.util.SeqFeatureUtil;
import apollo.util.Visitor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.bdgp.util.DNAUtils;

public class SeqFeature
extends Range
implements SeqFeatureI,
Comparable {
    protected String id;
    protected String refId;
    private Identifier identifier = new Identifier("");
    protected SeqFeatureI refFeature;
    protected Hashtable ref_features;
    private SeqFeatureI analogousOppositeStrandFeature = null;
    protected String biotype = null;
    protected Hashtable scores = null;
    protected double score;
    protected Hashtable properties = null;
    protected byte phase = 0;
    private String alignment;
    private String unpaddedAlignment;
    private String explicitAlignment;
    protected int edit_offset_adjust;
    private Object userObject = null;
    private String syntenyLinkInfo = null;
    private SeqFeatureI queryFeature;
    private String alignmentResidueType = null;

    public SeqFeature() {
    }

    public SeqFeature(SeqFeatureI sf) {
        this.initWithSeqFeat(sf);
    }

    protected void initWithSeqFeat(SeqFeatureI sf) {
        this.init(sf.getLow(), sf.getHigh(), sf.getFeatureType(), sf.getStrand());
        this.setName(sf.getName());
        this.setId(sf.getId());
        if (sf.getRefSequence() != null) {
            this.setRefSequence(sf.getRefSequence());
        }
    }

    public SeqFeature(int low, int high, String type) {
        this.init(low, high, type);
    }

    public SeqFeature(int low, int high, String type, int strand) {
        this.init(low, high, type, strand);
    }

    private void init(int low, int high, String type) {
        this.setLow(low);
        this.setHigh(high);
        this.setFeatureType(type);
    }

    private void init(int low, int high, String type, int strand) {
        this.init(low, high, type);
        this.setStrand(strand);
    }

    public SequenceI getFeatureSequence() {
        Sequence seq = new Sequence(this.getName(), this.getResidues());
        return seq;
    }

    public void flipFlop() {
        this.setStrand(this.getStrand() * -1);
    }

    public String get_cDNA() {
        if (this.getGenomicErrors() != null) {
            System.out.println("SeqFeature.get_cDNA: not accounting for genomic errors in " + this.getName() + "!");
        }
        return this.getResidues();
    }

    protected StringBuffer amend_RNA(StringBuffer dna) {
        int edits;
        SequenceEdit[] edit_list = this.buildmRNAEditList();
        int n = edits = edit_list != null ? edit_list.length : 0;
        if (edits > 0) {
            String mRNA = dna.toString();
            dna.setLength(0);
            int prior_offset = 0;
            for (int i = 0; i < edits; ++i) {
                SequenceEdit edit = edit_list[i];
                String edit_type = edit.getEditType();
                int edit_offset = this.getFeaturePosition(edit.getPosition()) - 1;
                if (edit_type.equals("nucleotide_deletion")) {
                    dna.append(this.getSubSequence(mRNA, prior_offset, edit_offset));
                    ++this.edit_offset_adjust;
                    prior_offset = edit_offset + 1;
                    continue;
                }
                if (edit_type.equals("nucleotide_insertion")) {
                    dna.append(this.getSubSequence(mRNA, prior_offset, edit_offset) + edit.getResidue());
                    --this.edit_offset_adjust;
                    prior_offset = edit_offset;
                    continue;
                }
                if (!edit_type.equals("substitution")) continue;
                dna.append(this.getSubSequence(mRNA, prior_offset, edit_offset) + edit.getResidue());
                prior_offset = edit_offset + 1;
            }
            dna.append(this.getSubSequence(mRNA, prior_offset, -1));
        }
        return dna;
    }

    protected String getSubSequence(String sequence, int start_offset, int end_offset) {
        String sub_sequence = "";
        if (start_offset >= 0 && start_offset < sequence.length() && start_offset != end_offset) {
            sub_sequence = end_offset > start_offset && end_offset < sequence.length() ? sequence.substring(start_offset, end_offset) : sequence.substring(start_offset);
        }
        return sub_sequence;
    }

    protected SequenceEdit[] buildmRNAEditList() {
        int edits;
        HashMap adjustments = this.getGenomicErrors();
        int n = edits = adjustments == null ? 0 : 0 + adjustments.size();
        if (edits > 0) {
            int[] int_list = new int[edits];
            Object[] edit_list = new SequenceEdit[edits];
            int count = 0;
            if (adjustments != null) {
                Iterator positions = adjustments.keySet().iterator();
                while (positions.hasNext()) {
                    String position = (String)positions.next();
                    int_list[count] = Integer.parseInt(position);
                    edit_list[count] = (SequenceEdit)adjustments.get(position);
                    ++count;
                }
            }
            QuickSort.sort(int_list, edit_list);
            return edit_list;
        }
        return null;
    }

    public HashMap getGenomicErrors() {
        HashMap all_errors;
        HashMap genomic_errors = null;
        if (this.getRefSequence() != null && (all_errors = this.getRefSequence().getGenomicErrors()) != null) {
            Iterator positions = all_errors.keySet().iterator();
            while (positions.hasNext()) {
                String position = (String)positions.next();
                int pos = Integer.parseInt(position);
                if (this.getFeatureContaining(pos) == null) continue;
                if (genomic_errors == null) {
                    genomic_errors = new HashMap(1);
                }
                genomic_errors.put(position, all_errors.get(position));
            }
        }
        return genomic_errors;
    }

    public String getCodingDNA() {
        String cdna = this.get_cDNA();
        String codingSeq = this.get_ORF(cdna);
        return codingSeq;
    }

    public SeqFeatureI getRefFeature() {
        return this.refFeature;
    }

    public FeatureSetI getParent() {
        if (this.getRefFeature() instanceof FeatureSetI) {
            return (FeatureSetI)this.getRefFeature();
        }
        return null;
    }

    public SeqFeatureI getRefFeature(String type) {
        if (this.ref_features == null || this.ref_features.get(type) == null) {
            return null;
        }
        return (SeqFeatureI)this.ref_features.get(type);
    }

    public void setRefFeature(SeqFeatureI refFeature) {
        this.addRefFeature("primary", refFeature);
        this.refFeature = refFeature;
    }

    public void addRefFeature(String type, SeqFeatureI refFeature) {
        if (this.ref_features == null) {
            this.ref_features = new Hashtable(1, 1.0f);
        }
        if (refFeature != null) {
            this.ref_features.put(type, refFeature);
        } else {
            this.ref_features.remove(type);
        }
    }

    public String getRefId() {
        return this.getRefFeature() != null ? this.getRefFeature().getId() : null;
    }

    public String getTopLevelType() {
        String retType = this.biotype == null || this.biotype.equals("") || this.biotype.equals("no_type") ? this.getFeatureType() : this.biotype;
        return retType;
    }

    public void setTopLevelType(String type) {
        this.biotype = type;
    }

    public Object clone() {
        try {
            SeqFeatureI clone = (SeqFeatureI)super.clone();
            clone.clearProperties();
            Enumeration e = this.getProperties().keys();
            while (e.hasMoreElements()) {
                String type = (String)e.nextElement();
                Vector values = this.getPropertyMulti(type);
                for (int i = 0; values != null && i < values.size(); ++i) {
                    String value = (String)values.elementAt(i);
                    clone.addProperty(type, value);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            System.err.println("SeqFeature.clone: cloning failed for " + this.getName());
            return null;
        }
    }

    public SeqFeatureI cloneFeature() {
        return (SeqFeatureI)this.clone();
    }

    public String getProgramName() {
        return this.getProperty("program");
    }

    public void setProgramName(String name) {
        if (name != null && !name.equals("")) {
            this.addProperty("program", name);
        }
    }

    public String getDatabase() {
        return this.getProperty("database");
    }

    public void setDatabase(String name) {
        if (name != null && !name.equals("")) {
            this.addProperty("database", name);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public double getScore() {
        return this.score;
    }

    public double getScore(String name) {
        Score score;
        if (this.scores == null) {
            this.scores = new Hashtable(1, 1.0f);
        }
        if ((score = (Score)this.scores.get(name)) == null) {
            return -1.0;
        }
        return score.getValue();
    }

    public Hashtable getScores() {
        if (this.scores == null) {
            this.scores = new Hashtable(1, 1.0f);
        }
        return this.scores;
    }

    public void setScore(double score) {
        Score s;
        if (this.scores == null) {
            this.scores = new Hashtable(1, 1.0f);
        }
        if ((s = (Score)this.scores.get("score")) == null) {
            s = new Score("score", score);
            this.scores.put("score", s);
            this.score = score;
        } else {
            s.setValue(score);
            this.score = score;
        }
    }

    public void addScore(Score s) {
        if (this.scores == null) {
            this.scores = new Hashtable(1, 1.0f);
        }
        if (!this.scores.contains(s)) {
            this.scores.put(s.getName(), s);
        }
    }

    public void addScore(double score) {
        if (this.scores == null) {
            this.scores = new Hashtable(1, 1.0f);
        }
        String name = this.scores.size() == 0 ? "score" : "score" + this.scores.size() + 1;
        this.addScore(new Score(name, score));
        if (name.equals("score")) {
            this.score = score;
        }
    }

    public void addScore(String name, double score) {
        this.addScore(new Score(name, score));
    }

    public void addScore(String name, String score) {
        try {
            double s = Double.valueOf(score);
            this.addScore(name, s);
        }
        catch (Exception ex) {
            System.err.println("Could parse " + score + " as a double");
            ex.printStackTrace();
        }
    }

    public SeqFeatureI merge(SeqFeatureI sf) {
        if (this.getStrand() != sf.getStrand()) {
            System.out.println("Can't merge features - wrong strands");
            return null;
        }
        int newlow = sf.getLow() < this.getLow() ? sf.getLow() : this.getLow();
        int newhigh = sf.getHigh() > this.getHigh() ? sf.getHigh() : this.getHigh();
        this.setLow(newlow);
        this.setHigh(newhigh);
        return this;
    }

    public static void main(String[] args) {
        SeqFeature sf1 = new SeqFeature(100, 200, "pog", 1);
        SeqFeature sf2 = new SeqFeature(100, 200, "pog", -1);
        System.out.println("SeqFeature 1 " + sf1 + " " + sf1.getLow() + " " + sf1.getHigh());
        System.out.println("SeqFeature 2 " + sf2 + " " + sf2.getLow() + " " + sf2.getHigh());
        System.out.println("Overlap is " + sf1.overlaps(sf2) + " " + sf2.overlaps(sf1));
        sf1.setStrand(-1);
        System.out.println("Overlap is " + sf1.overlaps(sf2) + " " + sf2.overlaps(sf1));
        sf1.setStart(150);
        sf1.setEnd(50);
        System.out.println("Overlap is " + sf1.getLeftOverlap(sf2) + " " + sf1.getRightOverlap(sf2));
        System.out.println("Overlap is " + sf2.getLeftOverlap(sf1) + " " + sf2.getRightOverlap(sf1));
        SeqFeature sf3 = (SeqFeature)sf1.merge(sf2);
        System.out.println("Merged feature = " + sf3 + " " + sf3.getLow() + " " + sf3.getHigh());
        SeqFeature sf4 = (SeqFeature)sf2.merge(sf1);
        System.out.println("Merged feature = " + sf4 + " " + sf4.getLow() + " " + sf4.getHigh());
    }

    public void setPhase(int phase) {
        if (phase < -1 || phase > 2) {
            System.err.println("Phase must be -1,0,1,2 : " + phase);
        } else {
            this.phase = (byte)phase;
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public int getEndPhase() {
        return (this.length() - this.getPhase()) % 3;
    }

    public int getFrame() {
        int frame = -1;
        if (this.getRefSequence() != null) {
            frame = this.getRefSequence().getFrame(this.getStart(), this.getStrand() == 1);
        }
        return frame + 1;
    }

    public int compareTo(Object sfObj) {
        SeqFeatureI sf = (SeqFeatureI)sfObj;
        int complow = sf.getLow();
        int low = this.getLow();
        if (low > complow) {
            return 1;
        }
        if (low < complow) {
            return -1;
        }
        int comphigh = sf.getHigh();
        int high = this.getHigh();
        if (high > comphigh) {
            return 1;
        }
        if (high < comphigh) {
            return -1;
        }
        return 0;
    }

    public void addProperty(String name, String value) {
        if (value != null && !value.equals("")) {
            Vector values;
            if (this.properties == null) {
                this.properties = new Hashtable(1, 1.0f);
            }
            if (this.properties.get(name) == null) {
                values = new Vector();
                this.properties.put(name, values);
            } else {
                values = (Vector)this.properties.get(name);
            }
            values.addElement(value);
        }
    }

    public void removeProperty(String key) {
        if (key != null && !key.equals("")) {
            if (this.properties == null) {
                return;
            }
            if (this.properties.containsKey(key)) {
                this.properties.remove(key);
            }
        }
    }

    public void replaceProperty(String key, String value) {
        this.removeProperty(key);
        this.addProperty(key, value);
    }

    public String getProperty(String name) {
        if (this.properties == null || this.properties.get(name) == null) {
            return "";
        }
        Vector values = (Vector)this.properties.get(name);
        return (String)values.lastElement();
    }

    public Vector getPropertyMulti(String name) {
        if (this.properties == null) {
            return null;
        }
        return (Vector)this.properties.get(name);
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(1, 1.0f);
        }
        Hashtable hash = new Hashtable(1, 1.0f);
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)((Vector)this.properties.get(key)).elementAt(0);
            hash.put(key, value);
        }
        return hash;
    }

    public Hashtable getPropertiesMulti() {
        if (this.properties == null) {
            this.properties = new Hashtable(1, 1.0f);
        }
        return this.properties;
    }

    public void clearProperties() {
        this.properties = null;
    }

    public String translate() {
        String aa = "";
        String sub_sequence = this.get_cDNA();
        if (sub_sequence.length() > 2) {
            aa = this.na2aa(this.get_ORF(sub_sequence));
        }
        return aa;
    }

    public String na2aa(String na) {
        String aa = na != null && na.length() > 2 ? DNAUtils.translate((String)na, (int)2, (int)100) : "";
        return aa.trim();
    }

    public String get_ORF(String sub_sequence) {
        String orf = "";
        if (this.getParent() != null) {
            FeatureSetI fs = this.getParent();
            int begin = this.phase;
            if (this.contains(fs.getTranslationStart()) && this.isSequenceAvailable(fs.getTranslationStart())) {
                begin = Math.abs(fs.getTranslationStart() - this.getStart());
            }
            int end = sub_sequence.length();
            if (this.contains(fs.getTranslationEnd()) && this.isSequenceAvailable(fs.getTranslationEnd())) {
                end = Math.abs(fs.getTranslationEnd() - this.getStart());
            }
            orf = sub_sequence.substring(begin, end);
        } else {
            orf = sub_sequence.substring(this.phase);
            System.out.println(this.getName() + " phase " + this.phase);
        }
        return orf;
    }

    public int getGenomicPosition(int transcript_pos) {
        int genome_offset;
        int genome_pos = 0;
        int transcript_offset = transcript_pos - 1;
        int n = genome_offset = this.getStrand() == 1 ? this.getStart() + transcript_offset : this.getStart() - transcript_offset;
        if (this.contains(genome_offset + 1)) {
            genome_pos = genome_offset + 1;
        }
        return genome_pos;
    }

    public int getGenomicPosForPeptidePos(int peptidePosition) {
        int featPos = peptidePosition * 3;
        return this.getGenomicPosition(featPos);
    }

    public int getFeaturePosition(int genomic_pos) {
        int offset = 0;
        if (this.contains(genomic_pos)) {
            offset = this.getStrand() == 1 ? genomic_pos - this.getStart() : this.getStart() - genomic_pos;
        }
        return offset + 1;
    }

    public int getNumberOfChildren() {
        if (!this.canHaveChildren()) {
            return 0;
        }
        return this.size();
    }

    public int size() {
        return 0;
    }

    public void clearKids() {
    }

    public Vector getFeatures() {
        if (!this.canHaveChildren()) {
            return new Vector();
        }
        System.out.println(this.getName() + " a " + this.getClass().getName() + " says it can have children, but it is not a FeatureSetI");
        new Throwable().printStackTrace();
        return new Vector();
    }

    public boolean hasKids() {
        return this.getFeatures().size() > 0;
    }

    public SeqFeatureI getFeatureAt(int i) {
        if (!this.canHaveChildren()) {
            return null;
        }
        System.out.println(this.getName() + " a " + this.getClass().getName() + " says it can have features, but it is not a FeatureSetI");
        new Throwable().printStackTrace();
        return null;
    }

    public int getFeatureIndex(SeqFeatureI sf) {
        return -1;
    }

    public void addFeature(SeqFeatureI child) {
    }

    public void addFeature(SeqFeatureI feature, boolean sort) {
    }

    public int getNumberOfDescendents() {
        return 0;
    }

    public int numberOfGenerations() {
        int gen_count = 1;
        if (this.canHaveChildren() && ((FeatureSetI)((Object)this)).size() > 0) {
            SeqFeatureI sf = ((FeatureSetI)((Object)this)).getFeatureAt(0);
            gen_count += sf.numberOfGenerations();
        }
        return gen_count;
    }

    public void accept(Visitor visitor) {
        throw new RuntimeException("Visitor/accept not yet implemented for SeqFeature");
    }

    public boolean isSameFeat(SeqFeatureI seqFeat) {
        if (!this.isIdentical(seqFeat)) {
            return false;
        }
        if (!seqFeat.getName().equals("no_name") || (seqFeat.getStart() != 1 && seqFeat.getStart() != 1000000000 || seqFeat.getEnd() != -1) && seqFeat.getEnd() != -1000000000) {
            return this.isIdentical(seqFeat);
        }
        return this.getId().equals(seqFeat.getId());
    }

    public boolean isAncestorOf(SeqFeatureI sf) {
        return sf.descendsFrom(this);
    }

    public boolean descendsFrom(SeqFeatureI sf) {
        if (this == sf) {
            return true;
        }
        if (this.getRefFeature() == null) {
            return false;
        }
        return this.getRefFeature().descendsFrom(sf);
    }

    public FeatureList getLeafFeatsOver(int pos) {
        FeatureList fl = new FeatureList(1);
        if (this.contains(pos)) {
            fl.addFeature(this);
        }
        return fl;
    }

    public boolean hasAnnotatedFeature() {
        return false;
    }

    public boolean isAnnot() {
        return this.hasAnnotatedFeature();
    }

    public AnnotatedFeatureI getAnnotatedFeature() {
        return null;
    }

    public boolean hasHitFeature() {
        return false;
    }

    public void setQueryFeature(SeqFeatureI queryFeat) {
        this.queryFeature = queryFeat;
    }

    public boolean hasAlignable() {
        return this.getResidues() != null;
    }

    public String getAlignment() {
        if (this.alignment == null) {
            if (this.haveRealAlignment()) {
                if (this.haveExplicitAlignment()) {
                    this.alignment = this.getExplicitAlignmentWithSpacing();
                } else {
                    this.parseCigar();
                }
            } else if (this.queryFeature != null) {
                this.alignment = this.queryFeature.getAlignment();
            }
            if (this.alignment == null) {
                this.alignment = this.getResidues();
            }
        }
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public boolean haveRealAlignment() {
        if (this.hasCigar() || this.haveExplicitAlignment()) {
            return true;
        }
        return this.hasHitFeature() && this.getHitFeature().haveRealAlignment();
    }

    protected boolean hasCigar() {
        return false;
    }

    public void parseCigar() {
        if (this.queryFeature != null) {
            this.queryFeature.parseCigar();
        }
    }

    public String getUnpaddedAlignment() {
        if (this.unpaddedAlignment == null && this.haveExplicitAlignment()) {
            this.unpaddedAlignment = this.getExplicitAlignment();
        }
        return this.unpaddedAlignment;
    }

    public String getExplicitAlignment() {
        return this.explicitAlignment;
    }

    public void setExplicitAlignment(String align) {
        this.explicitAlignment = align;
    }

    public boolean haveExplicitAlignment() {
        return this.getExplicitAlignment() != null;
    }

    private String getExplicitAlignmentWithSpacing() {
        if (this.getExplicitAlignment() == null) {
            return null;
        }
        if (this.alignmentIsPeptide()) {
            return this.addPeptideSpacing(this.getExplicitAlignment());
        }
        return this.getExplicitAlignment();
    }

    private String addPeptideSpacing(String unspacedPeptide) {
        StringBuffer spacedPeptide = new StringBuffer();
        for (int i = 0; i < unspacedPeptide.length(); ++i) {
            spacedPeptide.append(unspacedPeptide.charAt(i) + "  ");
        }
        return spacedPeptide.toString();
    }

    public String getCigar() {
        return null;
    }

    public void setCigar(String cigar) {
    }

    public String getHname() {
        return this.getRefSequence().getName();
    }

    public int getHstart() {
        return this.getStart();
    }

    public int getHend() {
        return this.getEnd();
    }

    public int getHlow() {
        return this.getLow();
    }

    public int getHhigh() {
        return this.getHigh();
    }

    public int getHstrand() {
        return this.getStrand();
    }

    public boolean alignmentIsPeptide() {
        if (this.alignmentResidueType == null) {
            SequenceI seq = this.getRefSequence();
            if (seq != null && seq.isAA()) {
                this.alignmentResidueType = "AA";
            }
            if (this.alignmentResidueType == null) {
                int featBasePairLength = this.length();
                if (this.queryFeature != null) {
                    featBasePairLength = this.queryFeature.length();
                }
                int seq_length = this.getUnpaddedAlignment().length();
                this.alignmentResidueType = SeqFeatureUtil.guessResidueTypeFromFeatureLength(seq_length, featBasePairLength);
            }
        }
        return this.alignmentResidueType == "AA";
    }

    public SeqFeatureI getHitFeature() {
        return this;
    }

    public SequenceI getHitSequence() {
        return null;
    }

    public boolean hasPeptideSequence() {
        return false;
    }

    public SequenceI getPeptideSequence() {
        return null;
    }

    public Protein getProteinFeat() {
        return null;
    }

    public SeqFeatureI getFeatureContaining(int position) {
        if (position >= this.getLow() && position <= this.getHigh()) {
            return this;
        }
        return null;
    }

    public void setAnalogousOppositeStrandFeature(SeqFeatureI oppositeFeature) {
        this.analogousOppositeStrandFeature = oppositeFeature;
    }

    public boolean hasAnalogousOppositeStrandFeature() {
        return this.analogousOppositeStrandFeature != null;
    }

    public SeqFeatureI getAnalogousOppositeStrandFeature() {
        return this.analogousOppositeStrandFeature;
    }

    public boolean isTranscript() {
        return false;
    }

    public boolean isProtein() {
        return false;
    }

    public boolean isExon() {
        return false;
    }

    public boolean isAnnotTop() {
        return false;
    }

    public boolean hasTranslation() {
        return false;
    }

    public boolean isProteinCodingGene() {
        return false;
    }

    public TranslationI getTranslation() {
        return null;
    }

    public Vector getDbXrefs() {
        return this.identifier.getDbXrefs();
    }

    public DbXref getDbXref(int i) {
        return (DbXref)this.getDbXrefs().get(i);
    }

    public void addDbXref(DbXref xref) {
        this.identifier.addDbXref(xref);
    }

    public DbXref getPrimaryDbXref() {
        Vector xrefs = this.getDbXrefs();
        for (int i = 0; i < xrefs.size(); ++i) {
            DbXref xref = (DbXref)xrefs.elementAt(i);
            if (!xref.isPrimary()) continue;
            return xref;
        }
        return null;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public int getCodingProperties() {
        if (this.getRefFeature() instanceof FeatureSetI) {
            FeatureSetI trans = (FeatureSetI)this.getRefFeature();
            int transStart = trans.getTranslationStart();
            int transEnd = trans.getTranslationEnd();
            if (transStart == 0) {
                return 7;
            }
            boolean has_start = this.contains(transStart);
            boolean has_stop = this.contains(transEnd);
            int exontype = has_start && has_stop ? 3 : (has_start ? 1 : (has_stop ? 2 : (trans.getStrand() == 1 ? (this.getHigh() < transStart ? 6 : (this.getLow() > transEnd && transEnd > 0 ? 5 : 4)) : (this.getLow() > transStart ? 6 : (this.getHigh() < transEnd && transEnd > 0 ? 5 : 4)))));
            return exontype;
        }
        return 7;
    }

    public StrandedFeatureSetI getStrandedFeatSetAncestor() {
        return this.getRefFeature().getStrandedFeatSetAncestor();
    }

    public boolean isCodon() {
        String type = this.getFeatureType();
        return type.startsWith("startcodon") || type.startsWith("stopcodon");
    }

    public void setSyntenyLinkInfo(String linkInfo) {
        this.syntenyLinkInfo = linkInfo;
    }

    public String getSyntenyLinkInfo() {
        return this.syntenyLinkInfo;
    }

    public boolean hasSyntenyLinkInfo() {
        return this.syntenyLinkInfo != null;
    }

    public String toString() {
        return "[SeqFeature " + this.name + " (id " + this.id + "): type = " + this.type + ", biotype = " + this.biotype + ", range = " + this.getStart() + "-" + this.getEnd() + (this.getStrand() == -1 ? " (minus)" : ", parent = " + (this.getRefFeature() == null ? "none" : this.getRefFeature().getId())) + "]";
    }
}

