/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.config.Config;
import apollo.datamodel.RangeI;
import apollo.datamodel.SequenceI;
import java.io.Serializable;

public class Range
implements RangeI,
Serializable {
    protected int low = -1;
    protected int high = -1;
    protected byte strand = 0;
    protected String name = "no_name";
    protected String type = "no_type";
    protected SequenceI refSeq;

    public Range() {
    }

    public Range(int start, int end) {
        this("no_name", start, end);
    }

    public Range(String name, int start, int end) {
        this.setName(name);
        this.setStrand(start <= end ? 1 : -1);
        this.setStart(start);
        this.setEnd(end);
    }

    public RangeI getRangeClone() {
        try {
            return (RangeI)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Range.getRangeClone(): clone failed for " + this.getName());
            return null;
        }
    }

    public boolean isIdentical(RangeI range) {
        if (this == range) {
            return true;
        }
        return range.getFeatureType().equals(this.getFeatureType()) && this.sameRange(range) && range.getName().equals(this.getName());
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Range.setName: can't accept feature name of null. Use RangeI.NO_NAME instead.");
        }
        if (!name.equals("")) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName() {
        return !this.name.equals("") && !this.name.equals("no_name");
    }

    public String getFeatureType() {
        return this.type;
    }

    public void setFeatureType(String type) {
        if (type == null) {
            throw new NullPointerException("Range.setFeatureType: can't accept feature type of null. Use SeqFeatureI.NO_TYPE or 'SeqFeatureI.NO_TYPE' instead.");
        }
        if (!type.equals("")) {
            this.type = type;
        }
    }

    public boolean hasFeatureType() {
        return this.getFeatureType() != "no_type";
    }

    public int getStrand() {
        return this.strand;
    }

    public boolean isForwardStrand() {
        return this.getStrand() == 1;
    }

    public void setStrand(int strand) {
        this.strand = (byte)strand;
    }

    public void setStart(int start) {
        if (this.getStrand() == -1) {
            this.high = start;
        } else {
            this.low = start;
        }
    }

    public int getStart() {
        return this.getStrand() == -1 ? this.high : this.low;
    }

    public void setEnd(int end) {
        if (this.getStrand() == -1) {
            this.low = end;
        } else {
            this.high = end;
        }
    }

    public int getEnd() {
        return this.getStrand() == -1 ? this.low : this.high;
    }

    public int getLow() {
        return this.low;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public String getStartAsString() {
        return String.valueOf(new Integer(this.getStart()));
    }

    public String getEndAsString() {
        return String.valueOf(new Integer(this.getEnd()));
    }

    public SequenceI getRefSequence() {
        return this.refSeq;
    }

    public boolean hasRefSequence() {
        return this.refSeq != null;
    }

    public boolean isContainedByRefSeq() {
        if (this.getRefSequence() == null || this.getRefSequence().getRange() == null) {
            if (Config.DEBUG) {
                String m = "\nDEBUG: Range.isContainedByRefSeq() feature has null ";
                m = m + (this.getRefSequence() == null ? "reference seq" : "reference seq range");
                m = m + " Returning true even though we dont really know\nDEBUG stack trace:";
                System.err.println(m);
                new Throwable().printStackTrace();
            }
            return true;
        }
        RangeI refSeqRange = this.getRefSequence().getRange();
        return this.getLow() >= refSeqRange.getLow() && this.getHigh() <= refSeqRange.getHigh();
    }

    public void setRefSequence(SequenceI sequence) {
        this.refSeq = sequence;
    }

    public String getResidues() {
        String residues;
        StringBuffer dna = new StringBuffer();
        if (this.refSeq != null && (residues = this.refSeq.getResidues(this.getStart(), this.getEnd())) != null) {
            dna.append(residues);
        }
        return dna.toString();
    }

    public int getLeftOverlap(RangeI sf) {
        return this.getLow() - sf.getLow();
    }

    public int getRightOverlap(RangeI sf) {
        return sf.getHigh() - this.getHigh();
    }

    public boolean isExactOverlap(RangeI sf) {
        return this.getLeftOverlap(sf) == 0 && this.getRightOverlap(sf) == 0 && this.getStrand() == sf.getStrand();
    }

    public boolean contains(RangeI sf) {
        return this.overlaps(sf) && this.getLeftOverlap(sf) <= 0 && this.getRightOverlap(sf) <= 0 && this.getStrand() == sf.getStrand();
    }

    public boolean contains(int position) {
        return position >= this.getLow() && position <= this.getHigh();
    }

    public boolean overlaps(RangeI sf) {
        return this.getLow() <= sf.getHigh() && this.getHigh() >= sf.getLow() && this.getStrand() == sf.getStrand();
    }

    public boolean sameRange(RangeI r) {
        return this.getStart() == r.getStart() && this.getEnd() == r.getEnd();
    }

    public int length() {
        return this.getHigh() - this.getLow() + 1;
    }

    public boolean isSequenceAvailable(int position) {
        return this.refSeq != null && this.refSeq.isSequenceAvailable(position);
    }

    public boolean canHaveChildren() {
        return false;
    }

    public boolean rangeIsUnassigned() {
        return this.low == -1 && this.high == -1;
    }

    public void convertFromBaseOrientedToInterbase() {
        --this.low;
    }

    public void convertFromInterbaseToBaseOriented() {
        ++this.low;
    }
}

