/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;

public class Protein
extends AnnotatedFeature {
    private Transcript transcript;

    public Protein(Transcript transcript) {
        this.init(transcript);
    }

    public Protein(SeqFeatureI protFeat, Transcript transcript) {
        this(transcript);
        super.initWithSeqFeat(protFeat);
        transcript.setProteinFeat(this);
    }

    private void init(Transcript transcript) {
        this.transcript = transcript;
        this.setStrand(transcript.getStrand());
    }

    public boolean isProtein() {
        return true;
    }

    public boolean isProteinCodingGene() {
        return true;
    }

    public SequenceI getRefSequence() {
        return this.transcript.getRefSequence();
    }

    public SequenceI getPeptideSequence() {
        return this.transcript.getPeptideSequence();
    }

    public String getId() {
        return this.getPeptideSequence().getAccessionNo();
    }

    public void setId(String id) {
        this.getPeptideSequence().setAccessionNo(id);
    }

    public void setName(String name) {
        this.getPeptideSequence().setName(name);
    }

    public String getName() {
        return this.getPeptideSequence().getName();
    }

    public String getFeatureType() {
        return "polypeptide";
    }

    public int getStart() {
        if (super.getStart() != -1 && this.transcript.getTranslationStart() == 0) {
            return super.getStart();
        }
        return this.transcript.getTranslationStart();
    }

    public void setStart(int start) {
        super.setStart(start);
    }

    public int getEnd() {
        int stop = this.transcript.getTranslationEnd() - this.getStrand();
        if (!this.transcript.hasTranslationEnd()) {
            stop = this.transcript.getEnd();
        }
        return stop;
    }

    public boolean hasTranslationStart() {
        return this.getStart() != 0;
    }

    public boolean hasTranslationEnd() {
        return this.transcript.hasTranslationEnd();
    }
}

