/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.config.Config;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.datamodel.TranslationI;
import apollo.util.FeatureList;
import apollo.util.QuickSort;
import apollo.util.SeqFeatureUtil;
import apollo.util.Visitor;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;
import org.bdgp.util.DNAUtils;

public class FeatureSet
extends SeqFeature
implements FeatureSetI {
    protected Vector features = new Vector(2);
    protected SequenceI hitSequence = null;
    protected byte flags;
    public static byte POLYA_REMOVED = (byte)2;
    int translation_start = 0;
    int translation_end = 0;
    protected int plus1_frameshift = 0;
    protected int minus1_frameshift = 0;
    protected String readthrough_stop = null;
    public String genericReadThroughStopResidue = "X";
    private int readthrough_pos = 0;
    protected boolean trans_spliced = false;
    protected boolean missing_5prime = false;
    protected boolean missing_3prime = false;
    protected static String standard_start_codon = "ATG";
    protected String start_codon = null;
    private boolean isProteinCodingGene = false;

    public FeatureSet() {
        this.initRange();
    }

    public FeatureSet(SeqFeatureI sf) {
        super(sf);
    }

    public FeatureSet(String type, int strand) {
        this.initRange();
        this.setFeatureType(type);
        this.setStrand(strand);
    }

    public FeatureSet(int low, int high, String type, int strand) {
        super(low, high, type, strand);
    }

    public FeatureSet(FeatureList kids, String name, String type, int strand) {
        this.initRange();
        this.setName(name);
        this.setFeatureType(type);
        this.setStrand(strand);
        for (int i = 0; i < kids.size(); ++i) {
            this.addFeature(kids.getFeature(i));
        }
    }

    private void initRange() {
        this.setStart(1000000000);
        this.setEnd(-1000000000);
    }

    public FeatureSet(FeatureSetI fs, String class_name) {
        super(fs);
        fs.sort(this.getStrand());
        try {
            Class<?> sf_class = Class.forName(class_name);
            for (int i = 0; i < fs.getFeatures().size(); ++i) {
                SeqFeatureI sf_from = fs.getFeatureAt(i);
                SeqFeatureI sf_to = (SeqFeatureI)sf_class.newInstance();
                sf_to.setStrand(sf_from.getStrand());
                sf_to.setLow(sf_from.getLow());
                sf_to.setHigh(sf_from.getHigh());
                sf_to.setFeatureType(sf_from.getFeatureType());
                this.addFeature(sf_to);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to get feature class " + class_name);
        }
        FeatureSetI parent = (FeatureSetI)this.getRefFeature();
        if (parent != null) {
            parent.adjustEdges();
            if (parent.getFeatureType().equalsIgnoreCase("gene")) {
                this.calcTranslationStartForLongestPeptide();
            }
        }
    }

    public boolean hasTranslation() {
        return true;
    }

    public TranslationI getTranslation() {
        return this;
    }

    public String getName() {
        if (this.name.equals("no_name") && this.canHaveChildren() && this.size() > 0 && !(this instanceof Transcript)) {
            return this.getFeatureAt(0).getName();
        }
        return this.name;
    }

    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    public void addFeature(SeqFeatureI feature) {
        this.insertFeatureAt(feature, this.features.size());
    }

    public void addFeature(SeqFeatureI feature, boolean sort) {
        if (feature == null) {
            throw new NullPointerException("Can't add null feature");
        }
        if (!sort) {
            this.insertFeatureAt(feature, this.features.size());
        } else {
            this.insertFeatureAt(feature, this.calculateSortPosition(feature));
        }
    }

    protected void insertFeatureAt(SeqFeatureI feature, int position) {
        if (feature == null) {
            throw new NullPointerException("Can't add null feature");
        }
        if (!this.features.contains(feature)) {
            if (position >= this.features.size()) {
                this.features.addElement(feature);
            } else {
                this.features.insertElementAt(feature, position);
            }
            feature.setRefFeature(this);
        }
        if (this.getRefSequence() != null && feature.getRefSequence() == null) {
            feature.setRefSequence(this.getRefSequence());
        } else if (this.getRefSequence() == null && feature.getRefSequence() != null) {
            this.setRefSequence(feature.getRefSequence());
        }
        this.adjustEdges(feature);
    }

    private int calculateSortPosition(SeqFeatureI feature) {
        int location;
        block9: {
            int setSize;
            location = setSize = this.size();
            if (setSize <= 0) break block9;
            if (feature.getStrand() != this.getStrand() || this.getStrand() == 0) {
                boolean found = false;
                for (int i = 0; i < setSize && !found; ++i) {
                    SeqFeatureI sf = this.getFeatureAt(i);
                    if (feature.getLow() >= sf.getLow()) continue;
                    location = i;
                    found = true;
                }
            } else if (this.pastThreePrimeEnd(feature)) {
                location = setSize;
            } else if (this.beforeFivePrimeEnd(feature)) {
                location = 0;
            } else {
                boolean found = false;
                SeqFeatureI preceding_sf = null;
                for (int i = 0; i < setSize && !found; ++i) {
                    SeqFeatureI sf = this.getFeatureAt(i);
                    if (feature.getStrand() == 1 && feature.getStart() < sf.getStart() && (preceding_sf == null || feature.getStart() >= preceding_sf.getStart()) || feature.getStrand() == -1 && feature.getStart() > sf.getStart() && (preceding_sf == null || feature.getStart() <= preceding_sf.getStart())) {
                        location = i;
                        found = true;
                    }
                    preceding_sf = sf;
                }
            }
        }
        return location;
    }

    public boolean pastThreePrimeEnd(SeqFeatureI feature) {
        if (feature.getStrand() != this.getStrand()) {
            System.err.println(this.getName() + " and  " + feature.getName() + " are on opposite strands, so 5prime test " + " is not relevant");
            return false;
        }
        return this.getStrand() == 1 && feature.getLow() > this.getHigh() || this.getStrand() == -1 && feature.getHigh() < this.getLow();
    }

    public boolean beforeFivePrimeEnd(SeqFeatureI feature) {
        if (feature.getStrand() != this.getStrand()) {
            System.err.println(this.getName() + " and  " + feature.getName() + " are on opposite strands, so 5prime test " + " is not relevant");
            return false;
        }
        return feature.getStrand() == 1 && feature.getHigh() < this.getLow() || feature.getStrand() == -1 && feature.getLow() > this.getHigh();
    }

    public void deleteFeature(SeqFeatureI feature) {
        if (feature == null) {
            throw new NullPointerException("Can't remove null feature");
        }
        if (this.features.contains(feature)) {
            this.features.removeElement(feature);
            this.adjustEdges();
        }
    }

    public SeqFeatureI deleteFeatureAt(int i) {
        if (i < this.size()) {
            SeqFeatureI sf = this.getFeatureAt(i);
            this.features.removeElementAt(i);
            this.adjustEdges();
            return sf;
        }
        return null;
    }

    public SeqFeatureI getFeatureAt(int i) {
        return i >= 0 && i < this.features.size() ? (SeqFeatureI)this.features.elementAt(i) : null;
    }

    public Vector getFeatures() {
        return this.features;
    }

    public void clearKids() {
        this.features = new Vector();
    }

    public FeatureList getLeafFeatsOver(int pos) {
        FeatureList leafFeatsOver = new FeatureList();
        if (!this.hasKids()) {
            return super.getLeafFeatsOver(pos);
        }
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            leafFeatsOver.addAll(this.getFeatureAt(i).getLeafFeatsOver(pos));
        }
        return leafFeatsOver;
    }

    public void adjustEdges() {
        this.low = 1000000000;
        this.high = -1000000000;
        for (int i = 0; i < this.size(); ++i) {
            this.adjustEdges(this.getFeatureAt(i));
        }
    }

    public void adjustEdges(SeqFeatureI span) {
        boolean adjusted = false;
        if (span.getLow() < this.getLow()) {
            this.setLow(span.getLow());
            adjusted |= true;
        }
        if (span.getHigh() > this.high) {
            this.setHigh(span.getHigh());
            adjusted |= true;
        }
        if (adjusted && this.getRefFeature() != null) {
            ((FeatureSetI)this.getRefFeature()).adjustEdges();
        }
    }

    public FeatureList findFeaturesByHitName(String hname) {
        FeatureList feats = new FeatureList();
        if (this.getHitSequence() != null && this.getHitSequence().getName().equals(hname)) {
            feats.addFeature(this);
            return feats;
        }
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            SeqFeatureI sf = this.getFeatureAt(i);
            if (sf instanceof FeaturePairI) {
                if (!((FeaturePairI)sf).getHname().equals(hname)) continue;
                feats.addFeature(sf);
                continue;
            }
            if (!sf.canHaveChildren()) continue;
            SequenceI s = ((FeatureSetI)sf).getHitSequence();
            boolean found = false;
            if (s != null && s.getName().equals(hname)) {
                feats.addFeature(sf);
                found = true;
            }
            if (found) continue;
            FeatureList hitChildren = ((FeatureSetI)sf).findFeaturesByHitName(hname);
            feats.addAllFeatures(hitChildren);
        }
        return feats;
    }

    public FeatureList findFeaturesByName(String name) {
        FeatureList feats = new FeatureList();
        if (this.getName().equalsIgnoreCase(name) || this.getId() != null && this.getId().equalsIgnoreCase(name)) {
            feats.addFeature(this);
            return feats;
        }
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            FeatureList fl;
            SeqFeatureI sf = this.getFeatureAt(i);
            if (sf.getName().equalsIgnoreCase(name)) {
                feats.addFeature(sf);
                continue;
            }
            if (!sf.canHaveChildren() || (fl = ((FeatureSetI)sf).findFeaturesByName(name)).isEmpty()) continue;
            feats.addAllFeatures(fl);
        }
        return feats;
    }

    public FeatureList findFeaturesByAllNames(String name) {
        return this.findFeaturesByAllNames(name, false);
    }

    public FeatureList findFeaturesByAllNames(String searchString, boolean useRegExp) {
        return this.findFeaturesByAllNames(searchString, useRegExp, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureList findFeaturesByAllNames(String searchString, boolean useRegExp, boolean kidNamesOverParent) {
        FeatureList feats = new FeatureList();
        Perl5Compiler p5Compiler = new Perl5Compiler();
        Perl5Pattern pattern = null;
        Perl5Pattern defaultPattern = null;
        Perl5Matcher matcher = new Perl5Matcher();
        if (!useRegExp) {
            searchString = this.prepareNonRegExpString(searchString);
        }
        try {
            defaultPattern = (Perl5Pattern)p5Compiler.compile("invalid perl5 expression");
            pattern = (Perl5Pattern)p5Compiler.compile(searchString, 1);
        }
        catch (MalformedPatternException ex) {
            pattern = defaultPattern;
        }
        if (matcher.contains("no_name", (Pattern)pattern)) {
            return feats;
        }
        boolean selfMatches = false;
        if (matcher.contains(this.getName(), (Pattern)pattern)) {
            if (!kidNamesOverParent) {
                feats.addFeature(this);
                return feats;
            }
            selfMatches = true;
        } else if (this.getHitSequence() != null && matcher.contains(this.getHitSequence().getName(), (Pattern)pattern)) {
            if (!kidNamesOverParent) {
                feats.addFeature(this);
                return feats;
            }
            selfMatches = true;
        }
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            SeqFeatureI sf = this.getFeatureAt(i);
            if (matcher.contains(sf.getName(), (Pattern)pattern)) {
                feats.addFeature(sf);
                continue;
            }
            if (sf instanceof FeaturePairI) {
                if (!matcher.contains(((FeaturePairI)sf).getHname(), (Pattern)pattern)) continue;
                feats.addFeature(sf);
                continue;
            }
            if (!sf.canHaveChildren()) continue;
            SequenceI s = ((FeatureSetI)sf).getHitSequence();
            boolean found = false;
            if (s != null && matcher.contains(s.getName(), (Pattern)pattern)) {
                feats.addFeature(sf);
                found = true;
            }
            if (found) continue;
            FeatureList hitChildren = ((FeatureSetI)sf).findFeaturesByAllNames(searchString, true);
            feats.addAllFeatures(hitChildren);
        }
        if (kidNamesOverParent && selfMatches && feats.isEmpty()) {
            feats.addFeature(this);
        }
        return feats;
    }

    public void setRefSequence(SequenceI seq) {
        this.refSeq = seq;
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            this.getFeatureAt(i).setRefSequence(seq);
        }
    }

    public void setHitSequence(SequenceI seq) {
        this.hitSequence = seq;
    }

    public SequenceI getHitSequence() {
        return this.hitSequence;
    }

    public double getScore() {
        double bestScore = 0.0;
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            if (!(this.getFeatureAt(i).getScore() > bestScore)) continue;
            bestScore = this.getFeatureAt(i).getScore();
        }
        return bestScore;
    }

    public int getNumberOfDescendents() {
        int numFeat = 0;
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            SeqFeatureI feat = this.getFeatureAt(i);
            if (feat.hasKids()) {
                numFeat += ((FeatureSetI)feat).getNumberOfDescendents();
                continue;
            }
            ++numFeat;
        }
        return numFeat;
    }

    public boolean canHaveChildren() {
        return true;
    }

    public boolean hasDescendents() {
        int setSize = this.size();
        boolean leaves = false;
        for (int i = 0; i < setSize && !leaves; ++i) {
            SeqFeatureI feat = this.getFeatureAt(i);
            if (feat.canHaveChildren()) {
                if (!((FeatureSetI)feat).hasDescendents()) continue;
                leaves = true;
                continue;
            }
            leaves = true;
        }
        return leaves;
    }

    public SeqFeatureI getFeatureContaining(int position) {
        int setSize = this.size();
        SeqFeatureI container = null;
        if (this.canHaveChildren()) {
            for (int i = 0; i < setSize && container == null; ++i) {
                SeqFeatureI sf = this.getFeatureAt(i);
                if (!sf.contains(position)) continue;
                container = sf;
            }
        } else if (this.contains(position)) {
            container = this;
        }
        return container;
    }

    public int getIndexContaining(int position) {
        int setSize = this.size();
        int feature_index = -1;
        for (int i = 0; i < setSize && feature_index < 0; ++i) {
            SeqFeatureI sf = this.getFeatureAt(i);
            if (!sf.contains(position)) continue;
            feature_index = i;
        }
        return feature_index;
    }

    public int getFeatureIndex(SeqFeatureI sf) {
        if (this.features.contains(sf)) {
            return this.features.indexOf(sf);
        }
        return -1;
    }

    public void sort(int sortStrand) {
        SeqFeatureUtil.sort(this.features, sortStrand);
        this.adjustEdges();
    }

    public String translate() {
        String aa = "";
        String mRNA = this.get_cDNA();
        if (mRNA == null) {
            return "";
        }
        if (mRNA.length() > 2) {
            aa = this.getUntrimmedAA(this.get_ORF(mRNA), this.getFeaturePosition(this.translation_start) - 1);
        }
        if (this.unConventionalStart()) {
            if (aa.length() < 2) {
                System.err.println("Error: untrimmed aa sequence for " + this.getName() + ", which has unconventional start, is too short: " + aa + " mRNA = " + mRNA);
                return null;
            }
            aa = "M" + aa.substring(1);
        }
        return aa;
    }

    public void calcTranslationStartForLongestPeptide() {
        System.out.println("Setting translation start at first codon for " + this.getName());
        this.translation_end = 0;
        this.setMissing5prime(false);
        String the_mRNA = this.get_cDNA();
        if (the_mRNA == null) {
            System.err.println("calcTranslationStartForLongetPep: no cDNA sequence for " + this.getName());
            return;
        }
        String longest_peptide = "";
        int best_start_index = -1;
        if (the_mRNA.length() > 3) {
            int start_index = the_mRNA.indexOf(standard_start_codon);
            while (start_index >= 0) {
                String aa = this.getTrimmedAA(this.get_ORF(the_mRNA, start_index, -1), start_index);
                if (aa.length() > longest_peptide.length()) {
                    longest_peptide = aa;
                    best_start_index = start_index;
                }
                start_index = the_mRNA.indexOf(standard_start_codon, start_index + 1);
            }
            for (start_index = 0; start_index < 3; ++start_index) {
                String orf = this.get_ORF(the_mRNA, start_index, -1);
                String aa = this.getTrimmedAA(orf, start_index);
                if (aa.length() <= longest_peptide.length()) continue;
                this.setMissing5prime(true);
                longest_peptide = aa;
                best_start_index = start_index;
            }
        }
        if (best_start_index >= 0) {
            boolean setEnd = true;
            this.initTranslationStart(this.getGenomicPosition(best_start_index + 1), setEnd);
        } else {
            this.translation_start = 0;
            this.setMissing5prime(true);
            this.setMissing3prime(true);
        }
    }

    private String getUntrimmedAA(String orf, int orf_offset) {
        String aa = this.na2aa(orf);
        int stop_index = aa.indexOf(42);
        if (stop_index >= 0 && this.readthrough_stop != null) {
            String tmp;
            int stop_offset = 3 * stop_index + orf_offset;
            this.readthrough_pos = this.getGenomicPosition(stop_offset + 1);
            aa = tmp = aa.substring(0, stop_index) + this.readthrough_stop + aa.substring(stop_index + 1);
        }
        return aa;
    }

    private String getTrimmedAA(String orf, int orf_offset) {
        String aa = this.getUntrimmedAA(orf, orf_offset);
        int stop_index = aa.indexOf(42);
        if (stop_index >= 0) {
            aa = aa.substring(0, stop_index);
        }
        return aa;
    }

    public void setProteinCodingGene(boolean isProteinCodingGene) {
        this.isProteinCodingGene = isProteinCodingGene;
    }

    public boolean isProteinCodingGene() {
        return this.isProteinCodingGene;
    }

    public void setTranslationEndFromStart() {
        if (!this.contains(this.translation_start) && this.isProteinCodingGene()) {
            System.out.println("Warning: translation start set inappropriately to " + this.translation_start + " for " + this.getName());
            System.out.println(" (low = " + this.getLow() + ", high = " + this.getHigh() + ")");
            if (this.missing_5prime) {
                this.translation_start = 0;
                this.translation_end = 0;
                this.setMissing3prime(true);
                return;
            }
            this.calcTranslationStartForLongestPeptide();
        }
        this.translation_end = 0;
        this.setMissing3prime(false);
        if (!this.isProteinCodingGene()) {
            return;
        }
        String the_mRNA = this.get_cDNA();
        String orf = this.get_ORF(the_mRNA);
        int orf_offset = this.getFeaturePosition(this.translation_start) - 1;
        String aa = this.getUntrimmedAA(orf, orf_offset);
        boolean foundStop = false;
        if (aa != null) {
            int stop_index = aa.indexOf(42);
            if (stop_index > 0) {
                int stop_offset = 3 * stop_index + orf_offset;
                int stopPos = this.getGenomicPosition((stop_offset += this.edit_offset_adjust) + 1);
                this.setTranslationEnd(stopPos);
                foundStop = true;
            } else if (stop_index == 0) {
                System.err.println(this.getName() + ": the first codon is a stop codon!!!!");
                this.calcTranslationStartForLongestPeptide();
                foundStop = !this.isMissing3prime() && this.translation_start > 0;
            }
            this.setMissing3prime(!foundStop && this.translation_start != 0);
        } else {
            System.err.println("Failed setting translation limits");
        }
    }

    public boolean setTranslationStart(int pos) {
        return this.setTranslationStart(pos, false);
    }

    public boolean setTranslationStart(int pos, boolean set_end) {
        SeqFeatureI held_in = this.getFeatureContaining(pos);
        this.setMissing5prime(held_in == null);
        if (!this.missing_5prime) {
            this.initTranslationStart(pos, set_end);
        } else {
            this.translation_start = 0;
            System.err.println("Unable to set translation start to " + pos + " for " + this.getName() + ", which has " + this.size() + " exons:");
            for (int i = 0; i < this.size(); ++i) {
                SeqFeatureI sf = this.getFeatureAt(i);
                System.err.println("\tExon " + i + ": " + sf.getStart() + "-" + sf.getEnd());
            }
        }
        return !this.missing_5prime;
    }

    private void initTranslationStart(int pos, boolean set_end) {
        this.translation_start = pos;
        if (!this.missing_5prime && this.getRefSequence() != null && this.getRefSequence().isSequenceAvailable(pos)) {
            this.start_codon = this.getRefSequence().getResidues(pos, pos + 2 * this.getStrand());
        }
        if (set_end) {
            this.setTranslationEndFromStart();
        }
    }

    public void setTranslationEndNoPhase(int pos) {
        this.translation_end = pos;
        if (this.plus1_frameshift != 0 && !this.withinCDS(this.plus1_frameshift)) {
            System.out.println(this.getName() + " clearing +1 frameshift");
            this.plus1_frameshift = 0;
        }
        if (this.minus1_frameshift != 0 && !this.withinCDS(this.minus1_frameshift)) {
            System.out.println(this.getName() + " clearing -1 frameshift");
            this.minus1_frameshift = 0;
        }
    }

    public void setTranslationEnd(int pos) {
        this.setTranslationEndNoPhase(pos);
        this.setPhases();
    }

    public int getTranslationStart() {
        return this.translation_start;
    }

    public int getTranslationEnd() {
        return this.translation_end;
    }

    public boolean hasTranslationEnd() {
        return this.getTranslationEnd() != 0;
    }

    public boolean hasTranslationStart() {
        return this.getTranslationStart() != 0;
    }

    public int getPositionFrom(int base_position, int base_offset) {
        int end_base = 0;
        if (base_position > 0) {
            int at_trans_pos = this.getFeaturePosition(base_position);
            end_base = this.getGenomicPosition(at_trans_pos + base_offset);
        }
        if (end_base <= 0) {
            end_base = this.getEnd();
        }
        return end_base;
    }

    public int getLastBaseOfStopCodon() {
        return this.getPositionFrom(this.translation_end, 2);
    }

    public String get_cDNA() {
        if (this.hasKids()) {
            return this.getSplicedTranscript(0, this.size());
        }
        return super.get_cDNA();
    }

    public String getSplicedTranscript(int startExon, int endExon) {
        StringBuffer dna = new StringBuffer();
        SequenceI seq = this.getRefSequence();
        this.edit_offset_adjust = 0;
        if (seq == null) {
            return "";
        }
        for (int i = startExon; i < endExon; ++i) {
            SeqFeatureI span = this.getFeatureAt(i);
            String res = seq.getResidues(span.getStart(), span.getEnd());
            if (res == null) continue;
            dna.append(res);
        }
        dna = this.amend_RNA(dna);
        return dna.toString();
    }

    public int getSplicedLength() {
        return this.getSplicedLength(0, this.size());
    }

    public int getSplicedLength(int startExon, int endExon) {
        int spliced_length = 0;
        for (int i = startExon; i < endExon; ++i) {
            SeqFeatureI span = this.getFeatureAt(i);
            spliced_length += span.length();
        }
        return spliced_length;
    }

    public String get_ORF(String mRNA) {
        if (this.canHaveChildren()) {
            if (this.contains(this.translation_start)) {
                int start_offset = this.getFeaturePosition(this.translation_start) - 1;
                int end_offset = this.translation_end > 0 ? this.getFeaturePosition(this.translation_end) : -1;
                return this.get_ORF(mRNA, start_offset, end_offset);
            }
            System.out.println(this.getName() + " does not have translation start");
            return "";
        }
        return super.get_ORF(mRNA);
    }

    protected String get_ORF(String mRNA, int start_offset, int end_offset) {
        if (!this.canHaveChildren()) {
            return super.get_ORF(mRNA);
        }
        StringBuffer orf = new StringBuffer();
        if (mRNA != null) {
            int prior_offset = start_offset;
            SequenceEdit[] edit_list = this.buildORFEditList();
            SequenceEdit[] mRNA_edit_list = this.buildmRNAEditList();
            int edits = edit_list != null ? edit_list.length : 0;
            for (int i = 0; i < edits; ++i) {
                SequenceEdit edit = edit_list[i];
                String edit_type = edit.getEditType();
                int edit_offset = this.getAdjustedFeaturePosition(edit.getPosition(), mRNA_edit_list) - 1;
                if (edit_type.equals("nucleotide_deletion")) {
                    orf.append(this.getSubSequence(mRNA, prior_offset, edit_offset));
                    ++this.edit_offset_adjust;
                    prior_offset = edit_offset + 1;
                    continue;
                }
                if (!edit_type.equals("nucleotide_insertion")) continue;
                orf.append(this.getSubSequence(mRNA, prior_offset, edit_offset) + edit.getResidue());
                --this.edit_offset_adjust;
                prior_offset = edit_offset;
            }
            orf.append(this.getSubSequence(mRNA, prior_offset, end_offset));
        } else {
            System.out.println(this.getName() + " Has no mRNA");
        }
        return orf.toString();
    }

    private int getAdjustedFeaturePosition(int genomic_pos, SequenceEdit[] edit_list) {
        int plain_pos;
        int feat_pos = plain_pos = this.getFeaturePosition(genomic_pos);
        if (edit_list != null) {
            for (int i = 0; i < edit_list.length; ++i) {
                SequenceEdit seq_edit = edit_list[i];
                if ((seq_edit.getPosition() >= genomic_pos || this.getStrand() < 0) && (seq_edit.getPosition() <= genomic_pos || this.getStrand() >= 0)) continue;
                if (seq_edit.getEditType().equals("nucleotide_deletion")) {
                    --feat_pos;
                }
                if (!seq_edit.getEditType().equals("nucleotide_insertion")) continue;
                ++feat_pos;
            }
        }
        return feat_pos;
    }

    public int getFeaturePosition(int genomic_pos) {
        int offset = 0;
        int transcript_position = 1;
        boolean stop = false;
        RangeI previous = null;
        if (!this.canHaveChildren()) {
            return super.getFeaturePosition(genomic_pos);
        }
        SeqFeatureI held_in = this.getFeatureContaining(genomic_pos);
        int setSize = this.size();
        if (held_in != null && genomic_pos != 0) {
            if (!this.trans_spliced) {
                if (this.getStrand() == 1) {
                    for (int i = 0; i < setSize && !stop; ++i) {
                        SeqFeatureI span = this.getFeatureAt(i);
                        offset = previous == null ? genomic_pos - span.getStart() : (offset -= span.getStart() - previous.getEnd() - 1);
                        stop = genomic_pos <= span.getEnd();
                        previous = span;
                    }
                } else {
                    for (int i = 0; i < setSize && !stop; ++i) {
                        SeqFeatureI span = this.getFeatureAt(i);
                        offset = previous == null ? span.getStart() - genomic_pos : (offset -= previous.getEnd() - span.getStart() - 1);
                        stop = genomic_pos >= span.getEnd();
                        previous = span;
                    }
                }
                transcript_position = offset + 1;
            } else {
                for (int i = 0; i < setSize && !stop; ++i) {
                    SeqFeatureI span = this.getFeatureAt(i);
                    stop = span.contains(genomic_pos);
                    if (stop) {
                        offset += Math.abs(genomic_pos - span.getStart());
                        continue;
                    }
                    offset += span.length();
                }
                transcript_position = offset + 1;
            }
        } else {
            System.out.println("featureSet.getFeaturePosition: " + this.getName() + " (" + this.getStart() + "-" + this.getEnd() + ")" + " has no feature containing genomic_pos " + genomic_pos);
            transcript_position = 0;
        }
        return transcript_position;
    }

    public int getGenomicPosition(int transcript_pos) {
        if (!this.canHaveChildren()) {
            return super.getGenomicPosition(transcript_pos);
        }
        int genome_pos = -1;
        int transcript_offset = transcript_pos - 1;
        int setSize = this.size();
        for (int i = 0; i < setSize && genome_pos < 0; ++i) {
            int check;
            SeqFeatureI span = this.getFeatureAt(i);
            int start = span.getStart();
            int n = check = span.getStrand() == 1 ? start + transcript_offset : start - transcript_offset;
            if (span.contains(check)) {
                genome_pos = check;
            }
            transcript_offset -= span.length();
        }
        return genome_pos;
    }

    public int getGenomicPosForPeptidePos(int peptidePosition) {
        int featPos = peptidePosition * 3 + this.getFeaturePosition(this.getTranslationStart()) - 3;
        return this.getGenomicPosition(featPos);
    }

    protected void setPhases() {
        int i;
        int setSize = this.size();
        if (setSize == 0) {
            return;
        }
        SeqFeatureI start_span = this.getFeatureContaining(this.getTranslationStart());
        SeqFeatureI end_span = this.getFeatureContaining(this.getTranslationEnd());
        if (start_span == null || end_span == null) {
            System.err.println("FeatureSet.setPhases: " + this.getName() + " can't set phases--some sites undefined " + " tss=" + this.getTranslationStart() + " tes=" + this.getTranslationEnd());
            return;
        }
        int start_index = this.getFeatureIndex(start_span);
        int end_index = this.getFeatureIndex(end_span);
        for (int i2 = 0; i2 < start_index; ++i2) {
            this.getFeatureAt(i2).setPhase(0);
        }
        int phase = Math.abs(this.getTranslationStart() - start_span.getStart()) % 3;
        for (i = start_index; i <= end_index; ++i) {
            this.getFeatureAt(i).setPhase(phase);
            phase = (3 - this.getFeatureAt(i).getEndPhase()) % 3;
        }
        for (i = end_index + 1; i < setSize; ++i) {
            this.getFeatureAt(i).setPhase(0);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public boolean isTransSpliced() {
        return this.trans_spliced;
    }

    public void setMissing5prime(boolean partial) {
        this.missing_5prime = partial;
        if (partial) {
            this.start_codon = null;
        }
    }

    public boolean isMissing5prime() {
        return this.missing_5prime;
    }

    public void setMissing3prime(boolean partial) {
        this.missing_3prime = partial;
    }

    public boolean isMissing3prime() {
        return this.missing_3prime;
    }

    public boolean unConventionalStart() {
        return this.start_codon != null && !this.start_codon.equals(standard_start_codon);
    }

    public String getStartAA() {
        return this.na2aa(this.start_codon);
    }

    public String getStartCodon() {
        return this.start_codon;
    }

    public boolean hasReadThroughStop() {
        return this.readthrough_stop != null;
    }

    public String readThroughStopResidue() {
        return this.readthrough_stop;
    }

    public int readThroughStopPosition() {
        if (this.readthrough_stop != null) {
            return this.readthrough_pos;
        }
        return 0;
    }

    public void setReadThroughStop(boolean readthrough) {
        if (this.readthrough_stop == null && readthrough || this.readthrough_stop != null && !readthrough) {
            this.readthrough_stop = !readthrough ? null : this.genericReadThroughStopResidue;
            this.setTranslationEndFromStart();
        }
    }

    public void setReadThroughStop(String residue) {
        if (residue.equals("true") || residue.equals("false")) {
            this.setReadThroughStop(residue.equals("true"));
        } else if (this.readthrough_stop == null && residue != null || this.readthrough_stop != null && !this.readthrough_stop.equals(residue)) {
            if (!residue.equals("U") && !DNAUtils.isValidOneLetterAA((String)residue)) {
                String warn = "Warning: transcript " + this.getName() + " contains invalid amino acid code '" + residue + "' for readthrough stop codon";
                System.err.println(warn);
                if (Config.internalMode()) {
                    JOptionPane.showMessageDialog(null, warn);
                }
            }
            this.readthrough_stop = residue;
            this.setTranslationEndFromStart();
        }
    }

    public boolean isSequencingErrorPosition(int base_position) {
        if (this.getRefSequence() != null) {
            return this.getRefSequence().isSequencingErrorPosition(base_position);
        }
        return false;
    }

    public SequenceEdit getSequencingErrorAtPosition(int base_position) {
        if (this.getRefSequence() != null) {
            return this.getRefSequence().getSequencingErrorAtPosition(base_position);
        }
        return null;
    }

    public void flipFlop() {
        this.setStrand(this.getStrand() * -1);
        for (int i = 0; i < this.size(); ++i) {
            SeqFeatureI span = this.getFeatureAt(i);
            span.flipFlop();
        }
        this.sort(this.getStrand());
    }

    public Object clone() {
        FeatureSetI clone = (FeatureSetI)super.clone();
        if (clone != null && this.canHaveChildren()) {
            int setSize = this.size();
            ((FeatureSet)clone).clearKids();
            for (int i = 0; i < setSize; ++i) {
                SeqFeatureI span = this.getFeatureAt(i);
                clone.addFeature((SeqFeatureI)span.clone());
            }
        }
        return clone;
    }

    String prepareNonRegExpString(String in) {
        StringBuffer cleaned = new StringBuffer("^");
        char[] chars = in.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            switch (chars[index]) {
                case '*': {
                    cleaned.append('.');
                    break;
                }
                case '#': 
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    cleaned.append('\\');
                }
            }
            cleaned.append(chars[index]);
        }
        return cleaned.toString();
    }

    public RangeI getTranslationRange() {
        return new Range(this.getTranslationStart(), this.getTranslationEnd());
    }

    public void setPeptideValidity(boolean validity) {
    }

    public SequenceEdit[] buildEditList() {
        Object[] mRNAedits = this.buildmRNAEditList();
        SequenceEdit[] ORFedits = this.buildORFEditList();
        if (mRNAedits != null || ORFedits != null) {
            Object[] edit_list;
            if (mRNAedits != null && ORFedits != null) {
                SequenceEdit seq_edit;
                int i;
                int edits = mRNAedits.length + ORFedits.length;
                int[] int_list = new int[edits];
                edit_list = new SequenceEdit[edits];
                for (i = 0; i < mRNAedits.length; ++i) {
                    seq_edit = mRNAedits[i];
                    int_list[i] = seq_edit.getPosition();
                    edit_list[i] = seq_edit;
                }
                for (i = 0; i < ORFedits.length; ++i) {
                    seq_edit = ORFedits[i];
                    int_list[i] = seq_edit.getPosition();
                    edit_list[i] = seq_edit;
                }
                QuickSort.sort(int_list, edit_list);
            } else {
                edit_list = mRNAedits != null ? mRNAedits : ORFedits;
            }
            return edit_list;
        }
        return null;
    }

    protected SequenceEdit[] buildORFEditList() {
        int edits = (this.plus1_frameshift > 0 ? 1 : 0) + (this.minus1_frameshift > 0 ? 1 : 0);
        if (edits > 0) {
            int[] int_list = new int[edits];
            Object[] edit_list = new SequenceEdit[edits];
            int count = 0;
            if (this.plus1_frameshift > 0) {
                int_list[count] = this.plus1_frameshift;
                edit_list[count] = new SequenceEdit("nucleotide_deletion", int_list[count], null);
                ++count;
            }
            if (this.minus1_frameshift > 0) {
                int_list[count] = this.minus1_frameshift;
                String base = this.refSeq != null && this.refSeq.isSequenceAvailable(this.minus1_frameshift) ? this.refSeq.getResidues(this.minus1_frameshift - this.strand, this.minus1_frameshift) : null;
                edit_list[count] = new SequenceEdit("nucleotide_insertion", int_list[count], base.substring(0, 1));
                ++count;
            }
            QuickSort.sort(int_list, edit_list);
            return edit_list;
        }
        return null;
    }

    public int plus1FrameShiftPosition() {
        return this.plus1_frameshift;
    }

    public int minus1FrameShiftPosition() {
        return this.minus1_frameshift;
    }

    public boolean setPlus1FrameShiftPosition(int shift_pos) {
        boolean okay = true;
        if (this.plus1_frameshift != shift_pos) {
            if (shift_pos > 0) {
                okay = this.withinCDS(shift_pos);
            } else {
                shift_pos = 0;
            }
            if (okay) {
                this.plus1_frameshift = shift_pos;
                this.setTranslationEndFromStart();
            }
        }
        return okay;
    }

    public boolean setMinus1FrameShiftPosition(int shift_pos) {
        boolean okay = true;
        if (this.minus1_frameshift != shift_pos) {
            if (shift_pos > 0) {
                okay = this.withinCDS(shift_pos);
            } else {
                shift_pos = 0;
            }
            if (okay) {
                this.minus1_frameshift = shift_pos;
                this.setTranslationEndFromStart();
            }
        }
        return okay;
    }

    public boolean withinCDS(int pos) {
        boolean okay = true;
        int first_base = this.translation_start;
        int last_base = this.getLastBaseOfStopCodon();
        if (pos > 0) {
            okay = this.getIndexContaining(pos) != -1;
            okay &= this.getStrand() >= 0 && pos >= first_base || this.getStrand() == -1 && pos <= first_base;
            okay &= last_base == 0 || last_base != 0 && this.getStrand() >= 0 && pos <= last_base || last_base != 0 && this.getStrand() == -1 && pos >= last_base;
        }
        return okay;
    }

    public boolean isFlagSet(int mask) {
        return (this.flags & mask) != 0;
    }

    public void setFlag(boolean state, byte mask) {
        if (state) {
            this.flags = (byte)(this.flags | mask);
        } else if ((this.flags & mask) == mask) {
            this.flags = (byte)(this.flags ^ mask);
        }
    }

    public String toString() {
        return "[FeatureSet " + this.id + ": type = " + this.type + ", biotype = " + this.biotype + ", range = " + this.getStart() + "-" + this.getEnd() + (this.getStrand() == -1 ? " (minus)" : "; has " + this.getFeatures().size() + "" + " children]");
    }

    public boolean rangeIsUnassigned() {
        return super.rangeIsUnassigned() || this.low == 1000000000 && this.high == -1000000000;
    }
}

