/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.ExonI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;

public class Exon
extends AnnotatedFeature
implements ExonI {
    private static final String acceptor_site = "AG";
    private static final String donor_site = "GT";

    public Exon(SeqFeatureI sf) {
        super(sf);
        this.setup();
    }

    public Exon() {
        this.setup();
    }

    public boolean isExon() {
        return true;
    }

    private void setup() {
        this.setFeatureType("exon");
        this.annotationRoot = false;
    }

    public boolean canHaveChildren() {
        return false;
    }

    public int getFrame() {
        int frame;
        if (!this.containsCoding()) {
            return -1;
        }
        Transcript t = (Transcript)this.getRefFeature();
        if (!t.hasTranslationStart()) {
            return -1;
        }
        if (this.isFirstCodingExon()) {
            int start = t.getTranslationStart();
            frame = this.getRefSequence().getFrame(start, this.isForwardStrand());
        } else {
            int firstCodon = this.getStart() + this.getPhase() * this.getStrand();
            frame = this.getRefSequence().getFrame(firstCodon, this.isForwardStrand());
        }
        return frame + 1;
    }

    private boolean isFirstCodingExon() {
        Transcript t = (Transcript)this.getRefFeature();
        if (!t.hasTranslationStart()) {
            return false;
        }
        return this.contains(t.getTranslationStart());
    }

    private boolean outsideOfRegion() {
        if (this.getRefSequence() == null) {
            System.out.println("Exon.outsideOfRegion: ref sequence is null for exon " + this.getId());
            return false;
        }
        return !this.getRefSequence().getRange().contains(this);
    }

    public String toString() {
        String frame;
        String string = frame = this.getFrame() == -1 ? "non coding" : "frame " + this.getFrame();
        if (this.outsideOfRegion()) {
            frame = "outside of region";
        }
        return this.getFeatureType() + " " + this.getRefFeature() + " (" + frame + "): " + this.getStart() + "-" + this.getEnd();
    }

    public String getAcceptor() {
        return this.getRefSequence().getResidues(this.getStart() - 2 * this.getStrand(), this.getStart() - this.getStrand());
    }

    public String getDonor() {
        return this.getRefSequence().getResidues(this.getEnd() + this.getStrand(), this.getEnd() + 2 * this.getStrand());
    }

    public boolean isNonConsensusAcceptor() {
        boolean odd = false;
        if (this.isProteinCodingGene() && this.isSequenceAvailable(this.getStart()) && this.getTranscript().getFeatureIndex(this) > 0) {
            String acc = this.getAcceptor();
            odd = acc != null && !acc.equals(acceptor_site);
        }
        return odd;
    }

    public boolean isNonConsensusDonor() {
        boolean odd = false;
        if (this.isProteinCodingGene() && this.isSequenceAvailable(this.getEnd()) && this.getTranscript().getFeatureIndex(this) < this.getTranscript().size() - 1) {
            String don = this.getDonor();
            odd = !don.equals(donor_site);
        }
        return odd;
    }

    public boolean containsCoding() {
        int cp = this.getCodingProperties();
        return cp == 3 || cp == 1 || cp == 2 || cp == 4;
    }

    public String getTopLevelType() {
        if (this.getRefFeature() != null && this.getRefFeature().getRefFeature() != null) {
            return this.getRefFeature().getRefFeature().getTopLevelType();
        }
        if (this.biotype == null || this.biotype.equals("")) {
            return this.getFeatureType();
        }
        return this.biotype;
    }

    public Transcript getTranscript() {
        return (Transcript)this.getRefFeature();
    }

    public boolean isProteinCodingGene() {
        return this.getTranscript().isProteinCodingGene();
    }
}

