/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.DbXref;
import apollo.datamodel.EvidenceConstants;
import apollo.util.Visitor;
import java.io.Serializable;

public class Evidence
implements EvidenceConstants,
Serializable {
    int type;
    String featureId;
    String setId;
    String dbType;
    DbXref dbXref;

    public Evidence(String featureId, String setId, int type) {
        if (featureId == null || featureId.equals("")) {
            throw new NullPointerException("Can't accept empty feature ID as evidence");
        }
        this.setFeatureId(featureId);
        this.setSetId(setId);
        this.setType(type);
    }

    public Evidence(String featureId, int type) {
        this(featureId, "", type);
    }

    public Evidence(String featureId) {
        this(featureId, "", 1);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getTypeAsString() {
        if (this.type < EvidenceConstants.typeStrings.length) {
            return EvidenceConstants.typeStrings[this.type];
        }
        System.err.println("Unknown evidence type: " + this.type);
        return "unknown";
    }

    public void setFeatureId(String featureId) {
        this.featureId = new String(featureId);
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setSetId(String setId) {
        this.setId = new String(setId);
    }

    public String getSetId() {
        return this.setId;
    }

    public DbXref getDbXref() {
        return this.dbXref;
    }

    public void setDbXref(DbXref newValue) {
        this.dbXref = newValue;
    }

    public String toString() {
        return "This is evidence for featureId " + this.featureId;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

