/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny.builder;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.synteny.builder.AdapterModel;
import apollo.dataadapter.synteny.builder.Controller;
import apollo.dataadapter.synteny.builder.Model;
import apollo.util.GuiUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class View
extends JPanel {
    private JSplitPane treeToAdapterSplitPane;
    private JSplitPane adapterToGUISplitPane;
    private JScrollPane treeScrollPane;
    private JTree tree;
    private Hashtable treeHash;
    private DefaultMutableTreeNode rootNode;
    private JPanel adapterPanel;
    private JPanel setPanel;
    private JPanel setAndAdapterPanel;
    private JScrollPane adapterPropertiesScrollPane;
    private JTable propertiesTable;
    private DefaultTableModel propertiesTableModel;
    private JComboBox setDropDown;
    private JButton createSetButton;
    private JButton deleteSetButton;
    private JLabel setLabel;
    private JTextField nameTextField;
    private JLabel nameLabel;
    private JComboBox adapterClassDropdown;
    private JLabel adapterClassLabel;
    private JComboBox adapterTypeDropdown;
    private JLabel adapterTypeLabel;
    private Controller controller;
    private JButton createButton;
    private JButton updateButton;
    private JButton deleteButton;
    private JPanel guiPanel;

    public void initialiseGUI() {
        if (this.getController() == null) {
            throw new NonFatalDataAdapterException("Error: attempt to initialise builder GUI without setting controller");
        }
        this.buildGUI();
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.adapterClassDropdown = new JComboBox();
        this.adapterClassDropdown.setPreferredSize(new Dimension(300, 20));
        this.adapterClassDropdown.setMinimumSize(this.adapterClassDropdown.getPreferredSize());
        this.adapterClassLabel = new JLabel("Adapter class");
        this.adapterTypeDropdown = new JComboBox();
        this.adapterTypeDropdown.setPreferredSize(this.adapterClassDropdown.getPreferredSize());
        this.adapterTypeDropdown.setMinimumSize(this.adapterClassDropdown.getPreferredSize());
        this.adapterTypeLabel = new JLabel("Adapter type:");
        this.nameTextField = new JTextField();
        this.nameTextField.setPreferredSize(this.adapterClassDropdown.getPreferredSize());
        this.nameTextField.setMinimumSize(this.adapterClassDropdown.getPreferredSize());
        this.nameLabel = new JLabel("Name");
        this.createButton = new JButton("Create");
        this.addButtonEventRouter(this.createButton, Controller.CREATE_BUTTON);
        this.updateButton = new JButton("Update");
        this.addButtonEventRouter(this.updateButton, Controller.UPDATE_BUTTON);
        this.deleteButton = new JButton("Delete");
        this.addButtonEventRouter(this.deleteButton, Controller.DELETE_BUTTON);
        this.propertiesTableModel = new DefaultTableModel(new Object[0][], new Object[]{"Key", "Value"});
        this.propertiesTable = new JTable(this.propertiesTableModel);
        this.adapterPropertiesScrollPane = new JScrollPane(this.propertiesTable);
        this.adapterPropertiesScrollPane.setPreferredSize(new Dimension(200, 100));
        this.setAndAdapterPanel = new JPanel(new GridLayout(2, 1));
        this.setPanel = new JPanel();
        this.setPanel.setBorder(BorderFactory.createTitledBorder("Adapter Sets"));
        this.setPanel.setLayout(new GridBagLayout());
        this.setDropDown = new JComboBox();
        this.addDropDownSelectionEventRouter(this.setDropDown, Controller.DROPDOWN_SELECT_SET);
        this.addDropDownKeystrokeEventRouter(this.setDropDown, Controller.DROPDOWN_KEY_PRESSED);
        this.setLabel = new JLabel("Sets");
        this.createSetButton = new JButton("Create Set");
        this.addButtonEventRouter(this.createSetButton, Controller.CREATE_SET_BUTTON);
        this.deleteSetButton = new JButton("Delete Set");
        this.addButtonEventRouter(this.deleteSetButton, Controller.DELETE_SET_BUTTON);
        this.getSetDropDown().setPreferredSize(this.adapterClassDropdown.getPreferredSize());
        this.getSetDropDown().setEditable(true);
        this.setPanel.add((Component)this.getSetLabel(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.setPanel.add((Component)this.getSetDropDown(), GuiUtil.makeConstraintAt(1, 0, 2));
        this.setPanel.add((Component)this.getCreateSetButton(), GuiUtil.makeConstraintAt(1, 1, 1));
        this.setPanel.add((Component)this.getDeleteSetButton(), GuiUtil.makeConstraintAt(2, 1, 1));
        this.adapterPanel = new JPanel();
        this.adapterPanel.setBorder(BorderFactory.createTitledBorder("Adapters for Set"));
        this.adapterPanel.setLayout(new GridBagLayout());
        this.adapterPanel.add((Component)this.getNameLabel(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.adapterPanel.add((Component)this.getNameTextField(), GuiUtil.makeConstraintAt(1, 0, 3));
        this.adapterPanel.add((Component)this.getAdapterClassLabel(), GuiUtil.makeConstraintAt(0, 1, 1));
        this.adapterPanel.add((Component)this.getAdapterClassDropdown(), GuiUtil.makeConstraintAt(1, 1, 3));
        this.adapterPanel.add((Component)this.getCreateButton(), GuiUtil.makeConstraintAt(1, 4, 1));
        this.adapterPanel.add((Component)this.getUpdateButton(), GuiUtil.makeConstraintAt(2, 4, 1));
        this.adapterPanel.add((Component)this.getDeleteButton(), GuiUtil.makeConstraintAt(3, 4, 1));
        this.setAndAdapterPanel.add(this.setPanel);
        this.setAndAdapterPanel.add(this.adapterPanel);
        this.rootNode = new DefaultMutableTreeNode("Composite");
        this.tree = new JTree(this.rootNode);
        this.addMouseEventRouter(this.tree, this.getController());
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treeScrollPane.setPreferredSize(new Dimension(100, 200));
        this.treeToAdapterSplitPane = new JSplitPane(1, this.treeScrollPane, this.setAndAdapterPanel);
        this.guiPanel = new JPanel();
        this.guiPanel.setLayout(new CardLayout());
        JScrollPane cardScrollPane = new JScrollPane(this.guiPanel);
        cardScrollPane.setPreferredSize(new Dimension(300, 300));
        this.adapterToGUISplitPane = new JSplitPane(0, this.treeToAdapterSplitPane, cardScrollPane);
        this.add((Component)this.adapterToGUISplitPane, "Center");
    }

    public void read(Model model) {
        List adapterModels;
        String setName;
        int i;
        AdapterModel selectedModel = null;
        int row = 0;
        if (model.getMessage() != null) {
            JOptionPane.showMessageDialog(this, model.getMessage());
            model.setMessage(null);
        }
        if (model.reloadAdapterPanel()) {
            ArrayList sortedSets = new ArrayList(model.getAdapterSets().keySet());
            Collections.sort(sortedSets);
            sortedSets.add(0, null);
            this.getSetDropDown().setModel(new DefaultComboBoxModel(new Vector(sortedSets)));
            String selectedSet = model.getSelectedAdapterSet();
            if (selectedSet != null) {
                this.getSetDropDown().setSelectedItem(selectedSet);
            } else {
                this.getSetDropDown().setSelectedIndex(0);
            }
            this.getAdapterClassDropdown().setModel(new DefaultComboBoxModel(new Vector(model.getAllowedAdapterClasses())));
            this.getAdapterTypeDropdown().setModel(new DefaultComboBoxModel(new Vector(model.getAllowedAdapterTypes())));
            selectedModel = model.getSelectedAdapterModel();
            if (selectedModel != null) {
                this.getNameTextField().setText(selectedModel.getName());
                this.getAdapterClassDropdown().setSelectedItem(selectedModel.getAdapterClassName());
                this.getAdapterTypeDropdown().setSelectedItem(selectedModel.getType());
                row = 0;
                Properties modelProperties = selectedModel.getProperties();
                ArrayList<Object> keyList = new ArrayList<Object>(modelProperties.keySet());
                Collections.sort(keyList);
                Iterator keyIterator = keyList.iterator();
                ((DefaultTableModel)this.getPropertiesTable().getModel()).setRowCount(modelProperties.keySet().size());
                while (keyIterator.hasNext()) {
                    String key = (String)keyIterator.next();
                    String value = modelProperties.getProperty(key);
                    this.getPropertiesTable().getModel().setValueAt(key, row, 0);
                    this.getPropertiesTable().getModel().setValueAt(value, row, 1);
                    ++row;
                }
            } else {
                this.getNameTextField().setText("");
                this.getAdapterClassDropdown().setSelectedIndex(0);
                this.getAdapterTypeDropdown().setSelectedIndex(0);
                ((DefaultTableModel)this.getPropertiesTable().getModel()).setRowCount(0);
            }
        }
        if (model.reloadTree()) {
            this.treeHash = new Hashtable();
            this.getRootNode().removeAllChildren();
            ((DefaultTreeModel)this.getTree().getModel()).reload();
            if (model.getSelectedAdapterSet() != null) {
                AdapterModel mainModel = this.getMainAdapterModel(model);
                List childModels = this.getChildAdapterModels(model);
                if (mainModel != null) {
                    this.createMainModelTreeNode(mainModel);
                }
                for (int i2 = 0; i2 < childModels.size(); ++i2) {
                    this.createChildTreeNode((AdapterModel)childModels.get(i2));
                }
                ((DefaultTreeModel)this.getTree().getModel()).reload();
                int numberOfRows = this.getTree().getRowCount();
                for (i = 0; i < numberOfRows; ++i) {
                    this.getTree().expandRow(i);
                }
                if (model.getSelectedAdapterModel() != null) {
                    this.findNamedNodeInTree(model.getSelectedAdapterModel().getName());
                }
            }
        }
        if (model.reloadGUIs()) {
            this.getGUIPanel().removeAll();
            if (model.getSelectedAdapterSet() != null && (setName = model.getSelectedAdapterSet()) != null) {
                adapterModels = model.getAdapterModels(setName);
                for (i = 0; i < adapterModels.size(); ++i) {
                    String adapterKey = ((AdapterModel)adapterModels.get(i)).getName();
                    this.getGUIPanel().add((Component)model.getAdapterGUIMap().get(adapterKey), adapterKey);
                }
            }
            this.getGUIPanel().invalidate();
            this.getGUIPanel().validate();
            this.getGUIPanel().repaint();
        }
        if ((setName = model.getSelectedAdapterSet()) != null) {
            adapterModels = model.getAdapterModels(setName);
            CardLayout layout = (CardLayout)this.getGUIPanel().getLayout();
            if (adapterModels.size() > 0 && selectedModel != null) {
                layout.show(this.getGUIPanel(), selectedModel.getName());
            }
        }
        model.setReloadAll();
    }

    protected DefaultMutableTreeNode findTreeNode(String name) {
        return this.treeHash == null || name == null ? null : (DefaultMutableTreeNode)this.treeHash.get(name);
    }

    public void findNamedNodeInTree(String name) {
        DefaultMutableTreeNode dmtn = null;
        if (name != null) {
            dmtn = this.findTreeNode(name);
            if (dmtn != null) {
                DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
                Object[] objs = model.getPathToRoot(dmtn);
                TreePath treep = new TreePath(objs);
                this.tree.paintImmediately(0, 0, this.tree.getSize().width, this.tree.getSize().height);
                TreeSelectionModel selModel = this.tree.getSelectionModel();
                selModel.addSelectionPath(treep);
                this.tree.scrollPathToVisible(treep);
            }
        } else {
            this.tree.setSelectionPath(null);
        }
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.getTree().getSelectionPath() != null) {
            return (DefaultMutableTreeNode)this.getTree().getSelectionPath().getLastPathComponent();
        }
        return null;
    }

    public TreePath getSelectedTreePath() {
        if (this.getTree().getSelectionPath() != null) {
            return this.getTree().getSelectionPath();
        }
        return null;
    }

    private Controller getController() {
        return this.controller;
    }

    public void setController(Controller newValue) {
        this.controller = newValue;
    }

    private void createMainModelTreeNode(AdapterModel mainModel) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(mainModel.getName());
        ((DefaultMutableTreeNode)this.getTree().getModel().getRoot()).add(node);
        this.treeHash.put(mainModel.getName(), node);
    }

    private void createChildTreeNode(AdapterModel childModel) {
        DefaultMutableTreeNode mainNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getTree().getModel().getRoot()).getChildAt(0);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(childModel.getName());
        mainNode.add(node);
        this.treeHash.put(childModel.getName(), node);
    }

    public void update(Model model) {
        model.getSelectedAdapterModel().setName(this.getNameTextField().getText());
        model.getSelectedAdapterModel().setAdapterClassName((String)this.getAdapterClassDropdown().getSelectedItem());
        model.getSelectedAdapterModel().setType((String)this.getAdapterTypeDropdown().getSelectedItem());
    }

    public AdapterModel getNewAdapterModel(Model model) {
        String set = model.getSelectedAdapterSet();
        String newType = model.getAdapterModels(set).size() > 0 ? AdapterModel.CHILD_TYPE : AdapterModel.MAIN_TYPE;
        AdapterModel newModel = new AdapterModel(this.getNameTextField().getText(), (String)this.getAdapterClassDropdown().getSelectedItem(), newType);
        return newModel;
    }

    public String getNewSetName() {
        return this.getSetDropDown().getSelectedItem().toString();
    }

    public String getSelectedSetName() {
        if (this.getSetDropDown() != null && this.getSetDropDown().getSelectedItem() != null) {
            return this.getSetDropDown().getSelectedItem().toString();
        }
        return null;
    }

    private List getChildAdapterModels(Model model) {
        String set = model.getSelectedAdapterSet();
        Iterator adapterModels = model.getAdapterModels(set).iterator();
        ArrayList<AdapterModel> returnList = new ArrayList<AdapterModel>();
        while (adapterModels.hasNext()) {
            AdapterModel adapterModel = (AdapterModel)adapterModels.next();
            if (!adapterModel.getType().equals(AdapterModel.CHILD_TYPE)) continue;
            returnList.add(adapterModel);
        }
        return returnList;
    }

    private AdapterModel getMainAdapterModel(Model model) {
        String set = model.getSelectedAdapterSet();
        Iterator adapterModels = model.getAdapterModels(set).iterator();
        while (adapterModels.hasNext()) {
            AdapterModel adapterModel = (AdapterModel)adapterModels.next();
            if (!adapterModel.getType().equals(AdapterModel.MAIN_TYPE)) continue;
            return adapterModel;
        }
        return null;
    }

    private JPanel getGUIPanel() {
        return this.guiPanel;
    }

    private DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    private JScrollPane getTreeScrollPane() {
        return this.treeScrollPane;
    }

    private JTree getTree() {
        return this.tree;
    }

    private JPanel getAdapterPanel() {
        return this.adapterPanel;
    }

    public void disableAdapterPanel() {
        this.getNameTextField().setEnabled(false);
        this.getAdapterClassDropdown().setEnabled(false);
        this.getCreateButton().setEnabled(false);
        this.getDeleteButton().setEnabled(false);
        this.getUpdateButton().setEnabled(false);
    }

    public void enableAdapterPanel() {
        this.getNameTextField().setEnabled(true);
        this.getAdapterClassDropdown().setEnabled(true);
        this.getCreateButton().setEnabled(true);
        this.getDeleteButton().setEnabled(true);
        this.getUpdateButton().setEnabled(true);
    }

    private JScrollPane getAdapterPropertiesScrollPane() {
        return this.adapterPropertiesScrollPane;
    }

    private JTable getPropertiesTable() {
        return this.propertiesTable;
    }

    private JLabel getNameLabel() {
        return this.nameLabel;
    }

    private JTextField getNameTextField() {
        return this.nameTextField;
    }

    private JComboBox getAdapterClassDropdown() {
        return this.adapterClassDropdown;
    }

    private JComboBox getAdapterTypeDropdown() {
        return this.adapterTypeDropdown;
    }

    private JLabel getAdapterClassLabel() {
        return this.adapterClassLabel;
    }

    private JLabel getAdapterTypeLabel() {
        return this.adapterTypeLabel;
    }

    private JSplitPane gettreeToAdapterSplitPane() {
        return this.treeToAdapterSplitPane;
    }

    private JSplitPane getAdapterToGUISplitPane() {
        return this.adapterToGUISplitPane;
    }

    private JButton getCreateButton() {
        return this.createButton;
    }

    private JButton getUpdateButton() {
        return this.updateButton;
    }

    private JButton getDeleteButton() {
        return this.deleteButton;
    }

    private void addButtonEventRouter(JButton button, final String eventKey) {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (View.this.getController().ignoreEvents()) {
                    return;
                }
                View.this.getController().handleEvent(eventKey);
            }
        };
        button.addActionListener(listener);
    }

    private void addDropDownSelectionEventRouter(JComboBox dropDown, final String eventKey) {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (View.this.getController().ignoreEvents()) {
                    return;
                }
                View.this.getController().handleEvent(eventKey);
            }
        };
        dropDown.addActionListener(listener);
    }

    private void addDropDownKeystrokeEventRouter(JComboBox dropDown, final String eventKey) {
        KeyListener listener = new KeyListener(){

            public void keyTyped(KeyEvent event) {
                if (View.this.getController().ignoreEvents()) {
                    return;
                }
                View.this.getController().handleEvent(eventKey);
            }

            public void keyPressed(KeyEvent event) {
                if (View.this.getController().ignoreEvents()) {
                    return;
                }
                View.this.getController().handleEvent(eventKey);
            }

            public void keyReleased(KeyEvent event) {
                if (View.this.getController().ignoreEvents()) {
                    return;
                }
                View.this.getController().handleEvent(eventKey);
            }
        };
        dropDown.addKeyListener(listener);
    }

    private void addMouseEventRouter(JTree tree, Controller controller) {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (View.this.getController().ignoreEvents()) {
                    return;
                }
                View.this.getController().handleEvent(Controller.MOUSE_LEFT_CLICK_ON_TREE);
            }
        };
        tree.addMouseListener(mouseListener);
    }

    private JComboBox getSetDropDown() {
        return this.setDropDown;
    }

    private JButton getCreateSetButton() {
        return this.createSetButton;
    }

    private JButton getDeleteSetButton() {
        return this.deleteSetButton;
    }

    private JLabel getSetLabel() {
        return this.setLabel;
    }
}

