/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny.builder;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.StateInformation;
import apollo.dataadapter.synteny.builder.BuilderAdapterGUI;
import apollo.dataadapter.synteny.builder.Model;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeatureI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.MultiProperties;

public class BuilderAdapter
extends AbstractApolloAdapter {
    private MultiProperties stateInformation = new MultiProperties();
    private BuilderAdapterGUI gui;

    public Model getModel() {
        if (this.gui != null) {
            return this.gui.getController().getModel();
        }
        return Model.fromXML();
    }

    public String getName() {
        return "Builder";
    }

    public String getType() {
        return "Builder Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        return new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA};
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (this.gui == null) {
            this.gui = new BuilderAdapterGUI(op, this.getModel());
        }
        return this.gui;
    }

    public void setStateInformation(Properties properties) {
        this.stateInformation.putAll((Map)properties);
        Model model = this.getModel();
        Iterator adapterKeys = model.getAdapterMap().keySet().iterator();
        HashMap adapters = model.getAdapterMap();
        String region = properties.getProperty("region");
        System.out.println("Builder adapter running set state info with input props: " + properties);
        System.out.println(" -- found region: " + region);
        System.out.println("region: " + region);
        if (properties instanceof MultiProperties) {
            System.out.println("set using multiprops being propagated to kids");
            while (adapterKeys.hasNext()) {
                String key = (String)adapterKeys.next();
                MultiProperties childProperties = ((MultiProperties)properties).getProperties(key);
                if (region != null && region.trim().length() > 0) {
                    childProperties.setProperty("region", region);
                }
                System.out.println("propagating: " + key + " values: " + childProperties);
                ((AbstractApolloAdapter)adapters.get(key)).setStateInformation((Properties)childProperties);
            }
        }
    }

    public void init() {
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        Iterator keys = this.getModel().getAdapterMap().keySet().iterator();
        StateInformation childState = new StateInformation();
        String selectedAdapterSet = this.getModel().getSelectedAdapterSet();
        String mainAdapterKey = this.getModel().getMainAdapterModel(selectedAdapterSet).getName();
        boolean setRegionOnChildren = false;
        Model model = this.getModel();
        AbstractApolloAdapter adapter = (AbstractApolloAdapter)model.getAdapterMap().get(mainAdapterKey);
        CurationSet returnSet = adapter.getCurationSet();
        String region = this.getStateInformation().getProperty("region");
        if (region == null && returnSet.getChromosome() != null && returnSet.getStart() > 0 && returnSet.getEnd() > 0) {
            setRegionOnChildren = true;
            region = "Chr " + returnSet.getChromosome() + " " + String.valueOf(returnSet.getStart()) + " " + String.valueOf(returnSet.getEnd());
            ((Properties)childState).setProperty("region", region);
            System.out.println("Builder adapter getCurationSet finds region null - created region: " + region);
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            adapter = (AbstractApolloAdapter)model.getAdapterMap().get(key);
            if (key.equals(mainAdapterKey)) continue;
            if (setRegionOnChildren) {
                System.out.println("Setting region on child: " + key + " -- " + childState);
                adapter.setStateInformation(childState);
            }
            CurationSet childSet = adapter.getCurationSet();
            this.copyFeaturesFromChildToParent(childSet, returnSet);
        }
        return returnSet;
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public Properties getStateInformation() {
        return this.stateInformation;
    }

    public void setRegion(String region) throws ApolloAdapterException {
        this.region = region;
        Iterator adapters = this.getModel().getAdapterMap().values().iterator();
        while (adapters.hasNext()) {
            ((AbstractApolloAdapter)adapters.next()).setRegion(region);
        }
    }

    private void copyFeaturesFromChildToParent(CurationSet child, CurationSet parent) {
        SeqFeatureI sf;
        int i;
        System.out.println("copying features from child to parent");
        Vector from = child.getResults().getFeatures();
        for (i = 0; i < from.size(); ++i) {
            sf = (SeqFeatureI)from.get(i);
            sf.setRefSequence(parent.getResults().getRefSequence());
            parent.getResults().addFeature(sf, false);
        }
        from = child.getAnnots().getFeatures();
        for (i = 0; i < from.size(); ++i) {
            sf = (SeqFeatureI)from.get(i);
            sf.setRefSequence(parent.getAnnots().getRefSequence());
            parent.getAnnots().addFeature(sf, false);
        }
    }

    public void clearStateInformation() {
        this.stateInformation = new MultiProperties();
    }
}

