/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.synteny.AlignBlockChooser;
import apollo.dataadapter.synteny.SyntenyComparaAdapterGUI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.ensembl.compara.driver.ComparaDriver;
import org.ensembl.compara.driver.ComparaDriverFactory;
import org.ensembl.compara.driver.DnaDnaAlignFeatureAdaptor;
import org.ensembl.compara.driver.MemberAdaptor;
import org.ensembl.datamodel.AssemblyLocation;
import org.ensembl.datamodel.DnaDnaAlignFeature;
import org.ensembl.datamodel.Location;
import org.ensembl.driver.AdaptorException;
import org.ensembl.driver.ConfigurationException;

public class SyntenyComparaAdapter
extends AbstractApolloAdapter {
    private SyntenyComparaAdapterGUI theAdapterGUI;
    private String querySpecies;
    private String hitSpecies;
    private int start;
    private int end;
    private String chromosome;
    private String coordsystem;
    private int hitStart;
    private int hitEnd;
    private String hitChromosome;
    private String hitCoordSystem;
    private String dnaAligns;
    private String highConservationDnaAligns;
    private String proteinAligns;
    private String queryStableId;
    private String hitStableId;
    private String stableId;
    public static int BUFFER_SIZE = 200000;
    protected Properties stateInformation;
    private String loggingFile;
    protected Properties driverConf;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA};

    public DataAdapterUI getUI(IOOperation op) {
        return new SyntenyComparaAdapterGUI(op);
    }

    public void setLoggingFile(String v) {
        this.loggingFile = v;
    }

    public Properties getStateInformation() {
        return this.stateInformation;
    }

    public void setDriverConf(Properties v) {
        this.driverConf = v;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    private FeaturePair convertEnsJFeaturePairToApolloFeaturePair(org.ensembl.datamodel.FeaturePair ensJFeaturePair, String type, boolean invertFeatures) {
        SeqFeature queryFeature = new SeqFeature();
        SeqFeature hitFeature = new SeqFeature();
        queryFeature.setId(ensJFeaturePair.getDisplayName());
        queryFeature.setStart(ensJFeaturePair.getLocation().getStart());
        queryFeature.setEnd(ensJFeaturePair.getLocation().getEnd());
        if (ensJFeaturePair.getDescription() != null) {
            queryFeature.setName(ensJFeaturePair.getDescription());
        } else {
            queryFeature.setName("no_name");
        }
        queryFeature.setStrand(ensJFeaturePair.getLocation().getStrand());
        hitFeature.setId(ensJFeaturePair.getDisplayName());
        hitFeature.setStart(ensJFeaturePair.getHitLocation().getStart());
        hitFeature.setEnd(ensJFeaturePair.getHitLocation().getEnd());
        if (ensJFeaturePair.getHitDescription() != null) {
            hitFeature.setName(ensJFeaturePair.getHitDescription());
        } else {
            hitFeature.setName("no_name");
        }
        hitFeature.setStrand(ensJFeaturePair.getHitLocation().getStrand());
        FeaturePair apolloFeaturePair = !invertFeatures ? new FeaturePair(queryFeature, hitFeature) : new FeaturePair(hitFeature, queryFeature);
        apolloFeaturePair.setFeatureType(type);
        if (type.equals("dna-dna-align")) {
            apolloFeaturePair.setScore(((DnaDnaAlignFeature)ensJFeaturePair).getPercentageIdentity());
            if (((DnaDnaAlignFeature)ensJFeaturePair).getMethodLinkType().equals("BLASTZ_NET_TIGHT")) {
                apolloFeaturePair.setFeatureType("dna-dna-align-high-conservation");
            }
        }
        apolloFeaturePair.setCigar(ensJFeaturePair.getCigarString());
        return apolloFeaturePair;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        StrandedFeatureSet featureSet;
        CurationSet curationSet;
        block16: {
            curationSet = new CurationSet();
            featureSet = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            try {
                ComparaDriver comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)this.getStateInformation());
                DnaDnaAlignFeatureAdaptor dnaDnaAlignFeatureAdaptor = (DnaDnaAlignFeatureAdaptor)comparaDriver.getAdaptor("dna_dna_align_feature");
                MemberAdaptor memberAdaptor = (MemberAdaptor)comparaDriver.getAdaptor("member");
                if (this.getProteinAligns().equals(String.valueOf(true))) {
                    if (this.getChromosome() != null && this.getChromosome().trim().length() > 0 && this.getHitChromosome() != null && this.getHitChromosome().trim().length() > 0) {
                        this.findProteinAlignsForLocationAndSpecies(this.getQuerySpecies(), new AssemblyLocation(this.getChromosome(), this.getStart(), this.getEnd(), 0), this.getHitSpecies(), new AssemblyLocation(this.getHitChromosome(), this.getHitStart(), this.getHitEnd(), 0), featureSet);
                    } else if (this.getChromosome() != null && this.getChromosome().trim().length() > 0) {
                        this.findProteinAlignsForLocationAndSpecies(this.getQuerySpecies(), new AssemblyLocation(this.getChromosome(), this.getStart(), this.getEnd(), 0), this.getHitSpecies(), featureSet, curationSet, false);
                    } else if (this.getHitChromosome() != null && this.getHitChromosome().trim().length() > 0) {
                        this.findProteinAlignsForLocationAndSpecies(this.getHitSpecies(), new AssemblyLocation(this.getHitChromosome(), this.getHitStart(), this.getHitEnd(), 0), this.getQuerySpecies(), featureSet, curationSet, true);
                    } else if (this.getQueryStableId() != null) {
                        this.findProteinAlignsForStableIdAndSpecies(this.getQuerySpecies(), new String[]{this.getQueryStableId()}, this.getHitSpecies(), featureSet, false);
                    } else if (this.getHitStableId() != null) {
                        this.findProteinAlignsForStableIdAndSpecies(this.getHitSpecies(), new String[]{this.getHitStableId()}, this.getQuerySpecies(), featureSet, true);
                    }
                }
                if (!this.getDnaAligns().equals(String.valueOf(true)) && !this.getHighConservationDnaAligns().equals(String.valueOf(true))) break block16;
                if (this.getChromosome() != null && this.getHitChromosome() != null) {
                    this.findDnaAlignsForLocationAndSpecies(this.getQuerySpecies(), new AssemblyLocation(this.getChromosome(), this.getStart(), this.getEnd(), 0), this.getHitSpecies(), new AssemblyLocation(this.getHitChromosome(), this.getHitStart(), this.getHitEnd(), 0), featureSet, curationSet);
                    break block16;
                }
                if (this.getChromosome() != null) {
                    this.findDnaAlignsForLocationAndSpecies(this.getQuerySpecies(), new AssemblyLocation(this.getChromosome(), this.getStart(), this.getEnd(), 0), this.getHitSpecies(), featureSet, curationSet, false);
                    break block16;
                }
                if (this.getHitChromosome() != null) {
                    this.findDnaAlignsForLocationAndSpecies(this.getHitSpecies(), new AssemblyLocation(this.getHitChromosome(), this.getHitStart(), this.getHitEnd(), 0), this.getQuerySpecies(), featureSet, curationSet, true);
                    break block16;
                }
                throw new ApolloAdapterException("You have opted to read dna-aligns, but I cannot infer any range information");
            }
            catch (ConfigurationException exception) {
                throw new ApolloAdapterException(exception.getMessage());
            }
            catch (AdaptorException exception) {
                throw new ApolloAdapterException(exception.getMessage());
            }
        }
        curationSet.setResults(featureSet);
        return curationSet;
    }

    private void findDnaAlignsForLocationAndSpecies(String querySpecies, AssemblyLocation queryLocation, String hitSpecies, FeatureSetI featureSet, CurationSet curationSet, boolean queryAndHitAreInverted) throws ApolloAdapterException {
        try {
            ComparaDriver comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)this.getStateInformation());
            DnaDnaAlignFeatureAdaptor dnaDnaAlignFeatureAdaptor = (DnaDnaAlignFeatureAdaptor)comparaDriver.getAdaptor("dna_dna_align_feature");
            MemberAdaptor memberAdaptor = (MemberAdaptor)comparaDriver.getAdaptor("member");
            List list = null;
            list = this.getDnaAligns().equals(String.valueOf(true)) && !this.getHighConservationDnaAligns().equals(String.valueOf(true)) ? dnaDnaAlignFeatureAdaptor.fetch(querySpecies, (Location)queryLocation, hitSpecies, "BLASTZ_NET") : (this.getHighConservationDnaAligns().equals(String.valueOf(true)) && !this.getDnaAligns().equals(String.valueOf(true)) ? dnaDnaAlignFeatureAdaptor.fetch(querySpecies, (Location)queryLocation, hitSpecies, "BLASTZ_NET_TIGHT") : dnaDnaAlignFeatureAdaptor.fetch(querySpecies, (Location)queryLocation, hitSpecies));
            if (list.size() <= 0) {
                throw new ApolloAdapterException("No dna-dna alignments were found for the selected range -  I cannot infer the corresponding range on the hit species");
            }
            this.findLimitsOfAligns(list, curationSet);
            Iterator ensJFeaturePairs = list.iterator();
            int nConverted = 0;
            while (ensJFeaturePairs.hasNext()) {
                org.ensembl.datamodel.FeaturePair ensJFeaturePair = (org.ensembl.datamodel.FeaturePair)ensJFeaturePairs.next();
                if (!curationSet.getChromosome().equals(ensJFeaturePair.getHitLocation().getSeqRegionName())) continue;
                FeaturePair apolloFeaturePair = this.convertEnsJFeaturePairToApolloFeaturePair(ensJFeaturePair, "dna-dna-align", queryAndHitAreInverted);
                featureSet.addFeature(apolloFeaturePair, false);
                ++nConverted;
            }
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
    }

    private void findDnaAlignsForLocationAndSpecies(String querySpecies, AssemblyLocation queryLocation, String hitSpecies, AssemblyLocation hitLocation, FeatureSetI featureSet, CurationSet curationSet) throws ApolloAdapterException {
        try {
            ComparaDriver comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)this.getStateInformation());
            DnaDnaAlignFeatureAdaptor dnaDnaAlignFeatureAdaptor = (DnaDnaAlignFeatureAdaptor)comparaDriver.getAdaptor("dna_dna_align_feature");
            MemberAdaptor memberAdaptor = (MemberAdaptor)comparaDriver.getAdaptor("member");
            List list = null;
            list = this.getDnaAligns().equals(String.valueOf(true)) && !this.getHighConservationDnaAligns().equals(String.valueOf(true)) ? dnaDnaAlignFeatureAdaptor.fetch(querySpecies, (Location)queryLocation, hitSpecies, "BLASTZ_NET") : (this.getHighConservationDnaAligns().equals(String.valueOf(true)) && !this.getDnaAligns().equals(String.valueOf(true)) ? dnaDnaAlignFeatureAdaptor.fetch(querySpecies, (Location)queryLocation, hitSpecies, "BLASTZ_NET_TIGHT") : dnaDnaAlignFeatureAdaptor.fetch(querySpecies, (Location)queryLocation, hitSpecies));
            Iterator ensJFeaturePairs = list.iterator();
            int nConverted = 0;
            while (ensJFeaturePairs.hasNext()) {
                org.ensembl.datamodel.FeaturePair ensJFeaturePair = (org.ensembl.datamodel.FeaturePair)ensJFeaturePairs.next();
                if (!ensJFeaturePair.getHitLocation().getSeqRegionName().equals(hitLocation.getSeqRegionName())) continue;
                FeaturePair apolloFeaturePair = this.convertEnsJFeaturePairToApolloFeaturePair(ensJFeaturePair, "dna-dna-align", false);
                featureSet.addFeature(apolloFeaturePair, false);
                ++nConverted;
            }
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
    }

    private void findProteinAlignsForLocationAndSpecies(String querySpecies, AssemblyLocation location, String hitSpecies, AssemblyLocation hitLocation, FeatureSetI featureSet) throws ApolloAdapterException {
        boolean counter = false;
        try {
            ComparaDriver comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)this.getStateInformation());
            DnaDnaAlignFeatureAdaptor dnaDnaAlignFeatureAdaptor = (DnaDnaAlignFeatureAdaptor)comparaDriver.getAdaptor("dna_dna_align_feature");
            MemberAdaptor memberAdaptor = (MemberAdaptor)comparaDriver.getAdaptor("member");
            List list = memberAdaptor.fetch(querySpecies, (Location)location, hitSpecies, (Location)hitLocation);
            Iterator ensJFeaturePairs = list.iterator();
            while (ensJFeaturePairs.hasNext()) {
                org.ensembl.datamodel.FeaturePair ensJFeaturePair = (org.ensembl.datamodel.FeaturePair)ensJFeaturePairs.next();
                FeaturePair apolloFeaturePair = this.convertEnsJFeaturePairToApolloFeaturePair(ensJFeaturePair, "protein-protein-align", false);
                featureSet.addFeature(apolloFeaturePair, false);
            }
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
    }

    private void findProteinAlignsForLocationAndSpecies(String querySpecies, AssemblyLocation location, String hitSpecies, FeatureSetI featureSet, CurationSet curationSet, boolean areQueryAndHitInverted) throws ApolloAdapterException {
        int counter = 0;
        try {
            ComparaDriver comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)this.getStateInformation());
            MemberAdaptor memberAdaptor = (MemberAdaptor)comparaDriver.getAdaptor("member");
            List list = memberAdaptor.fetch(querySpecies, (Location)location, hitSpecies);
            if (list.size() <= 0) {
                throw new ApolloAdapterException("No protein alignments were found for the selected range -  I cannot infer the corresponding range on the hit species");
            }
            this.findLimitsOfAligns(list, curationSet);
            if (!areQueryAndHitInverted) {
                this.setHitChromosome(curationSet.getChromosome());
                this.setHitStart(curationSet.getStart());
                this.setHitEnd(curationSet.getEnd());
            } else {
                this.setChromosome(curationSet.getChromosome());
                this.setStart(curationSet.getStart());
                this.setEnd(curationSet.getEnd());
            }
            Iterator ensJFeaturePairs = list.iterator();
            counter = 0;
            while (ensJFeaturePairs.hasNext()) {
                org.ensembl.datamodel.FeaturePair ensJFeaturePair = (org.ensembl.datamodel.FeaturePair)ensJFeaturePairs.next();
                String chr = ensJFeaturePair.getHitLocation().getSeqRegionName();
                String chr2 = curationSet.getChromosome();
                if (!ensJFeaturePair.getHitLocation().getSeqRegionName().equals(curationSet.getChromosome())) continue;
                FeaturePair apolloFeaturePair = this.convertEnsJFeaturePairToApolloFeaturePair(ensJFeaturePair, "protein-protein-align", areQueryAndHitInverted);
                featureSet.addFeature(apolloFeaturePair, false);
                ++counter;
            }
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
    }

    private void findProteinAlignsForStableIdAndSpecies(String querySpecies, String[] stableIds, String hitSpecies, FeatureSetI featureSet, boolean areQueryAndHitInverted) throws ApolloAdapterException {
        int counter = 0;
        try {
            ComparaDriver comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)this.getStateInformation());
            DnaDnaAlignFeatureAdaptor dnaDnaAlignFeatureAdaptor = (DnaDnaAlignFeatureAdaptor)comparaDriver.getAdaptor("dna_dna_align_feature");
            MemberAdaptor memberAdaptor = (MemberAdaptor)comparaDriver.getAdaptor("member");
            Iterator ensJFeaturePairs = memberAdaptor.fetch(querySpecies, stableIds, hitSpecies).iterator();
            while (ensJFeaturePairs.hasNext()) {
                org.ensembl.datamodel.FeaturePair ensJFeaturePair = (org.ensembl.datamodel.FeaturePair)ensJFeaturePairs.next();
                FeaturePair apolloFeaturePair = this.convertEnsJFeaturePairToApolloFeaturePair(ensJFeaturePair, "protein-protein-align", areQueryAndHitInverted);
                featureSet.addFeature(apolloFeaturePair, false);
                if (counter <= 0) {
                    this.setStableId(ensJFeaturePair.getHitDescription());
                    if (!areQueryAndHitInverted) {
                        this.setChromosome(ensJFeaturePair.getLocation().getSeqRegionName());
                        if (ensJFeaturePair.getLocation().getStart() < ensJFeaturePair.getLocation().getEnd()) {
                            this.setStart(Math.max(ensJFeaturePair.getLocation().getStart() - BUFFER_SIZE, 1));
                            this.setEnd(ensJFeaturePair.getLocation().getEnd() + BUFFER_SIZE);
                        } else {
                            this.setEnd(Math.max(ensJFeaturePair.getLocation().getStart() - BUFFER_SIZE, 1));
                            this.setStart(ensJFeaturePair.getLocation().getEnd() + BUFFER_SIZE);
                        }
                        this.setHitChromosome(null);
                        this.setHitStart(0);
                        this.setHitEnd(0);
                    } else {
                        this.setHitChromosome(ensJFeaturePair.getLocation().getSeqRegionName());
                        if (ensJFeaturePair.getLocation().getStart() < ensJFeaturePair.getLocation().getEnd()) {
                            this.setHitStart(Math.max(ensJFeaturePair.getLocation().getStart() - BUFFER_SIZE, 1));
                            this.setHitEnd(ensJFeaturePair.getLocation().getEnd() + BUFFER_SIZE);
                        } else {
                            this.setHitEnd(Math.max(ensJFeaturePair.getLocation().getStart() - BUFFER_SIZE, 1));
                            this.setHitStart(ensJFeaturePair.getLocation().getEnd() + BUFFER_SIZE);
                        }
                        this.setChromosome(null);
                        this.setStart(0);
                        this.setEnd(0);
                    }
                }
                ++counter;
            }
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
    }

    private void findLimitsOfAligns(List aligns, CurationSet curationSet) throws ApolloAdapterException {
        HashMap<String, Object[]> locationHash = new HashMap<String, Object[]>();
        AssemblyLocation currentAlignLimit = null;
        AssemblyLocation newAlignLimit = null;
        AssemblyLocation chosenAlignLimit = null;
        Integer currentAlignCount = null;
        int start = -1;
        int end = 0;
        String chromosome = null;
        org.ensembl.datamodel.FeaturePair align = null;
        Location location = null;
        for (int i = 0; i < aligns.size(); ++i) {
            align = (org.ensembl.datamodel.FeaturePair)aligns.get(i);
            location = align.getHitLocation();
            chromosome = location.getSeqRegionName();
            if (!locationHash.containsKey(chromosome)) {
                start = -1;
                end = 0;
                currentAlignCount = Integer.valueOf("0");
            } else {
                Object[] hashElement = (Object[])locationHash.get(chromosome);
                currentAlignLimit = (AssemblyLocation)hashElement[0];
                currentAlignCount = (Integer)hashElement[1];
                start = currentAlignLimit.getStart();
                end = currentAlignLimit.getEnd();
            }
            if (location.getStart() < start || start < 0) {
                start = location.getStart();
            }
            if (location.getEnd() > end) {
                end = location.getEnd();
            }
            newAlignLimit = new AssemblyLocation(chromosome, start, end, 0);
            locationHash.put(chromosome, new Object[]{newAlignLimit, new Integer(currentAlignCount + 1)});
        }
        if (locationHash.size() > 1) {
            chosenAlignLimit = this.getUserChoice(locationHash);
        } else if (locationHash.size() == 1) {
            chosenAlignLimit = (AssemblyLocation)((Object[])locationHash.values().iterator().next())[0];
        } else {
            throw new IllegalStateException("there are no align limits in a place where I'm expecting at least one!");
        }
        start = chosenAlignLimit.getStart();
        end = chosenAlignLimit.getEnd();
        if (start < end) {
            start = Math.max(start - BUFFER_SIZE, 1);
            end += BUFFER_SIZE;
        } else {
            start += BUFFER_SIZE;
            end = Math.max(end - BUFFER_SIZE, 1);
        }
        curationSet.setChromosome(chosenAlignLimit.getChromosome());
        curationSet.setStart(start);
        curationSet.setEnd(end);
    }

    public AssemblyLocation getUserChoice(HashMap locationHash) {
        Object[] userAlignChoice = AlignBlockChooser.getUserAlignChoice(locationHash);
        return (AssemblyLocation)userAlignChoice[0];
    }

    public void setStateInformation(Properties props) {
        String stableId;
        String logicalSpecies;
        this.stateInformation = props;
        int stableIdIndex = -1;
        this.setLoggingFile(props.getProperty("loggingFile"));
        this.setDriverConf(props);
        this.setStableId(null);
        this.setQueryStableId(null);
        this.setHitStableId(null);
        this.setChromosome(null);
        this.setCoordSystemString(null);
        this.setStart(-1);
        this.setEnd(-1);
        this.setHitChromosome(null);
        this.setHitCoordSystemString(null);
        this.setHitStart(-1);
        this.setHitEnd(-1);
        if (props.getProperty("chromosome") != null && props.getProperty("chromosome").trim().length() > 0) {
            this.setChromosome(props.getProperty("chromosome"));
        }
        if (props.getProperty("coordsystem") != null && props.getProperty("coordsystem").trim().length() > 0) {
            this.setCoordSystemString(props.getProperty("coordsystem"));
        }
        if (props.getProperty("start") != null && props.getProperty("start").trim().length() > 0) {
            this.setStart(Integer.valueOf(props.getProperty("start")));
        }
        if (props.getProperty("end") != null && props.getProperty("end").trim().length() > 0) {
            this.setEnd(Integer.valueOf(props.getProperty("end")));
        }
        if ((logicalSpecies = props.getProperty("querySpecies")) == null || logicalSpecies.trim().length() <= 0) {
            throw new NonFatalDataAdapterException(" ''querySpecies'' must be provided in the compara-adaptor's state information");
        }
        String actualSpecies = this.convertLogicalNameToSpeciesName(logicalSpecies);
        this.setQuerySpecies(actualSpecies);
        logicalSpecies = props.getProperty("hitSpecies");
        if (logicalSpecies == null || logicalSpecies.trim().length() <= 0) {
            throw new NonFatalDataAdapterException(" ''hitSpecies'' must be provided in the compara-adaptor's state information");
        }
        actualSpecies = this.convertLogicalNameToSpeciesName(logicalSpecies);
        this.setHitSpecies(actualSpecies);
        if (props.getProperty("hitChr") != null && props.getProperty("hitChr").trim().length() > 0) {
            this.setHitStart(Integer.valueOf(props.getProperty("hitStart")));
            this.setHitEnd(Integer.valueOf(props.getProperty("hitEnd")));
            this.setHitChromosome(props.getProperty("hitChr"));
            this.setHitCoordSystemString(props.getProperty("hitCoordSys"));
        }
        if ((stableId = props.getProperty("stableId")) != null && stableId.trim().length() >= "ID: ".length() && !stableId.trim().equals("null")) {
            this.setQueryStableId(stableId);
        }
        if ((stableId = props.getProperty("hitStableId")) != null && stableId.trim().length() >= "ID: ".length() && !stableId.trim().equals("null")) {
            this.setHitStableId(stableId);
        }
        this.setDnaAligns(props.getProperty("dnaAligns"));
        this.setHighConservationDnaAligns(props.getProperty("highConservationDnaAligns"));
        this.setProteinAligns(props.getProperty("proteinAligns"));
    }

    public String getQuerySpecies() {
        return this.querySpecies;
    }

    public String getHitSpecies() {
        return this.hitSpecies;
    }

    public int getHitStart() {
        return this.hitStart;
    }

    public int getHitEnd() {
        return this.hitEnd;
    }

    public String getHitChromosome() {
        return this.hitChromosome;
    }

    public String getHitCoordSystemString() {
        return this.hitCoordSystem;
    }

    public void setQuerySpecies(String newValue) {
        this.querySpecies = newValue;
    }

    public void setHitSpecies(String newValue) {
        this.hitSpecies = newValue;
    }

    public void setHitStart(int newValue) {
        this.hitStart = newValue;
    }

    public void setHitEnd(int newValue) {
        this.hitEnd = newValue;
    }

    public void setHitChromosome(String newValue) {
        this.hitChromosome = newValue;
    }

    public void setHitCoordSystemString(String newValue) {
        this.hitCoordSystem = newValue;
    }

    public void setStart(int newValue) {
        this.start = newValue;
    }

    public void setEnd(int newValue) {
        this.end = newValue;
    }

    public void setChromosome(String newValue) {
        this.chromosome = newValue;
    }

    public void setCoordSystemString(String newValue) {
        this.coordsystem = newValue;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public String getCoordSystemString() {
        return this.coordsystem;
    }

    public String convertLogicalNameToSpeciesName(String logicalName) {
        HashMap speciesNames = Config.getStyle("apollo.dataadapter.synteny.SyntenyAdapter").getSyntenySpeciesNames();
        Iterator logicalNames = speciesNames.keySet().iterator();
        String shortName = null;
        while (logicalNames.hasNext()) {
            int index;
            String longName = (String)logicalNames.next();
            shortName = longName.substring((index = longName.indexOf(".")) + 1);
            if (!shortName.equals(logicalName)) continue;
            return (String)speciesNames.get(longName);
        }
        throw new IllegalStateException("No logical species name matches the name input:" + shortName);
    }

    public List fetchAllAlignFeatures(String speciesName, String chromosome, int start, int end, HashMap sequenceHash) throws ApolloAdapterException {
        ComparaDriver comparaDriver = null;
        DnaDnaAlignFeatureAdaptor dnaDnaAlignFeatureAdaptor = null;
        Iterator featurePairs = null;
        SeqFeature feature = null;
        SeqFeature hitFeature = null;
        FeaturePair apolloPair = null;
        List fetchList = new ArrayList();
        ArrayList<FeatureSet> returnList = new ArrayList<FeatureSet>();
        FeatureSet set = null;
        try {
            comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)this.getStateInformation());
            dnaDnaAlignFeatureAdaptor = (DnaDnaAlignFeatureAdaptor)comparaDriver.getAdaptor("dna_dna_align_feature");
            String chr = new String(chromosome.substring(chromosome.indexOf(":") + 1));
            fetchList = dnaDnaAlignFeatureAdaptor.fetch(this.convertLogicalNameToSpeciesName(speciesName), (Location)new AssemblyLocation(chr, start, end, 0), null, "BLASTZ_NET");
            featurePairs = fetchList.iterator();
            while (featurePairs.hasNext()) {
                feature = new SeqFeature();
                hitFeature = new SeqFeature();
                DnaDnaAlignFeature pair = (DnaDnaAlignFeature)featurePairs.next();
                feature.setFeatureType(pair.getHitSpecies() + "-compara");
                feature.setName(pair.getHitSpecies() + " (" + pair.getHitLocation().getSeqRegionName() + ")");
                feature.setStart(pair.getLocation().getStart());
                feature.setEnd(pair.getLocation().getEnd());
                hitFeature.setFeatureType(pair.getHitSpecies() + "-compara");
                hitFeature.setName(pair.getHitSpecies() + " (" + pair.getHitLocation().getSeqRegionName() + ")");
                hitFeature.setStart(pair.getHitLocation().getStart());
                hitFeature.setEnd(pair.getHitLocation().getEnd());
                hitFeature.setRefSequence((SequenceI)sequenceHash.get(pair.getHitSpecies()));
                apolloPair = new FeaturePair(feature, hitFeature);
                set = new FeatureSet();
                set.addFeature(apolloPair);
                set.setFeatureType(pair.getHitSpecies() + "-compara");
                returnList.add(set);
            }
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
        return returnList;
    }

    private void setDnaAligns(String newValue) {
        this.dnaAligns = newValue;
    }

    private void setHighConservationDnaAligns(String newValue) {
        this.highConservationDnaAligns = newValue;
    }

    private void setProteinAligns(String newValue) {
        this.proteinAligns = newValue;
    }

    private String getDnaAligns() {
        return this.dnaAligns;
    }

    private String getHighConservationDnaAligns() {
        return this.highConservationDnaAligns;
    }

    private String getProteinAligns() {
        return this.proteinAligns;
    }

    public String getQueryStableId() {
        return this.queryStableId;
    }

    private void setQueryStableId(String id) {
        this.queryStableId = id;
    }

    public String getHitStableId() {
        return this.hitStableId;
    }

    private void setHitStableId(String id) {
        this.hitStableId = id;
    }

    private void setStableId(String id) {
        this.stableId = id;
    }

    public String getStableId() {
        return this.stableId;
    }
}

