/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.synteny.AbstractLinker;
import apollo.dataadapter.synteny.LinkerI;
import apollo.datamodel.SeqFeatureI;

class SelfLinker
extends AbstractLinker
implements LinkerI {
    SelfLinker(FeatureProperty featProp) {
        this.setFeatureProperty(featProp);
    }

    private boolean isLinkById() {
        return this.getFeatureProperty().getLinkType().isLinkById();
    }

    protected boolean featsAreLinked(SeqFeatureI feat1, SeqFeatureI feat2) {
        if (this.isLinkById()) {
            return feat1.getId().equals(feat2.getSyntenyLinkInfo());
        }
        return (feat1 = this.getHitFeat(feat1)).getStart() == feat2.getStart() && feat1.getEnd() == feat2.getEnd();
    }

    protected String getInputString(SeqFeatureI link) {
        if (Config.DEBUG) {
            System.out.println("SL getInStr isLink " + this.isLinkById() + " link info " + link.getSyntenyLinkInfo() + " link " + link);
        }
        if (this.isLinkById()) {
            return link.getSyntenyLinkInfo();
        }
        String in = null;
        SeqFeatureI hit = link.getHitFeature();
        int start = hit.getLow() - this.padLeft(link);
        int end = hit.getHigh() + this.padRight(link);
        in = hit.getName() + ":" + start + ":" + end;
        return in;
    }

    protected DataInputType getInputType() {
        if (this.isLinkById()) {
            return DataInputType.getDataTypeForSoType("mRNA");
        }
        return DataInputType.BASEPAIR_RANGE;
    }
}

