/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.FeatureProperty;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.synteny.AbstractLinker;
import apollo.dataadapter.synteny.LinkerI;
import apollo.dataadapter.synteny.ResultAnnotPairI;
import apollo.dataadapter.synteny.ResultPeptidePair;
import apollo.datamodel.CurationSet;
import apollo.datamodel.Link;
import apollo.datamodel.SeqFeatureI;
import apollo.util.FeatureList;
import apollo.util.SeqFeatureUtil;

class PeptideLinker
extends AbstractLinker
implements LinkerI {
    PeptideLinker(FeatureProperty featProp) {
        this.setFeatureProperty(featProp);
    }

    protected FeatureList getLinkFeatures(CurationSet speciesCurSet) {
        if (speciesCurSet.getOrganism() == null) {
            String m = "Organism is NULL for " + speciesCurSet.getName() + "\nCannot get " + "species links with no organism. Check your data.";
            throw new NullPointerException(m);
        }
        if (speciesCurSet.getOrganism().equals(this.getSpecies1())) {
            return super.getLinkFeatures(speciesCurSet);
        }
        return this.getTranscripts(speciesCurSet);
    }

    private FeatureList getTranscripts(CurationSet curSet) {
        return SeqFeatureUtil.getTranscripts(curSet);
    }

    protected boolean featsAreLinked(SeqFeatureI feat1, SeqFeatureI feat2) {
        return this.getResultAnnotPair(feat1, feat2).isLinked();
    }

    protected ResultAnnotPairI getResultAnnotPair(SeqFeatureI f1, SeqFeatureI f2) {
        return new ResultPeptidePair(f1, f2, this);
    }

    public Link createLink(SeqFeatureI feat1, SeqFeatureI feat2) {
        return this.getResultAnnotPair(feat1, feat2).createLink();
    }

    protected String getInputString(SeqFeatureI link) {
        if (link.canHaveChildren() && link.getFeatureAt(0) != null) {
            return link.getFeatureAt(0).getHitFeature().getName();
        }
        return link.getHitFeature().getName();
    }

    protected DataInputType getInputType() {
        return DataInputType.GENE;
    }

    protected void doPadding(ApolloDataAdapterI adap, SeqFeatureI linkFeat) {
        adap.setPadLeft(this.padLeft(linkFeat));
        adap.setPadRight(this.padRight(linkFeat));
    }
}

