/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.datamodel.Chromosome;
import apollo.datamodel.SyntenyRegion;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;

public class ChromosomeDrawer {
    private Chromosome chromosome;
    private Vector regions;
    private Hashtable colours;
    private boolean hit;
    private int xstart;
    private int ystart;
    private int width;
    private int height;

    public ChromosomeDrawer(Chromosome chromosome, Vector regions, Hashtable colours, boolean hit) {
        this.chromosome = chromosome;
        this.regions = regions;
        this.colours = colours;
        this.hit = hit;
    }

    public void draw(Graphics g, int x, int y, int width, int height) {
        this.xstart = x;
        this.ystart = y;
        this.width = width;
        this.height = height;
        int yoffset = 20;
        g.setColor(Color.black);
        g.setFont(new Font("Helvetica", 0, 8));
        String label = "Chr " + this.chromosome.getDisplayId();
        int strwidth = g.getFontMetrics().stringWidth(label);
        g.drawString(label, x + width / 2 - strwidth / 2, y + 15);
        int ypos = y + yoffset;
        int tmpheight = height - yoffset;
        g.drawArc(x, ypos + tmpheight / 40, width, tmpheight / 20, 0, 180);
        float frac = (float)(1.0 * (double)this.chromosome.getPlength() / (double)this.chromosome.getLength());
        int len = (int)(frac * 9.0f * (float)tmpheight / 10.0f);
        g.drawLine(x, ypos += tmpheight / 20, x, ypos + len);
        g.drawLine(x + width, ypos, x + width, ypos + len);
        ypos += len;
        frac = (float)(1.0 * (double)this.chromosome.getCentroLength() / (double)this.chromosome.getLength());
        len = (int)(frac * 9.0f * (float)tmpheight / 20.0f);
        g.drawLine(x, ypos, x + width / 2, ypos + len);
        g.drawLine(x + width, ypos, x + width / 2, ypos + len);
        g.drawLine(x, (ypos += len) + len, x + width / 2, ypos);
        g.drawLine(x + width, ypos + len, x + width / 2, ypos);
        ypos += len;
        frac = (float)(1.0 * (double)this.chromosome.getQlength() / (double)this.chromosome.getLength());
        len = (int)(frac * 9.0f * (float)tmpheight / 10.0f);
        g.drawLine(x, ypos, x, ypos + len);
        g.drawLine(x + width, ypos, x + width, ypos + len);
        g.drawArc(x, (ypos += len) - tmpheight / 40, width, tmpheight / 20, 180, 180);
        for (int i = 0; i < this.regions.size(); ++i) {
            float tmp2;
            float tmp1;
            SyntenyRegion reg = (SyntenyRegion)this.regions.elementAt(i);
            Color col = (Color)this.colours.get(reg.getChromosome2());
            if (this.hit) {
                tmp1 = (float)(1.0 * (double)reg.getStart2() / (double)reg.getChromosome2().getLength());
                tmp2 = (float)(1.0 * (double)(reg.getEnd2() - reg.getStart2() + 1) / (double)reg.getChromosome2().getLength());
            } else {
                tmp1 = (float)(1.0 * (double)reg.getStart1() / (double)this.chromosome.getLength());
                tmp2 = (float)(1.0 * (double)(reg.getEnd1() - reg.getStart1() + 1) / (double)this.chromosome.getLength());
            }
            ypos = y + yoffset + tmpheight / 20 + (int)(9.0f * tmp1 * (float)tmpheight / 10.0f);
            len = (int)(tmp2 * 9.0f * (float)tmpheight / 10.0f);
            g.setColor(col);
            g.fillRect(x + 1, ypos, width - 2, len);
            g.setColor(col.darker());
            g.drawRect(x + 1, ypos, width - 2, len);
        }
    }

    public int pixelToBase(int x, int y) {
        if (x >= this.xstart && x <= this.xstart + this.width) {
            int tmpystart = this.ystart + 20 + this.height / 20;
            int tmpyend = tmpystart + 9 * (this.height - 20) / 10;
            if (y >= tmpystart && y <= tmpyend) {
                int base = (int)(1.0 * (double)(y - tmpystart) * (double)this.chromosome.getLength() / (double)(tmpyend - tmpystart + 1));
                return base;
            }
        }
        return -1;
    }

    public SyntenyRegion pixelToRegion(int xpixel, int ypixel) {
        int base = this.pixelToBase(xpixel, ypixel);
        System.out.println(" Base " + base);
        if (base != -1) {
            for (int i = 0; i < this.regions.size(); ++i) {
                SyntenyRegion sr = (SyntenyRegion)this.regions.elementAt(i);
                if (this.hit) {
                    System.out.println("Region hit " + sr.getStart2() + " " + sr.getEnd2());
                    if (base < sr.getStart2() || base > sr.getEnd2()) continue;
                    return sr;
                }
                System.out.println("Region " + sr.getStart1() + " " + sr.getEnd1());
                if (base < sr.getStart1() || base > sr.getEnd1()) continue;
                return sr;
            }
        }
        return null;
    }

    public SyntenyRegion pixelBoxToRegion(int xpixel, int ypixel) {
        int base2;
        int base1 = this.pixelToBase(xpixel, ypixel - 1);
        if (base1 > (base2 = this.pixelToBase(xpixel, ypixel))) {
            int tmp = base1;
            base1 = base2;
            base2 = tmp;
        }
        if (base1 != -1 && base2 != -1) {
            for (int i = 0; i < this.regions.size(); ++i) {
                SyntenyRegion sr = (SyntenyRegion)this.regions.elementAt(i);
                if (!(this.hit ? base2 >= sr.getStart2() && base1 <= sr.getEnd2() : base2 >= sr.getStart1() && base1 <= sr.getEnd1())) continue;
                return sr;
            }
        }
        return null;
    }

    public Rectangle regionToRectangle(SyntenyRegion reg) {
        for (int i = 0; i < this.regions.size(); ++i) {
            float tmp2;
            float tmp1;
            SyntenyRegion sr = (SyntenyRegion)this.regions.elementAt(i);
            int tmpheight = this.height - 20;
            if (sr != reg) continue;
            if (this.hit) {
                tmp1 = (float)(1.0 * (double)reg.getStart2() / (double)reg.getChromosome2().getLength());
                tmp2 = (float)(1.0 * (double)(reg.getEnd2() - reg.getStart2() + 1) / (double)reg.getChromosome2().getLength());
            } else {
                tmp1 = (float)(1.0 * (double)reg.getStart1() / (double)this.chromosome.getLength());
                tmp2 = (float)(1.0 * (double)(reg.getEnd1() - reg.getStart1() + 1) / (double)this.chromosome.getLength());
            }
            int ypos = this.ystart + 20 + tmpheight / 20 + (int)(9.0f * tmp1 * (float)tmpheight / 10.0f);
            int len = (int)(tmp2 * 9.0f * (float)tmpheight / 10.0f);
            return new Rectangle(this.xstart + 1, ypos, this.xstart + this.width - 1, ypos + len);
        }
        return null;
    }
}

