/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.ensembl.datamodel.Location;

public class AlignBlockChooser
extends JDialog {
    private HashMap alignHash;
    private HashMap locationHash = new HashMap();
    private static Object[] userChoice;
    private JButton oKButton = new JButton("OK");
    private JLabel[] labels;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private ArrayList buttonList = new ArrayList();
    private JComponent parent;

    public AlignBlockChooser(HashMap alignHash) {
        super((Frame)null, true);
        this.alignHash = alignHash;
        this.initialiseGUI();
        this.pack();
        this.show();
    }

    private void initialiseGUI() {
        HashMap hash = this.getAlignHash();
        Object key = null;
        Object[] align = null;
        Location alignLimit = null;
        Integer alignCount = null;
        int counter = 0;
        AbstractButton radioButton = null;
        String buttonLabel = null;
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        OKButtonListener oKButtonListener = null;
        ArrayList entryArray = new ArrayList(hash.entrySet());
        contentPanel.add((Component)new JLabel("Select one of the following regions from the target-species to be loaded:"), GuiUtil.makeConstraintAt(0, counter, 1));
        Comparator alignCountOrder = new Comparator(){

            public int compare(Object o1, Object o2) {
                Object[] align2;
                int alignCount2;
                Object[] align1 = (Object[])((Map.Entry)o1).getValue();
                int alignCount1 = (Integer)align1[1];
                if (alignCount1 < (alignCount2 = ((Integer)(align2 = (Object[])((Map.Entry)o2).getValue())[1]).intValue())) {
                    return -1;
                }
                if (alignCount1 > alignCount2) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(entryArray, alignCountOrder);
        ++counter;
        Iterator entryIter = entryArray.iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            align = (Object[])entry.getValue();
            alignLimit = (Location)align[0];
            alignCount = (Integer)align[1];
            buttonLabel = alignLimit.getSeqRegionName() + "  :  " + alignLimit.getStart() + " - " + alignLimit.getEnd() + "  (" + alignCount.toString() + " aligns)";
            radioButton = new JRadioButton(buttonLabel);
            this.getLocationHash().put(radioButton, align);
            this.getButtonGroup().add(radioButton);
            contentPanel.add((Component)radioButton, GuiUtil.makeConstraintAt(0, counter, 1));
            ++counter;
        }
        radioButton.setSelected(true);
        oKButtonListener = new OKButtonListener();
        this.oKButton.addActionListener(oKButtonListener);
        GridBagConstraints constraint = GuiUtil.makeConstraintAt(0, counter, 1);
        constraint.anchor = 13;
        contentPanel.add((Component)this.oKButton, constraint);
        this.getContentPane().add((Component)contentPanel, "Center");
    }

    private HashMap getAlignHash() {
        return this.alignHash;
    }

    public static Object[] getUserAlignChoice(final HashMap alignHash) {
        Runnable showWindow = new Runnable(){

            public void run() {
                AlignBlockChooser chooser = new AlignBlockChooser(alignHash);
            }
        };
        try {
            SwingUtilities.invokeAndWait(showWindow);
        }
        catch (InvocationTargetException exception) {
            throw new IllegalStateException("SwingUtilities invokeAndWait has failed: this is a fatal problem: " + exception.getClass() + exception.getMessage());
        }
        catch (InterruptedException exception) {
            throw new IllegalStateException("SwingUtilities invokeAndWait has failed: this is a fatal problem" + exception.getClass() + exception.getMessage());
        }
        return AlignBlockChooser.getUserChoice();
    }

    private static void setUserChoice(Object[] choice) {
        userChoice = choice;
    }

    private static Object[] getUserChoice() {
        return userChoice;
    }

    private ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    private HashMap getLocationHash() {
        return this.locationHash;
    }

    public class OKButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            JRadioButton button = null;
            Enumeration<AbstractButton> buttons = AlignBlockChooser.this.getButtonGroup().getElements();
            while (buttons.hasMoreElements()) {
                button = (JRadioButton)buttons.nextElement();
                if (!button.isSelected()) continue;
                AlignBlockChooser.setUserChoice((Object[])AlignBlockChooser.this.getLocationHash().get(button));
            }
            AlignBlockChooser.this.dispose();
        }
    }
}

