/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.sample;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.sample.SampleAdapterGUI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.Sequence;
import apollo.datamodel.StrandedFeatureSet;
import java.util.Properties;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class SampleAdapter
extends AbstractApolloAdapter {
    public static final String NUMBER_OF_FEATURES = "NUMBER_OF_FEATURES";
    private Properties stateInformation;
    private int numberOfFeatures = 0;

    public SampleAdapter() {
        this.setName("Sample");
    }

    public String getType() {
        return "Sample Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        return new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA};
    }

    public DataAdapterUI getUI(IOOperation op) {
        return new SampleAdapterGUI(op);
    }

    public void setStateInformation(Properties properties) {
        this.stateInformation = properties;
        String numberString = properties.getProperty(NUMBER_OF_FEATURES);
        int number = 0;
        try {
            number = Integer.valueOf(numberString);
        }
        catch (NumberFormatException exception) {
            throw new NonFatalDataAdapterException("Number of properties - " + numberString + " - is not a valid integer");
        }
        this.setNumberOfFeatures(number);
    }

    public void init() {
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        int i;
        this.clearOldData();
        CurationSet curationSet = new CurationSet();
        StringBuffer buffer = new StringBuffer();
        int spacing = 0;
        Sequence sequence = null;
        FeatureSet featureSet = null;
        SeqFeature feature = null;
        StrandedFeatureSet results = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        StrandedFeatureSet annotations = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        int currentPosition = 0;
        int strand = 1;
        int featureSize = 0;
        int start = 0;
        int end = 0;
        for (i = 0; i < 1000000; ++i) {
            buffer.append("ACTGACTGAA");
        }
        sequence = new Sequence("sequence 1", buffer.toString());
        curationSet.setRefSequence(sequence);
        spacing = 2000000 / this.getNumberOfFeatures();
        featureSize = spacing / 10;
        for (i = 0; i < this.getNumberOfFeatures(); i += 2) {
            featureSet = new FeatureSet();
            start = currentPosition + featureSize;
            end = currentPosition + 2 * featureSize;
            feature = new SeqFeature(start, end, "sample_type", strand);
            feature.setName("Feature" + String.valueOf(start));
            featureSet.addFeature(feature);
            start = currentPosition + 3 * featureSize;
            end = currentPosition + 4 * featureSize;
            feature = new SeqFeature(start, end, "sample_type", strand);
            feature.setName("Feature" + String.valueOf(start));
            featureSet.addFeature(feature);
            featureSet.setStrand(strand);
            featureSet.setFeatureType("sample_group");
            featureSet.setRefSequence(sequence);
            results.addFeature(featureSet);
            currentPosition += spacing;
            strand = -1 * strand;
        }
        curationSet.setStart(1);
        curationSet.setEnd(1000000);
        curationSet.setChromosome("1");
        curationSet.setResults(results);
        curationSet.setAnnots(annotations);
        return curationSet;
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public Properties getStateInformation() {
        return this.stateInformation;
    }

    private void setNumberOfFeatures(int number) {
        this.numberOfFeatures = number;
    }

    private int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }
}

