/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.otter.parser;

import apollo.dataadapter.otter.parser.OtterContentHandler;
import org.xml.sax.Attributes;

public abstract class TagHandler {
    public static String LEFT = "<";
    public static String RIGHT = ">";
    public static String SLASH = "/";
    public static String OTTER = "otter";
    public static String SEQUENCE_SET = "sequence_set";
    public static String INDENT = "  ";
    public static String RETURN = "\n";
    public static String AUTHOR = "author";
    public static String AUTHOR_EMAIL = "author_email";
    public static String ASSEMBLY_TYPE = "assembly_type";
    public static String SEQUENCE_FRAGMENT = "sequence_fragment";
    public static String ID = "id";
    public static String KEYWORD = "keyword";
    public static String REMARK = "remark";
    public static String ACCESSION = "accession";
    public static String VERSION = "version";
    public static String CHROMOSOME = "chromosome";
    public static String ASSEMBLY_START = "assembly_start";
    public static String ASSEMBLY_END = "assembly_end";
    public static String FRAGMENT_ORI = "fragment_ori";
    public static String FRAGMENT_OFFSET = "fragment_offset";
    public static String LOCUS = "locus";
    public static String NAME = "name";
    public static String LOCUS_TYPE = "locus_type";
    public static String STABLE_ID = "stable_id";
    public static String SYNONYM = "synonym";
    public static String KNOWN = "known";
    public static String TRANSCRIPT = "transcript";
    public static String CDS_START_NOT_FOUND = "cds_start_not_found";
    public static String CDS_END_NOT_FOUND = "cds_end_not_found";
    public static String MRNA_START_NOT_FOUND = "mRNA_start_not_found";
    public static String MRNA_END_NOT_FOUND = "mRNA_end_not_found";
    public static String TRANSLATION_START = "translation_start";
    public static String TRANSLATION_END = "translation_end";
    public static String TRANSLATION_STABLE_ID = "translation_stable_id";
    public static String TRANSCRIPT_CLASS = "transcript_class";
    public static String EXON = "exon";
    public static String START = "start";
    public static String END = "end";
    public static String FRAME = "frame";
    public static String STRAND = "strand";
    public static String EVIDENCE = "evidence";
    public static String TYPE = "type";
    private StringBuffer characterBuffer;

    public void handleStartElement(OtterContentHandler theContentHandler, String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        theContentHandler.setMode(this);
        this.setCharacterBuffer(new StringBuffer());
    }

    public void handleEndElement(OtterContentHandler theContentHandler, String namespaceURI, String localName, String qualifiedName) {
        theContentHandler.closeMode();
    }

    public void handleCharacters(OtterContentHandler theContentHandler, char[] text, int start, int length) {
        String newText = new StringBuffer().append(text, start, length).toString();
        this.appendCharacterBuffer(newText);
    }

    public abstract String getFullName();

    public abstract String getLeafName();

    protected String getCharacters() {
        return this.getCharacterBuffer().toString();
    }

    protected StringBuffer getCharacterBuffer() {
        return this.characterBuffer;
    }

    protected void appendCharacterBuffer(String value) {
        this.getCharacterBuffer().append(value);
    }

    protected void setCharacterBuffer(StringBuffer newValue) {
        this.characterBuffer = newValue;
    }
}

