/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.otter;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.GFFAdapter;
import apollo.dataadapter.otter.OtterXMLAdapter;
import apollo.datamodel.CurationSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.gui.GenericFileAdapterGUI;
import apollo.seq.io.FastaFile;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bdgp.io.IOOperation;

public class OtterXMLAdapterGUI
extends GenericFileAdapterGUI {
    JButton seqButton;
    JComboBox seqFileList;
    Vector seqFilePaths;
    JButton gffButton;
    JComboBox gffFileList;
    Vector gffFilePaths;

    public OtterXMLAdapterGUI(IOOperation op) {
        super(op);
    }

    public void buildGUI() {
        super.buildGUI();
        this.seqFileList = new JComboBox();
        this.seqFilePaths = new Vector();
        this.seqButton = new JButton("Browse...");
        this.seqFileList.setEditable(true);
        this.seqFileList.setFont(this.getFont());
        this.seqButton.setFont(this.getFont());
        this.seqFileList.setAlignmentY(0.5f);
        this.seqButton.setAlignmentY(0.5f);
        this.seqFileList.setPreferredSize(new Dimension(this.getPathListWidth(), 10));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 0));
        panel3.add(this.seqFileList);
        panel3.add(this.seqButton);
        this.gffFileList = new JComboBox();
        this.gffFilePaths = new Vector();
        this.gffButton = new JButton("Browse...");
        this.gffFileList.setEditable(true);
        this.gffFileList.setFont(this.getFont());
        this.gffButton.setFont(this.getFont());
        this.gffFileList.setAlignmentY(0.5f);
        this.gffButton.setAlignmentY(0.5f);
        this.gffFileList.setPreferredSize(new Dimension(this.getPathListWidth(), 10));
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BoxLayout(panel4, 0));
        panel4.add(this.gffFileList);
        panel4.add(this.gffButton);
        this.getPanel().removeAll();
        this.getPanel().setLayout(new GridLayout(6, 1));
        this.getPanel().add(new JLabel("Otter XML file"));
        this.getPanel().add(this.panel2);
        this.getPanel().add(new JLabel("Sequence file"));
        this.getPanel().add(panel3);
        this.getPanel().add(new JLabel("GFF feature file"));
        this.getPanel().add(panel4);
        this.seqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OtterXMLAdapterGUI.this.browseFiles(OtterXMLAdapterGUI.this.seqFileList);
            }
        });
        this.gffButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OtterXMLAdapterGUI.this.browseFiles(OtterXMLAdapterGUI.this.gffFileList);
            }
        });
    }

    public String getSelectedSeqPath() {
        String selectedPath = (String)this.seqFileList.getSelectedItem();
        if (selectedPath == null || !selectedPath.equals(this.seqFileList.getEditor().getItem())) {
            selectedPath = (String)this.seqFileList.getEditor().getItem();
        }
        return selectedPath;
    }

    public String getSelectedGFFPath() {
        String selectedPath = (String)this.gffFileList.getSelectedItem();
        if (selectedPath == null || !selectedPath.equals(this.gffFileList.getEditor().getItem())) {
            selectedPath = (String)this.gffFileList.getEditor().getItem();
        }
        return selectedPath;
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            String gfffile;
            String file;
            FileInputStream inputStream;
            String fileName = this.getSelectedPath();
            try {
                inputStream = new FileInputStream(fileName);
            }
            catch (FileNotFoundException theException) {
                throw new ApolloAdapterException("File not found");
            }
            ((OtterXMLAdapter)this.driver).setInputStream(inputStream);
            CurationSet curationSet = ((ApolloDataAdapterI)this.driver).getCurationSet();
            if (this.getSelectedSeqPath() != null && (file = this.getSelectedSeqPath()) != null) {
                try {
                    FastaFile ff = new FastaFile(file, "File", curationSet);
                }
                catch (IOException e) {
                    System.out.println("IOException caught reading sequence file " + file + " " + e);
                }
            }
            if ((gfffile = this.getSelectedGFFPath()) != null) {
                GFFAdapter gff = new GFFAdapter();
                gff.setFilename(gfffile);
                try {
                    StrandedFeatureSetI fset = gff.getAnalysisRegion();
                    curationSet.setResults(fset);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return curationSet;
        }
        if (this.op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            CurationSet set = (CurationSet)values;
            String fileName = this.getSelectedPath();
            String seqfile = this.getSelectedSeqPath();
            String gfffile = this.getSelectedGFFPath();
            OtterXMLAdapter oa = (OtterXMLAdapter)this.driver;
            oa.setSequenceFilename(seqfile);
            oa.setGFFFilename(gfffile);
            try {
                FileOutputStream outputStream = new FileOutputStream(fileName);
                oa.setOutputStream(outputStream);
                oa.commitChanges((CurationSet)values);
            }
            catch (IOException theException) {
                throw new ApolloAdapterException("problems creating output file", theException);
            }
            return null;
        }
        return null;
    }
}

