/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.otter;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.GFFAdapter;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.otter.OtterXMLAdapterGUI;
import apollo.dataadapter.otter.parser.OtterContentHandler;
import apollo.dataadapter.otter.parser.OtterXMLRenderingVisitor;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OtterXMLAdapter
extends AbstractApolloAdapter {
    private String seqfile;
    private String gfffile;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE, ApolloDataAdapterI.OP_WRITE_DATA};
    private InputStream inputStream;
    private OutputStream outputStream;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream newValue) {
        this.inputStream = newValue;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream newValue) {
        this.outputStream = newValue;
    }

    public String getName() {
        return "Otter XML ";
    }

    public String getType() {
        return "Otter XML Annotations";
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public String getInput() {
        return null;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        return new OtterXMLAdapterGUI(op);
    }

    public void setRegion(String region) throws ApolloAdapterException {
        throw new NotImplementedException("Not yet implemented");
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        return props;
    }

    public void setStateInformation(Properties props) {
    }

    private StrandedFeatureSetI getAnnotations() {
        SeqFeatureI theSet = null;
        StrandedFeatureSet returnSet = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        CurationSet curationSet = new CurationSet();
        int low = -1;
        int high = -1;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            OtterContentHandler handler = new OtterContentHandler();
            handler.setCurationSet(curationSet);
            InputSource theFileReader = new InputSource(this.getInputStream());
            parser.setContentHandler(handler);
            parser.parse(theFileReader);
            Iterator returnedObjects = handler.getReturnedObjects().iterator();
            Object set = null;
            while (returnedObjects.hasNext()) {
                Object returnedObject = returnedObjects.next();
                theSet = (AnnotatedFeatureI)returnedObject;
            }
            if (theSet != null) {
                Iterator featureIterator = theSet.getFeatures().iterator();
                while (featureIterator.hasNext()) {
                    SeqFeatureI theResultFeature = (SeqFeatureI)featureIterator.next();
                    if (low > theResultFeature.getLow() || low < 0) {
                        low = theResultFeature.getLow();
                    }
                    if (high < theResultFeature.getHigh() || high < 0) {
                        high = theResultFeature.getHigh();
                    }
                    returnSet.addFeature(theResultFeature);
                }
                returnSet.setLow(low);
                returnSet.setHigh(high);
            }
        }
        catch (IOException theException) {
            theException.printStackTrace();
        }
        catch (SAXException theException) {
            theException.printStackTrace();
        }
        return returnSet;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curationSet = new CurationSet();
        StrandedFeatureSetI annotations = this.getAnnotations();
        curationSet.setAnnots(annotations);
        curationSet.setResults(new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet()));
        curationSet.setLow(annotations.getLow());
        curationSet.setHigh(annotations.getHigh());
        return curationSet;
    }

    private void setSequence(SeqFeatureI sf, CurationSet curationSet) {
        throw new NotImplementedException("Not yet implemented");
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        throw new NotImplementedException("Not yet implemented");
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        BufferedOutputStream buffer = new BufferedOutputStream(this.getOutputStream());
        OutputStreamWriter writer = new OutputStreamWriter(buffer);
        OtterXMLRenderingVisitor visitor = new OtterXMLRenderingVisitor();
        StrandedFeatureSetI theSet = curationSet.getAnnots();
        theSet.accept(visitor);
        String outputString = visitor.getReturnBuffer().toString();
        try {
            writer.write("<otter>\n");
            writer.write("<sequenceset>\n");
            writer.write(outputString);
            writer.write("</sequenceset>\n");
            writer.write("</otter>\n");
            writer.flush();
        }
        catch (IOException theException) {
            throw new ApolloAdapterException("Error writing annotations", theException);
        }
        GFFAdapter gffadapter = new GFFAdapter();
        gffadapter.setSequenceFilename(this.seqfile);
        gffadapter.setFilename(this.gfffile);
        try {
            gffadapter.commitChanges(curationSet);
            gffadapter.saveSequence(curationSet.getRefSequence());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setSequenceFilename(String seqfile) {
        this.seqfile = seqfile;
    }

    public void setGFFFilename(String gfffile) {
        this.gfffile = gfffile;
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void init() {
    }
}

