/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.mysql;

import apollo.dataadapter.mysql.Database;
import apollo.dataadapter.mysql.MySQLDatabase;
import apollo.dataadapter.mysql.Table;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MySQLInstance {
    Hashtable databases = new Hashtable();
    String host;
    String user;
    String pass;
    String name = "mysql";
    int port = 3306;
    String url;
    Connection conn;

    public MySQLInstance(String host, String user, String pass, int port) {
        this.setHost(host);
        this.setUser(user);
        this.setPass(pass);
        this.setPort(port);
        this.connect();
    }

    public MySQLInstance(String host, String user, String pass) {
        this(host, user, pass, 3306);
    }

    public Vector fetchAllDatabases() {
        try {
            String query = "show databases";
            ResultSet rs = this.query(query);
            while (rs.next()) {
                String db = rs.getString(1);
                Database dbobj = new Database(this.getHost(), db, this.getUser(), this.getPass(), this.getPort());
                MySQLDatabase database = new MySQLDatabase(dbobj);
                this.databases.put(db, database);
            }
        }
        catch (SQLException e) {
            System.out.println("SQLException " + e);
        }
        Vector dbs = new Vector();
        Enumeration en = this.databases.elements();
        while (en.hasMoreElements()) {
            dbs.addElement(en.nextElement());
        }
        return dbs;
    }

    public MySQLDatabase fetchDatabaseByName(String name) {
        if (this.databases.get(name) != null) {
            MySQLDatabase db = (MySQLDatabase)this.databases.get(name);
            return db;
        }
        MySQLDatabase database = new MySQLDatabase(this.getHost(), name, this.getUser(), this.getPass(), this.getPort());
        this.databases.put(name, database);
        return database;
    }

    public Vector getDatabaseNames() {
        Vector<String> names = new Vector<String>();
        try {
            String query = "show databases";
            ResultSet rs = this.query(query);
            while (rs.next()) {
                String db = rs.getString(1);
                names.addElement(db);
            }
        }
        catch (SQLException e) {
            System.out.println("SQLException " + e);
        }
        return names;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public int getPort() {
        return this.port;
    }

    public String getURL() {
        return this.url;
    }

    public ResultSet query(String query) {
        try {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            return rs;
        }
        catch (SQLException e) {
            System.out.println("SQL Exception " + e);
            return null;
        }
    }

    public Connection connect() {
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Exception: " + e.toString());
        }
        catch (InstantiationException e) {
            System.out.println("Exception: " + e.toString());
        }
        catch (IllegalAccessException e) {
            System.out.println("Exception: " + e.toString());
        }
        try {
            this.url = "jdbc:mysql://" + this.host + ":" + this.getPort() + "/" + this.name;
            System.err.println("Connecting to Database URL = " + this.url + " " + this.user + " " + this.pass);
            this.conn = DriverManager.getConnection(this.url, this.user, this.pass);
            System.err.println("Connected to database");
        }
        catch (SQLException e) {
            System.out.println("SQLException " + e);
        }
        return null;
    }

    public static void main(String[] args) {
        MySQLInstance mysql = new MySQLInstance(args[0], args[1], args[2], Integer.parseInt(args[3]));
        try {
            Vector dbs = mysql.fetchAllDatabases();
            for (int i = 0; i < dbs.size(); ++i) {
                MySQLDatabase db = (MySQLDatabase)dbs.elementAt(i);
                System.out.println("Got database");
                Vector tables = db.getTables();
                for (int j = 0; j < tables.size(); ++j) {
                    Table table = (Table)tables.elementAt(j);
                    System.out.println("  - Table " + table.getName());
                    Vector names = db.getFieldNamesByTable(table);
                    for (int k = 0; k < names.size(); ++k) {
                        System.out.println("    - " + names.elementAt(k));
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: fetching details for database " + args[3] + " " + e);
        }
    }
}

