/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.mysql;

import apollo.dataadapter.mysql.Database;
import apollo.dataadapter.mysql.Table;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class MySQLDatabase
extends Database {
    Connection conn;

    public MySQLDatabase(String host, String name, String user, String pass, int port) {
        super(host, name, user, pass, port);
        this.connect();
    }

    public MySQLDatabase(String host, String name, String user, String pass) {
        super(host, name, user, pass, 3306);
        this.connect();
    }

    public MySQLDatabase(Database d) {
        this(d.getHost(), d.getName(), d.getUser(), d.getPass());
    }

    public Connection connect() {
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Exception: " + e.toString());
        }
        catch (InstantiationException e) {
            System.out.println("Exception: " + e.toString());
        }
        catch (IllegalAccessException e) {
            System.out.println("Exception: " + e.toString());
        }
        try {
            String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.name;
            System.err.println("Connecting to Database URL = " + url + " " + this.user + " " + this.pass);
            this.conn = DriverManager.getConnection(url, this.user, this.pass);
        }
        catch (SQLException e) {
            System.out.println("SQLException " + e);
        }
        return null;
    }

    public Vector getTables() {
        String query = "show tables";
        ResultSet rs = this.query(query);
        try {
            while (rs.next()) {
                System.out.println(" - " + rs.getString(1));
                String tablestr = rs.getString(1);
                Table table = new Table(tablestr);
                this.addTable(table);
            }
            return this.tables;
        }
        catch (SQLException e) {
            System.out.println("SQLException e" + e);
            return null;
        }
    }

    public Vector getFieldNamesByTable(Table t) {
        String query = "describe " + t.getName();
        ResultSet rs = this.query(query);
        try {
            while (rs.next()) {
                String name = rs.getString(1);
                t.addFieldName(name);
            }
            return t.getFieldNames();
        }
        catch (SQLException e) {
            System.out.println("SQLException e" + e);
            return null;
        }
    }

    public ResultSet query(String query) {
        try {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            return rs;
        }
        catch (SQLException e) {
            System.out.println("SQL Exception " + e);
            return null;
        }
    }
}

