/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.dataadapter.genbank.FeatureValidatorI;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;

public class tRNAValidator
implements FeatureValidatorI {
    private static final int tRNA_MAX = 86;
    private static final int tRNA_MIN = 70;

    public String validateFeature(FeatureSetI feature, CurationSet curation, String prefix, String suffix) {
        AnnotatedFeature gene;
        StringBuffer buf = new StringBuffer();
        AnnotatedFeature annotatedFeature = gene = feature instanceof AnnotatedFeature ? (AnnotatedFeature)feature : null;
        if (gene == null) {
            return "";
        }
        if (gene.getFeatureType().equalsIgnoreCase("trna")) {
            String aa = gene.getProperty("aminoacid");
            if (aa == null || aa.equals("")) {
                buf.append(prefix + " missing amino acid" + suffix);
            }
            if (!gene.getName().startsWith("CR")) {
                buf.append(prefix + " is incorrectly named " + suffix);
            }
            if (gene.length() > 86) {
                buf.append(prefix + " is > " + 86 + " bases, it is " + gene.length() + " bases " + suffix);
            }
            if (gene.length() < 70) {
                buf.append(prefix + " is < " + 70 + " bases, it is " + gene.length() + " bases " + suffix);
            }
        }
        return buf.toString();
    }
}

