/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

public class GenbankFormatter {
    private static final int LINE_LENGTH = 80;
    private static final int SPACE_TOLERANCE = 20;
    private static final int HEAD_INDENT = 12;
    private static final String SUBHEAD_PAD = "  ";
    private static final int FEATURE_INDENT = 21;
    private static final String SUBFEATURE_PAD = "     ";
    private static final int SEQ_LINE_LENGTH = 60;

    private static String indentString(String str, int indent) {
        if (str == null) {
            str = "";
        }
        StringBuffer b = new StringBuffer(str);
        for (int i = str.length(); i < indent; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    private static String getInsert(int indent) {
        StringBuffer b = new StringBuffer("\n");
        for (int i = 0; i < indent; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    public static String padBetweenWithSpaces(String str1, String str2, int width) {
        if (str1.length() + str2.length() >= width) {
            return str1 + str2;
        }
        StringBuffer b = new StringBuffer(str1);
        for (int i = 0; i < width - (str1.length() + str2.length()); ++i) {
            b.append(" ");
        }
        b.append(str2);
        return b.toString();
    }

    public static String breakSingle(String str) {
        return GenbankFormatter.breakSingle(str, 21);
    }

    public static String breakSingle(String str, int indent) {
        if (str.length() <= 80) {
            return str;
        }
        StringBuffer b = new StringBuffer(str);
        String insert = GenbankFormatter.getInsert(indent);
        int idx = GenbankFormatter.getSplitIndex(b, 0);
        do {
            b.insert(idx, insert);
        } while ((idx = GenbankFormatter.getSplitIndex(b, idx)) < b.length());
        return b.toString();
    }

    private static int getSplitIndex(StringBuffer b, int last) {
        int idx = 0;
        int nextSpace = -1;
        try {
            nextSpace = b.substring(1, last + 80).lastIndexOf(32);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (nextSpace > last + 80 - 20 && nextSpace < last + 80) {
            idx = nextSpace + 1;
            b.deleteCharAt(idx);
        } else {
            idx = last == 0 ? 80 : last + 80 + 1;
        }
        return idx;
    }

    public static String getHeading(String heading) {
        return GenbankFormatter.indentString(heading, 12);
    }

    public static String getSubHeading(String sub) {
        return GenbankFormatter.indentString(SUBHEAD_PAD + (sub == null ? "" : sub), 12);
    }

    public static String getFeature(String feature) {
        return GenbankFormatter.indentString(feature, 21);
    }

    public static String getFeatureHeading(String sub, String info) {
        return GenbankFormatter.indentString(SUBFEATURE_PAD + sub, 21) + info;
    }

    public static String getFeatureItem(String name, String value) {
        if (value == null) {
            value = "";
        }
        return GenbankFormatter.breakSingle(GenbankFormatter.indentString("", 21) + "/" + name + "=\"" + value + "\"", 21);
    }

    public static String formatSequence(String residues) {
        if (residues == null || residues.equals("")) {
            return "";
        }
        try {
            StringBuffer b = new StringBuffer();
            int LABEL_LENGTH = 9;
            int numRes = residues.length();
            for (int resNum = 1; resNum < numRes; resNum += 60) {
                String label = resNum + "";
                while (label.length() < LABEL_LENGTH) {
                    label = " " + label;
                }
                String line = label;
                for (int i = resNum - 1; i < resNum + 60 - 1 && i < numRes; i += 10) {
                    line = line + " " + residues.substring(i, Math.min(i + 10, numRes));
                }
                if (resNum + 60 < numRes) {
                    b.append(line + "\n");
                    continue;
                }
                b.append(line);
            }
            return b.toString();
        }
        catch (Exception e) {
            System.out.println("formatSequence: caught error " + e);
            return "";
        }
    }
}

