/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.flygamexml;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.debug.DisplayTool;
import apollo.dataadapter.flygamexml.FlyGAMEAdapterGUI;
import apollo.dataadapter.gamexml.GAMEAdapter;
import apollo.datamodel.CurationSet;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class FlyGAMEAdapter
extends GAMEAdapter {
    private String NAME_LABEL_FOR_WRITING = "Fly annotations (GAME XML format)";
    private String NAME_LABEL_FOR_READING = "Fly annotations (GAME XML format)";

    public FlyGAMEAdapter() {
        this.setName(this.NAME_LABEL_FOR_READING);
    }

    public FlyGAMEAdapter(DataInputType inputType, String input) {
        this.setInputType(inputType);
        this.setInput(input);
    }

    public FlyGAMEAdapter(DataInputType inputType, String input, boolean noGUI) {
        this.NO_GUI = noGUI;
        this.setInputType(inputType);
        this.setInput(input);
    }

    public void init() {
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (!super.operationIsSupported(op)) {
            return null;
        }
        Object ui = super.getCachedUI(op);
        if (ui == null) {
            ui = new FlyGAMEAdapterGUI(op);
            super.cacheUI(op, (DataAdapterUI)ui);
        }
        if (op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            super.setName(this.NAME_LABEL_FOR_WRITING);
        } else {
            super.setName(this.NAME_LABEL_FOR_READING);
        }
        return ui;
    }

    public static void main(String[] args) throws ApolloAdapterException {
        DEBUG = true;
        String url = "http://www.fruitfly.org/annot/gbunits/xml/AE003650.xml";
        FlyGAMEAdapter databoy = new FlyGAMEAdapter(DataInputType.URL, url);
        FlyGAMEAdapter.testAdapter(databoy);
        databoy = new FlyGAMEAdapter(DataInputType.GENE, "cact");
        FlyGAMEAdapter.testAdapter(databoy);
        databoy = new FlyGAMEAdapter(DataInputType.CYTOLOGY, "34A");
        FlyGAMEAdapter.testAdapter(databoy);
        databoy = new FlyGAMEAdapter(DataInputType.SCAFFOLD, "AE003490");
        FlyGAMEAdapter.testAdapter(databoy);
        String file = "/users/mgibson/cvs/apollo/dev/sanger/data/josh";
        if (args.length > 0) {
            file = args[0];
        }
        databoy = new FlyGAMEAdapter(DataInputType.FILE, file);
        FlyGAMEAdapter.testAdapter(databoy);
        String seq = "actggcgtgctgtgttattagtgatgatgtcgcaatcgtgaatcgatgcatgcacacatcgtgtgtgtggtctgcgaatatggcattccgtaaagtgccgcgcgtatgtcgcgcgattatgatgtatgctgctgatgtagctgtgatattctaatgagtgctgatcgtgatgtagtcgtagtctagctagctagtcgatcgtagctacgtagctagctagcttgtgtgcgcgcgctg";
        databoy = new FlyGAMEAdapter(DataInputType.SEQUENCE, seq);
        FlyGAMEAdapter.testAdapter(databoy);
    }

    private static void testAdapter(FlyGAMEAdapter databoy) {
        try {
            CurationSet curation = databoy.getCurationSet();
            DisplayTool.showFeatureSet(curation.getResults());
        }
        catch (ApolloAdapterException ex) {
            System.err.println("No data to read");
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }
}

