/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.flychadoxml;

import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.GuiTabPanel;
import apollo.dataadapter.flychadoxml.LoaderPanel;
import apollo.gui.ChromosomeField;
import apollo.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LocationChadoPanel
extends LoaderPanel {
    private static final String label = "Location";
    private ChromosomeField chrField;
    private JTextField startField;
    private JTextField endField;

    public LocationChadoPanel(Color bkgnd) {
        super(label, label, DataInputType.BASEPAIR_RANGE, bkgnd);
    }

    protected void buildGUI() {
        JLabel chromLabel = GuiUtil.makeJLabelWithFont(" Chromosome ");
        Vector chroms = null;
        if (this.getAdapterStyle() != null) {
            chroms = this.getAdapterStyle().getChromosomes();
        }
        this.chrField = new ChromosomeField(chroms);
        JLabel startLabel = GuiUtil.makeJLabelWithFont(" Start ");
        this.startField = GuiUtil.makeNumericTextField();
        JLabel endLabel = GuiUtil.makeJLabelWithFont(" End ");
        this.endField = GuiUtil.makeNumericTextField();
        JPanel chromStartEndPanel = new JPanel(new GridBagLayout());
        chromStartEndPanel.setBackground(this.getBackground());
        GuiTabPanel.ApolloGridBagConstraints cons = this.newConstraints();
        cons.ipadx = 10;
        chromStartEndPanel.add((Component)chromLabel, cons);
        chromStartEndPanel.add((Component)this.chrField.getComponent(), cons.nextColumn());
        chromStartEndPanel.add((Component)startLabel, cons.nextColumn());
        chromStartEndPanel.add((Component)this.startField, cons.nextColumn());
        chromStartEndPanel.add((Component)endLabel, cons.nextColumn());
        chromStartEndPanel.add((Component)this.endField, cons.nextColumn());
        JPanel locPanel = new JPanel(new GridBagLayout());
        locPanel.setBackground(this.getBackground());
        GuiTabPanel.ApolloGridBagConstraints gbc = this.newConstraints();
        gbc.ipady = 10;
        if (this.showDatabaseList()) {
            locPanel.add((Component)super.getDatabasePanel(), gbc);
        }
        locPanel.add((Component)chromStartEndPanel, this.nextRow(gbc));
        this.getPanel().add(locPanel);
    }

    public String getCurrentInput() {
        return this.getChrom() + ":" + this.getStart() + "-" + this.getEnd();
    }

    private String getChrom() {
        return this.chrField.getChromosome();
    }

    private String getStart() {
        return this.startField.getText();
    }

    private String getEnd() {
        return this.endField.getText();
    }

    public DataInput getDataInput() {
        return new DataInput(this.getChrom(), this.getStart(), this.getEnd());
    }

    protected void setEditorsHistory(Vector history) {
    }
}

