/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.flychadoxml;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.FileTabPanel;
import apollo.dataadapter.GuiTabPanel;
import apollo.dataadapter.flychadoxml.FlyChadoXmlAdapter;
import apollo.dataadapter.flychadoxml.LoaderPanel;
import apollo.dataadapter.flychadoxml.LocationChadoPanel;
import apollo.gui.ProxyDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class FlyChadoXmlAdapterGUI
extends AbstractDataAdapterUI {
    private IOOperation ioOperation;
    private FlyChadoXmlAdapter driver;
    private static int tabbedIndex = 0;
    private JTabbedPane tabbedPane;
    private static final String indexPropString = "ChadoXmlTabIndex";
    private GuiTabPanel[] panels;
    private int FileTabIndex = 0;
    private Color grayBackgroundColor = new Color(220, 220, 220);
    private JCheckBox saveAnnots = new JCheckBox("Save annotations");
    private JCheckBox saveResults = new JCheckBox("Save evidence (computational results)");

    FlyChadoXmlAdapterGUI() {
    }

    public FlyChadoXmlAdapterGUI(IOOperation op) {
        this.ioOperation = op;
        this.setBackground(this.grayBackgroundColor);
        this.initPanels();
        this.buildGUI();
    }

    public void setDataAdapter(DataAdapter driver) {
        if (driver instanceof FlyChadoXmlAdapter) {
            this.driver = (FlyChadoXmlAdapter)driver;
        } else {
            System.err.println("FlyChadoXmlAdapterGUI not compatible with adapter " + driver + " ( class " + driver.getClass().getName() + ")");
        }
    }

    private void initPanels() {
        LoaderPanel gene = new LoaderPanel("Gene", "Gene name or synonym", DataInputType.GENE, "cact", this.grayBackgroundColor);
        LoaderPanel cyt = new LoaderPanel("Cytology", "Cytological location", DataInputType.CYTOLOGY, "34A", this.grayBackgroundColor);
        FileTabPanel file = new FileTabPanel((Component)((Object)this), this.grayBackgroundColor);
        LocationChadoPanel loc = new LocationChadoPanel(this.grayBackgroundColor);
        this.panels = new GuiTabPanel[]{file, gene, loc, cyt};
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        if (this.getDataInput() == null || !this.getDataInput().hasInput()) {
            throw new ApolloAdapterException("null input");
        }
        this.driver.setDataInput(this.getDataInput());
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            this.driver.setDatabase(this.getCurrentPanel().getDatabase());
            return this.driver.getCurationSet();
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
            this.driver.setDatabase(this.getCurrentPanel().getDatabase());
            return this.driver.addToCurationSet();
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            this.driver.commitChanges(values, this.saveAnnots.isSelected(), this.saveResults.isSelected());
            return null;
        }
        return null;
    }

    private DataInput getDataInput() throws ApolloAdapterException {
        try {
            return this.getCurrentPanel().getDataInput();
        }
        catch (RuntimeException e) {
            throw new ApolloAdapterException(e.getMessage());
        }
    }

    private DataInputType getCurrentInputType() {
        return this.getCurrentPanel().getInputType();
    }

    private String getCurrentInput() {
        return this.getCurrentPanel().getCurrentInput();
    }

    public GuiTabPanel getCurrentPanel() {
        return this.panels[this.tabbedPane.getSelectedIndex()];
    }

    private void addCheckboxes(FileTabPanel filepanel) {
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BorderLayout());
        checkboxPanel.add("North", this.saveAnnots);
        checkboxPanel.add("South", this.saveResults);
        filepanel.add("South", checkboxPanel);
        this.saveAnnots.setEnabled(true);
        this.saveAnnots.setSelected(true);
        this.saveResults.setEnabled(true);
        this.saveResults.setSelected(true);
    }

    public void setProperties(Properties in) {
        if (in == null) {
            return;
        }
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].retrieveHistoryFromProperties(in);
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            this.chooseTab("file");
            FileTabPanel filepanel = (FileTabPanel)this.panels[this.FileTabIndex];
            this.addCheckboxes(filepanel);
        } else {
            String indexStr = in.getProperty(indexPropString);
            if (indexStr != null) {
                tabbedIndex = Integer.parseInt(indexStr);
                this.tabbedPane.setSelectedIndex(tabbedIndex);
            }
            for (int i = 0; i < this.panels.length; ++i) {
                this.tabbedPane.setEnabledAt(i, true);
            }
        }
    }

    public Properties getProperties() {
        this.getCurrentPanel().addSelectedToHistory();
        Properties out = new Properties();
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].putHistoryInProperties(out);
        }
        out.put(indexPropString, "" + tabbedIndex);
        return out;
    }

    private void buildGUI() {
        this.tabbedPane = new JTabbedPane();
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].insertIntoTabbedPane(this.tabbedPane, i);
        }
        this.tabbedPane.setSelectedIndex(tabbedIndex);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                tabbedIndex = FlyChadoXmlAdapterGUI.this.tabbedPane.getSelectedIndex();
            }
        });
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.tabbedPane);
        JButton proxyButton = new JButton("Proxy settings...");
        proxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyDialog pd = new ProxyDialog(null);
                pd.setVisible(true);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalStrut(280));
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalStrut(150));
        buttonPanel.add(proxyButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.add(buttonPanel);
    }

    public void chooseTab(String which) {
        if (which.equalsIgnoreCase("file")) {
            tabbedIndex = this.FileTabIndex;
            for (int i = 0; i < this.panels.length; ++i) {
                if (i == this.FileTabIndex) {
                    this.tabbedPane.setEnabledAt(i, true);
                    continue;
                }
                this.tabbedPane.setEnabledAt(i, false);
            }
            this.tabbedPane.setSelectedIndex(this.FileTabIndex);
        }
    }
}

