/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.flychadoxml;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.Region;
import apollo.dataadapter.chadoxml.ChadoXmlAdapter;
import apollo.dataadapter.flychadoxml.FlyChadoXmlAdapterGUI;
import apollo.datamodel.CurationSet;
import apollo.util.IOUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;

public class FlyChadoXmlAdapter
extends ChadoXmlAdapter {
    public FlyChadoXmlAdapter() {
        this.setName("Chado XML file (FlyBase v1.0, no macros)");
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (!super.operationIsSupported(op)) {
            return null;
        }
        Object ui = super.getCachedUI(op);
        if (ui == null) {
            ui = new FlyChadoXmlAdapterGUI(op);
            super.cacheUI(op, (DataAdapterUI)ui);
        }
        return ui;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Finding data..."));
            InputStream xml_stream = this.chadoXmlInputStream(this.getDataInput());
            return this.getCurationSetFromInputStream(xml_stream);
        }
        catch (ApolloAdapterException dae) {
            System.err.println("Error while parsing " + this.getInput());
            throw dae;
        }
        catch (Exception ex2) {
            System.err.println("Error while parsing " + this.getInput());
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
    }

    private InputStream chadoXmlInputStream(DataInput dataInput) throws ApolloAdapterException {
        InputStream stream = null;
        DataInputType type = dataInput.getType();
        String input = dataInput.getInputString();
        if (type == DataInputType.FILE) {
            stream = this.getStreamFromFile(input);
        } else if (type == DataInputType.URL) {
            URL url = this.makeUrlFromString(input);
            if (url == null) {
                String message = "Couldn't find URL for " + this.getInput();
                System.err.println(message);
                throw new ApolloAdapterException(message);
            }
            System.err.println("Trying to open URL " + input + " to read Chado XML...");
            stream = IOUtil.getStreamFromUrl(url, "URL " + input + " not found");
            this.setOriginalFilename(url.toString());
        } else if (type == DataInputType.GENE) {
            String err = "Can't connect to URL for request gene=" + input + "--server not responding.";
            String notfound = "Gene " + input + " not found (or server not responding)";
            System.err.println("Looking up Chado XML data for gene " + input + "...");
            stream = IOUtil.getStreamFromUrl(this.getURLForGene(input), err, notfound);
            this.setOriginalFilename(this.getURLForGene(input).toString());
        } else if (type == DataInputType.CYTOLOGY) {
            String err = "Can't connect to URL for band=" + input + "--server not responding.";
            String notfound = "Cytological band " + input + " not found (or server not responding)";
            System.err.println("Looking up Chado XML data for band " + input + "...");
            stream = IOUtil.getStreamFromUrl(this.getURLForBand(input), err, notfound);
            this.setOriginalFilename(this.getURLForBand(input).toString());
        } else if (type == DataInputType.BASEPAIR_RANGE) {
            String err = "Can't connect to URL for requested region--server not responding.";
            String notfound = "Region " + input + " not found (or server not responding)";
            System.err.println("Looking up Chado XML data for range " + dataInput.getRegion() + "...");
            stream = IOUtil.getStreamFromUrl(this.getURLForRange(dataInput.getRegion()), err, notfound);
            this.setOriginalFilename(this.getURLForRange(dataInput.getRegion()).toString());
        }
        return stream;
    }

    private InputStream getStreamFromFile(String filename) throws ApolloAdapterException {
        BufferedReader in;
        FileInputStream stream = null;
        String path = IOUtil.findFile(filename, false);
        try {
            System.out.println("Trying to open ChadoXML file " + path + " for reading");
            stream = new FileInputStream(path);
            this.setOriginalFilename(path);
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("could not open ChadoXML file " + filename + " for reading.");
        }
        try {
            in = new BufferedReader(new FileReader(path));
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("Error: could not open ChadoXML file " + path + " for reading.");
        }
        if (!this.appearsToBeChadoXML(filename, in)) {
            throw new ApolloAdapterException("File " + filename + "\ndoes not appear to contain chadoXML--couldn't find <chado> line.\n");
        }
        return stream;
    }

    private Style getFlyChadoStyle() {
        return Config.getStyle(this.getClass().getName());
    }

    public URL makeUrlFromString(String urlString) {
        URL url;
        urlString = this.fillInDatabase(urlString);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            System.err.println("caught exception creating URL " + urlString);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        return url;
    }

    public String fillInDatabase(String urlString) {
        String dbField = this.getFlyChadoStyle().getDatabaseURLField();
        if (dbField == null) {
            return urlString;
        }
        int index = urlString.indexOf(dbField);
        if (index == -1) {
            return urlString;
        }
        StringBuffer sb = new StringBuffer(urlString);
        String dbname = this.getDatabase();
        if (dbname.indexOf("ot available") > 0) {
            return "";
        }
        if (dbname.indexOf(" ") > 0) {
            dbname = dbname.substring(0, dbname.indexOf(" "));
        }
        sb.replace(index, index + dbField.length(), dbname);
        return sb.toString();
    }

    public String getDatabase() {
        if (super.getDatabase() != null) {
            return super.getDatabase();
        }
        return this.getFlyChadoStyle().getDefaultDatabase();
    }

    public URL getURLForScaffold(String scaffold) {
        String query = this.getFlyChadoStyle().getScaffoldUrl() + scaffold;
        URL url = this.makeUrlFromString(query);
        String msg = "Searching for location of scaffold " + scaffold + "...";
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(2.0), msg));
        return url;
    }

    public URL getURLForGene(String gene) {
        String query = this.getFlyChadoStyle().getGeneUrl() + gene;
        URL url = this.makeUrlFromString(query);
        String msg = "Searching for scaffold containing gene " + gene + "...";
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(2.0), msg));
        return url;
    }

    public URL getURLForBand(String band) {
        String query = this.getFlyChadoStyle().getBandUrl() + band;
        URL url = this.makeUrlFromString(query);
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(2.0), "Searching for scaffold closest to cytological location " + band + "--please be patient..."));
        return url;
    }

    public URL getURLForRange(Region region) {
        String rangeForUrl = region.getColonDashString();
        String query = this.getFlyChadoStyle().getRangeUrl() + rangeForUrl;
        URL url = this.makeUrlFromString(query);
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Searching for scaffold that overlaps region " + rangeForUrl + "..."));
        return url;
    }
}

