/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SourceChooserWithHistory
extends JPanel {
    private JComboBox sourceHistoryList;
    private Vector sourceHistory = new Vector();
    private ItemListener historyListAction;
    private List listenerList = new ArrayList();

    public SourceChooserWithHistory() {
        this.sourceHistoryList = new JComboBox();
        this.sourceHistoryList.setPreferredSize(new Dimension(200, 15));
        this.sourceHistoryList.setEditable(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.sourceHistoryList, GuiUtil.makeConstraintAt(0, 0, 1));
    }

    public SourceChooserWithHistory(Vector sourceHistory) {
        this();
        DefaultComboBoxModel model = new DefaultComboBoxModel(sourceHistory);
        this.sourceHistoryList.setModel(model);
        this.historyListAction = new HistoryAction();
        this.sourceHistoryList.addItemListener(this.historyListAction);
    }

    private ItemListener getHistoryListAction() {
        return this.historyListAction;
    }

    public JComboBox getSourceHistoryList() {
        return this.sourceHistoryList;
    }

    public void setSourceHistoryList(JComboBox sourceHistoryList) {
        this.sourceHistoryList = sourceHistoryList;
    }

    public Vector getSourceHistory() {
        return this.sourceHistory;
    }

    public void setSourceHistory(Vector sourceHistory) {
        this.sourceHistory = sourceHistory;
        this.getSourceHistoryList().removeItemListener(this.getHistoryListAction());
        this.getSourceHistoryList().setModel(new DefaultComboBoxModel(sourceHistory));
        this.getSourceHistoryList().addItemListener(this.getHistoryListAction());
    }

    public String getSelectedSource() {
        return (String)this.getSourceHistoryList().getSelectedItem();
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame("test");
        Vector<String> history = new Vector<String>();
        history.add("One");
        history.add("Two");
        testFrame.getContentPane().add((Component)new SourceChooserWithHistory(history), "Center");
        testFrame.pack();
        testFrame.show();
    }

    private List getListenerList() {
        return this.listenerList;
    }

    public void addItemListener(ItemListener listener) {
        this.getListenerList().add(listener);
    }

    private class HistoryAction
    implements ItemListener {
        private HistoryAction() {
        }

        public void itemStateChanged(ItemEvent event) {
            Iterator listeners = SourceChooserWithHistory.this.getListenerList().iterator();
            while (listeners.hasNext()) {
                ((ItemListener)listeners.next()).itemStateChanged(event);
            }
        }
    }
}

