/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.Region;
import apollo.dataadapter.ensj19.EnsJAdapter;
import apollo.util.IOUtil;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.helpers.Loader;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;
import org.ensembl19.driver.ConfigurationException;

public abstract class EnsJAdapterGUI
extends AbstractDataAdapterUI {
    protected static final String DEFAULT_CONFIG_FILE = "conf/ensj_defaults.conf";
    private static final int MAX_HISTORY_LENGTH = 20;
    private static String HELP_URL = "http://www.ebi.ac.uk/~craig/ensembl-java/apollo-plugin.html";
    private JRadioButton chrButton;
    private JComboBox chrStartEndList;
    private JComboBox chrDropdown;
    private JTextField startTextBox;
    private JTextField endTextBox;
    private ActionListener chrAction;
    private Vector chrStartEndVector;
    private JRadioButton cloneFragmentButton;
    private JComboBox cloneFragmentList;
    private JTextField cloneFragmentTextBox;
    private ActionListener cloneFragmentAction;
    private Vector cloneFragmentHistory;
    private JRadioButton stableIDButton;
    private JComboBox stableIDList;
    private Vector stableIDHistory;
    private DataTypeButton[] dataTypeButtons;
    private Box cloneFragmentPanel;
    private DataAdapter adapter;
    private IOOperation op;
    private Properties initialSettings;
    private String loggingFile;
    public JPanel locationPanel;
    private boolean chromosomeListInitialised = false;

    public EnsJAdapterGUI(IOOperation op) {
        this.op = op;
        this.chrButton = new JRadioButton("Chromosome", false);
        this.cloneFragmentList = new JComboBox();
        this.stableIDList = new JComboBox();
        this.chrDropdown = new JComboBox();
        this.chrDropdown.addPopupMenuListener(new ChromosomeDropdownPopupListener());
        this.startTextBox = new JTextField();
        this.endTextBox = new JTextField();
        this.chrStartEndList = new JComboBox();
        this.stableIDButton = new JRadioButton("Stable ID", false);
        this.chrAction = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnsJAdapterGUI.this.initialiseChromosomeDropdown();
                Region loc = new Region((String)EnsJAdapterGUI.this.chrStartEndList.getSelectedItem());
                if (loc != null) {
                    EnsJAdapterGUI.this.chrDropdown.setSelectedItem(loc.getChromosome());
                    EnsJAdapterGUI.this.startTextBox.setText(loc.getStart() + "");
                    EnsJAdapterGUI.this.endTextBox.setText(loc.getEnd() + "");
                    EnsJAdapterGUI.this.chrButton.setSelected(true);
                }
            }
        };
        this.cloneFragmentButton = new JRadioButton("Clone Fragment", false);
        this.cloneFragmentTextBox = new JTextField();
        this.cloneFragmentAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EnsJAdapterGUI.this.cloneFragmentTextBox.setText((String)EnsJAdapterGUI.this.cloneFragmentList.getSelectedItem());
                EnsJAdapterGUI.this.cloneFragmentButton.setSelected(true);
            }
        };
        this.setDataTypeButtons(new DataTypeButton[]{new DataTypeButton("Genes", "gene", "include.Gene"), new DataTypeButton("Dna Protein Alignments", "dna_protein_alignment", "include.DnaProteinAlignment"), new DataTypeButton("Dna Dna Alignments", "dna_dna_alignment", "include.DnaDnaAlignment"), new DataTypeButton("Features (simple)", "feature", "include.Feature"), new DataTypeButton("Simple Peptides", "simple_peptide_feature", "include.SimplePeptideFeature"), new DataTypeButton("Repeats", "RepeatMask", "include.RepeatFeature"), new DataTypeButton("PredictionTranscripts", "prediction_transcript", "include.PredictionTranscript"), new DataTypeButton("Variations (e.g. SNPs)", "variation", "include.Variation")});
        this.buildGUI();
    }

    protected Vector getPrefixedProperties(Properties settings, String prefix, boolean convertValueToFilePath) {
        Vector<String> returnVector = new Vector<String>();
        int i = 0;
        while (true) {
            String filepath;
            String value = settings.getProperty(prefix + i);
            ++i;
            if (value == null) break;
            if (convertValueToFilePath && (filepath = this.findFile(value)) != null && new File(filepath).exists()) {
                value = filepath.toString();
            }
            returnVector.addElement(value);
        }
        return returnVector;
    }

    protected void putPrefixedProperties(Properties settings, Vector values, String prefix) {
        int size = values.size();
        if (size > 20) {
            size = 20;
        }
        for (int i = 0; i < size; ++i) {
            settings.put(prefix + i, (String)values.elementAt(i));
        }
    }

    private void addDefault(Vector v, String filename) {
        String filepath = this.findFile(filename);
        if (filepath != null) {
            v.add(filepath);
        }
    }

    public void setProperties(Properties input) {
        String filepath = this.findFile(DEFAULT_CONFIG_FILE);
        this.initialSettings = input;
        this.setCloneFragmentHistory(this.getPrefixedProperties(this.initialSettings, "cloneFragmentHistory", false));
        this.cloneFragmentList.removeActionListener(this.cloneFragmentAction);
        this.cloneFragmentList.setModel(new DefaultComboBoxModel(this.getCloneFragmentHistory()));
        this.cloneFragmentList.addActionListener(this.cloneFragmentAction);
        this.setStableIDHistory(this.getPrefixedProperties(this.initialSettings, "stableIDHistory", false));
        this.stableIDList.setModel(new DefaultComboBoxModel(this.getStableIDHistory()));
        this.chrStartEndList.removeActionListener(this.chrAction);
        this.chrStartEndVector = this.getPrefixedProperties(this.initialSettings, "chrStartEndHistory", false);
        this.chrStartEndList.setModel(new DefaultComboBoxModel(this.chrStartEndVector));
        this.chrStartEndList.addActionListener(this.chrAction);
        this.setLoggingFile(this.initialSettings.getProperty("loggingFile"));
        for (int i = 0; i < this.getDataTypeButtons().length; ++i) {
            boolean selected = EnsJAdapterGUI.stringToBoolean(this.initialSettings.getProperty(this.getDataTypeButtons()[i].propertyName));
            this.getDataTypeButtons()[i].setSelected(selected);
        }
    }

    public Properties getProperties() {
        this.chrStartEndList.removeActionListener(this.chrAction);
        Properties out = new Properties();
        if (this.chrButton.isSelected()) {
            String selectedLocation = "Chr " + (String)this.chrDropdown.getSelectedItem() + " " + this.startTextBox.getText() + " " + this.endTextBox.getText();
            this.makeFirstElement(selectedLocation, this.chrStartEndVector);
            this.putPrefixedProperties(out, this.chrStartEndVector, "chrStartEndHistory");
        } else if (this.cloneFragmentButton.isSelected()) {
            String selectedCloneFragmentName = this.cloneFragmentTextBox.getText();
            this.makeFirstElement(selectedCloneFragmentName, this.getCloneFragmentHistory());
            this.putPrefixedProperties(out, this.getCloneFragmentHistory(), "cloneFragmentHistory");
        } else if (this.stableIDButton.isSelected()) {
            String selectedStableID = (String)this.stableIDList.getSelectedItem();
            this.makeFirstElement(selectedStableID, this.getStableIDHistory());
            this.putPrefixedProperties(out, this.getStableIDHistory(), "stableIDHistory");
        }
        this.chrStartEndList.addActionListener(this.chrAction);
        for (int i = 0; i < this.getDataTypeButtons().length; ++i) {
            out.put(this.getDataTypeButtons()[i].propertyName, EnsJAdapterGUI.booleanToString(this.getDataTypeButtons()[i].isSelected()));
        }
        return out;
    }

    static String booleanToString(boolean v) {
        if (v) {
            return "true";
        }
        return "false";
    }

    static boolean stringToBoolean(String v) {
        return v != null && v.equals("true");
    }

    private void makeFirstElement(Object element, Vector vector) {
        if (vector.contains(element)) {
            vector.removeElement(element);
            vector.insertElementAt(element, 0);
        } else {
            vector.insertElementAt(element, 0);
        }
    }

    protected TitledBorder createBorder(String label) {
        TitledBorder border = new TitledBorder(new LineBorder(Color.gray), label);
        border.setTitleColor(Color.black);
        return border;
    }

    protected JPanel buildLocationPanel() {
        int height = 20;
        int space = 10;
        Dimension labelSize = new Dimension(150, 20);
        Dimension textBoxSize = new Dimension(100, 20);
        Dimension dropDownListSize = new Dimension(150, 20);
        this.locationPanel = new JPanel();
        Box stableIDPanel = Box.createHorizontalBox();
        Box chromosomePanel = Box.createHorizontalBox();
        Box chrInputRow = Box.createHorizontalBox();
        Box chromosomeInputOptionsPanel = Box.createVerticalBox();
        Box cfOptionsPanel = Box.createVerticalBox();
        this.cloneFragmentPanel = Box.createHorizontalBox();
        this.locationPanel.setLayout(new BoxLayout(this.locationPanel, 1));
        this.locationPanel.setBorder(this.createBorder("Region"));
        this.locationPanel.add(stableIDPanel);
        this.locationPanel.add(Box.createVerticalStrut(10));
        this.locationPanel.add(chromosomePanel);
        this.locationPanel.add(Box.createVerticalStrut(10));
        this.locationPanel.add(this.cloneFragmentPanel);
        this.stableIDButton.setPreferredSize(labelSize);
        this.stableIDList.setMinimumSize(dropDownListSize);
        stableIDPanel.add(this.stableIDButton);
        stableIDPanel.add(Box.createHorizontalStrut(10));
        stableIDPanel.add(this.stableIDList);
        this.stableIDList.setEditable(true);
        this.stableIDList.getEditor().getEditorComponent().addFocusListener(new FocusSelectsButton(this.stableIDButton));
        this.chrButton.setPreferredSize(labelSize);
        chromosomePanel.add(this.chrButton);
        chromosomePanel.add(Box.createHorizontalStrut(10));
        chromosomePanel.add(chromosomeInputOptionsPanel);
        chromosomeInputOptionsPanel.add(chrInputRow);
        chromosomeInputOptionsPanel.add(Box.createVerticalStrut(5));
        chromosomeInputOptionsPanel.add(this.chrStartEndList);
        Box cfInputRow = Box.createHorizontalBox();
        this.cloneFragmentButton.setPreferredSize(labelSize);
        this.cloneFragmentPanel.add(this.cloneFragmentButton);
        this.cloneFragmentPanel.add(Box.createHorizontalStrut(10));
        this.cloneFragmentTextBox.setPreferredSize(dropDownListSize);
        this.cloneFragmentTextBox.addFocusListener(new FocusSelectsButton(this.cloneFragmentButton));
        cfInputRow.add(new JLabel("Accession", 4));
        cfInputRow.add(this.cloneFragmentTextBox);
        cfInputRow.add(Box.createHorizontalGlue());
        cfOptionsPanel.add(cfInputRow);
        cfOptionsPanel.add(Box.createVerticalStrut(5));
        cfOptionsPanel.add(this.cloneFragmentList);
        this.cloneFragmentPanel.add(cfOptionsPanel);
        KeyAdapter selectCloneFragmentListener = new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                EnsJAdapterGUI.this.cloneFragmentButton.setSelected(true);
            }
        };
        this.cloneFragmentTextBox.addKeyListener(selectCloneFragmentListener);
        this.cloneFragmentList.addActionListener(this.cloneFragmentAction);
        this.chrDropdown.setPreferredSize(dropDownListSize);
        this.chrDropdown.setMaximumSize(dropDownListSize);
        this.chrDropdown.setEditable(false);
        chrInputRow.add(new JLabel("Chr", 4));
        chrInputRow.add(this.chrDropdown);
        chrInputRow.add(Box.createHorizontalStrut(10));
        this.startTextBox.setPreferredSize(textBoxSize);
        this.startTextBox.setMaximumSize(textBoxSize);
        this.startTextBox.setEditable(true);
        chrInputRow.add(new JLabel("Start", 4));
        chrInputRow.add(this.startTextBox);
        chrInputRow.add(Box.createHorizontalStrut(10));
        this.endTextBox.setPreferredSize(textBoxSize);
        this.endTextBox.setMaximumSize(textBoxSize);
        this.endTextBox.setEditable(true);
        chrInputRow.add(new JLabel("End", 4));
        chrInputRow.add(this.endTextBox);
        this.chrStartEndList.setPreferredSize(dropDownListSize);
        this.chrStartEndList.setEditable(false);
        FocusSelectsButton chrListener = new FocusSelectsButton(this.chrButton);
        this.chrDropdown.addFocusListener(chrListener);
        this.startTextBox.addFocusListener(chrListener);
        this.endTextBox.addFocusListener(chrListener);
        this.cloneFragmentList.setPreferredSize(dropDownListSize);
        this.cloneFragmentList.setEditable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.stableIDButton);
        group.add(this.chrButton);
        group.add(this.cloneFragmentButton);
        KeyAdapter selectChromosomeListener = new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                EnsJAdapterGUI.this.chrButton.setSelected(true);
            }
        };
        this.chrDropdown.addKeyListener(selectChromosomeListener);
        this.startTextBox.addKeyListener(selectChromosomeListener);
        this.endTextBox.addKeyListener(selectChromosomeListener);
        this.chrStartEndList.addActionListener(this.chrAction);
        return this.locationPanel;
    }

    protected JPanel buildIncludePanel() {
        JPanel all = new JPanel();
        all.setBorder(this.createBorder("Tracks"));
        all.setLayout(new BoxLayout(all, 0));
        Box includePanel = Box.createVerticalBox();
        for (int i = 0; i < this.getDataTypeButtons().length; ++i) {
            includePanel.add(this.getDataTypeButtons()[i]);
        }
        all.add(includePanel);
        all.add(Box.createHorizontalGlue());
        return all;
    }

    private JPanel buildHelpPanel() {
        EnsJAdapterGUI parent = this;
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2, 0, 0));
        ActionListener l = new ActionListener((Component)((Object)parent)){
            private final /* synthetic */ Component val$parent;
            {
                this.val$parent = val$parent;
            }

            public void actionPerformed(ActionEvent evt) {
                String[] browsers = new String[]{Config.getBrowserProgram(), "netscape", "iexplore"};
                boolean browserOpen = false;
                for (int i = 0; !browserOpen && i < browsers.length; ++i) {
                    try {
                        String browser = browsers[i];
                        if (browser != null) {
                            BrowserLauncher.setBrowser((String)browser);
                        }
                        BrowserLauncher.openURL((String)HELP_URL);
                        JOptionPane.showMessageDialog(this.val$parent, "Opened help page.");
                        browserOpen = true;
                        continue;
                    }
                    catch (IOException err) {
                        // empty catch block
                    }
                }
                if (!browserOpen) {
                    JOptionPane.showMessageDialog(this.val$parent, "Failed to open help page in a browser. Is a browser installed?", "Warning", 2);
                }
            }
        };
        JButton b = new JButton("Help");
        b.addActionListener(l);
        p.add(b);
        return p;
    }

    protected void buildGUI() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.buildHelpPanel());
        this.add(this.buildLocationPanel());
        this.add(this.buildIncludePanel());
    }

    public void setDataAdapter(DataAdapter adapter) {
        this.adapter = adapter;
    }

    public DataAdapter getDataAdapter() {
        return this.adapter;
    }

    public String getSelectedStableID() {
        return "STABLE_ID " + (String)this.stableIDList.getModel().getSelectedItem();
    }

    protected String getSelectedCloneFragment() {
        return this.cloneFragmentTextBox.getText();
    }

    public String getSelectedChrStartEnd() {
        String chromosome = this.getSelectedChr();
        String start = this.getSelectedStart();
        String end = this.getSelectedEnd();
        if (chromosome == null || chromosome.trim().length() <= 0 || chromosome.equals("null")) {
            return null;
        }
        if (start == null || start.trim().length() <= 0 || start.equals("null")) {
            return null;
        }
        if (end == null || end.trim().length() <= 0 || end.equals("null")) {
            return null;
        }
        String output = new String("Chr " + chromosome + " " + start + " " + end);
        if (output.trim().equals("Chr")) {
            return null;
        }
        return output;
    }

    public String getSelectedChr() {
        String selectedChr = (String)this.chrDropdown.getSelectedItem();
        return selectedChr;
    }

    public String getSelectedStart() {
        String selectedStart = this.startTextBox.getText();
        return selectedStart;
    }

    public String getSelectedEnd() {
        String selectedEnd = this.endTextBox.getText();
        return selectedEnd;
    }

    public JComboBox getChrDropdown() {
        return this.chrDropdown;
    }

    public JTextField getStartTextBox() {
        return this.startTextBox;
    }

    public JTextField getEndTextBox() {
        return this.endTextBox;
    }

    protected String findFile(String file) {
        String filepath = null;
        if (file != null && file.trim().length() > 0 && (filepath = IOUtil.findFile(file)) == null) {
            try {
                URL url = Loader.getResource((String)file);
                if (url != null) {
                    filepath = url.getFile();
                    System.err.println("using filepath = " + filepath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return filepath;
    }

    protected ActionListener getChrAction() {
        return this.chrAction;
    }

    public JComboBox getChrStartEndList() {
        return this.chrStartEndList;
    }

    public JRadioButton getChrButton() {
        return this.chrButton;
    }

    protected JRadioButton getCloneFragmentButton() {
        return this.cloneFragmentButton;
    }

    public JRadioButton getStableIdButton() {
        return this.stableIDButton;
    }

    protected DataTypeButton[] getDataTypeButtons() {
        return this.dataTypeButtons;
    }

    protected void setDataTypeButtons(DataTypeButton[] buttons) {
        this.dataTypeButtons = buttons;
    }

    protected Properties getInitialSettings() {
        return this.initialSettings;
    }

    public Box getCloneFragmentPanel() {
        return this.cloneFragmentPanel;
    }

    public JPanel getLocationPanel() {
        return this.locationPanel;
    }

    public void setSelectedStableId(String stableId) {
        this.getStableIDHistory().insertElementAt(stableId, 0);
        this.stableIDList.setModel(new DefaultComboBoxModel(this.getStableIDHistory()));
        this.stableIDList.setSelectedIndex(0);
    }

    public IOOperation getOperation() {
        return this.op;
    }

    public void setLoggingFile(String newValue) {
        this.loggingFile = newValue;
    }

    public String getLoggingFile() {
        return this.loggingFile;
    }

    private Vector getCloneFragmentHistory() {
        return this.cloneFragmentHistory;
    }

    private void setCloneFragmentHistory(Vector history) {
        this.cloneFragmentHistory = history;
    }

    private Vector getStableIDHistory() {
        return this.stableIDHistory;
    }

    private void setStableIDHistory(Vector history) {
        this.stableIDHistory = history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseChromosomeDropdown() {
        EnsJAdapter adapter = (EnsJAdapter)this.getDataAdapter();
        Vector<String> listOfChromosomes = new Vector<String>();
        Properties stateInformation = null;
        if (this.isChromosomeListInitialised()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.chrButton.setSelected(true);
            stateInformation = this.createStateInformation();
            stateInformation.setProperty("region", "Chr dummy 1 2");
            adapter.setStateInformation(stateInformation);
            listOfChromosomes = new Vector(adapter.getChromosomes());
            listOfChromosomes.add(0, "");
            this.getChrDropdown().setModel(new DefaultComboBoxModel(listOfChromosomes));
            this.getStartTextBox().setText("");
            this.getEndTextBox().setText("");
            this.setChromosomeListInitialised(true);
        }
        catch (DataAdapterException exception) {
            JOptionPane.showMessageDialog(null, "I can't load a list of chromosomes for your current DB configuration: " + exception.getMessage());
        }
        catch (ConfigurationException exception) {
            JOptionPane.showMessageDialog(null, "I can't load a list of chromosomes for your current DB configuration" + exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void setChromosomeListInitialised(boolean value) {
        this.chromosomeListInitialised = value;
    }

    protected boolean isChromosomeListInitialised() {
        return this.chromosomeListInitialised;
    }

    public abstract Properties createStateInformation() throws ApolloAdapterException;

    private final class FocusSelectsButton
    extends FocusAdapter {
        private AbstractButton button;

        FocusSelectsButton(AbstractButton button) {
            this.button = button;
        }

        public void focusGained(FocusEvent ke) {
            this.button.setSelected(true);
        }
    }

    public class ChromosomeDropdownPopupListener
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent event) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            EnsJAdapterGUI.this.initialiseChromosomeDropdown();
        }
    }

    public class DataSourceChangeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            EnsJAdapterGUI.this.getChrDropdown().setModel(new DefaultComboBoxModel());
            EnsJAdapterGUI.this.setChromosomeListInitialised(false);
        }
    }

    public class DataTypeButton
    extends JCheckBox {
        public String propertyName;
        public String adaptorName;

        public DataTypeButton(String label, String adaptorName, String propertyName) {
            super(label);
            this.propertyName = propertyName;
            this.adaptorName = adaptorName;
        }
    }
}

