/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.FeatureSetBuilder;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.Region;
import apollo.dataadapter.StateInformation;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.seq.PFetchSequence;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterRegistry;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.widget.DataAdapterChooser;
import org.bdgp.util.ProgressEvent;
import org.ensembl19.datamodel.Accessioned;
import org.ensembl19.datamodel.AssemblyElement;
import org.ensembl19.datamodel.AssemblyLocation;
import org.ensembl19.datamodel.CloneFragment;
import org.ensembl19.datamodel.CloneFragmentLocation;
import org.ensembl19.datamodel.DnaDnaAlignment;
import org.ensembl19.datamodel.DnaProteinAlignment;
import org.ensembl19.datamodel.Feature;
import org.ensembl19.datamodel.Gene;
import org.ensembl19.datamodel.InvalidLocationException;
import org.ensembl19.datamodel.LinearLocation;
import org.ensembl19.datamodel.Location;
import org.ensembl19.datamodel.PredictionExon;
import org.ensembl19.datamodel.PredictionTranscript;
import org.ensembl19.datamodel.Query;
import org.ensembl19.datamodel.RepeatConsensus;
import org.ensembl19.datamodel.RepeatFeature;
import org.ensembl19.datamodel.SimplePeptideFeature;
import org.ensembl19.datamodel.Transcript;
import org.ensembl19.datamodel.Translation;
import org.ensembl19.datamodel.Variation;
import org.ensembl19.driver.AdaptorException;
import org.ensembl19.driver.CloneFragmentAdaptor;
import org.ensembl19.driver.ConfigurationException;
import org.ensembl19.driver.DnaDnaAlignmentAdaptor;
import org.ensembl19.driver.DnaProteinAlignmentAdaptor;
import org.ensembl19.driver.Driver;
import org.ensembl19.driver.DriverManager;
import org.ensembl19.driver.ExonAdaptor;
import org.ensembl19.driver.GeneAdaptor;
import org.ensembl19.driver.LocationConverter;
import org.ensembl19.driver.LoggingManager;
import org.ensembl19.driver.PredictionTranscriptAdaptor;
import org.ensembl19.driver.RepeatFeatureAdaptor;
import org.ensembl19.driver.SimpleFeatureAdaptor;
import org.ensembl19.driver.SimplePeptideAdaptor;
import org.ensembl19.driver.TranscriptAdaptor;
import org.ensembl19.driver.TranslationAdaptor;
import org.ensembl19.driver.VariationAdaptor;
import org.ensembl19.driver.plugin.standard.MySQLLocationConverter;
import org.ensembl19.util.PropertiesUtil;
import org.ensembl19.util.SimpleTimer;

public abstract class EnsJAdapter
extends AbstractApolloAdapter {
    public long tstart;
    public long tend;
    private static final Logger logger = Logger.getLogger((String)(class$apollo$dataadapter$ensj19$EnsJAdapter == null ? (class$apollo$dataadapter$ensj19$EnsJAdapter = EnsJAdapter.class$("apollo.dataadapter.ensj19.EnsJAdapter")) : class$apollo$dataadapter$ensj19$EnsJAdapter).getName());
    public static final String STABLE_ID_PREFIX = "STABLE_ID ";
    static final int ASSEMBLY_LOCATION_MODE = 0;
    static final int CLONE_FRAGMENT_MODE = 1;
    static final int STABLE_ID_MODE = 2;
    private boolean initialisedDriver = false;
    private Location location = null;
    private String region;
    private int mode;
    private SequenceI genomeSeq = null;
    private Driver driver = null;
    private GeneAdaptor geneAdaptor = null;
    private CloneFragmentAdaptor cloneFragmentAdaptor = null;
    private LocationConverter locationConverter = null;
    private DnaProteinAlignmentAdaptor dnaProteinAlignmentAdaptor = null;
    private DnaDnaAlignmentAdaptor dnaDnaAlignmentAdaptor = null;
    private SimplePeptideAdaptor simplePeptideAdaptor = null;
    private SimpleFeatureAdaptor simpleFeatureAdaptor = null;
    private RepeatFeatureAdaptor repeatFeatureAdaptor = null;
    private PredictionTranscriptAdaptor predictionTranscriptAdaptor = null;
    private VariationAdaptor variationAdaptor = null;
    private String cachedRegion = null;
    private List cachedGenes = null;
    protected Properties stateInformation;
    private Map translationCache = new HashMap();
    private long geneLoadTime = 0L;
    private long dnaProteinLoadTime = 0L;
    private long dnaDnaLoadTime = 0L;
    private long simplePeptideLoadTime = 0L;
    private long featureLoadTime = 0L;
    private long repeatLoadTime = 0L;
    private long predictionTranscriptsLoadTime = 0L;
    private long variationLoadTime = 0L;
    private long sequenceLoadTime = 0L;
    private String loggingFile;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE, ApolloDataAdapterI.OP_APPEND_DATA};
    Properties driverConf;
    static /* synthetic */ Class class$apollo$dataadapter$ensj19$EnsJAdapter;

    public void init() {
        this.tstart = System.currentTimeMillis();
        this.tend = System.currentTimeMillis();
    }

    public void printTime(String message) {
        this.tend = System.currentTimeMillis();
        logger.info((Object)("--- Time " + (double)(this.tend - this.tstart + 1L) / 1000.0 + " " + message));
        this.tstart = this.tend;
    }

    public String getName() {
        return "EnsemblJava";
    }

    public String getType() {
        return "Direct ensembl database access";
    }

    public DataInputType getInputType() {
        if (this.getMode() == 0) {
            return DataInputType.BASEPAIR_RANGE;
        }
        return DataInputType.CONTIG;
    }

    public String getInput() {
        return this.region;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public void setRegion(String region) throws ApolloAdapterException {
        this.region = region;
        if (region != null) {
            if (region.substring(0, 4).equals("Chr ")) {
                this.setMode(0);
            } else if (region.startsWith(STABLE_ID_PREFIX)) {
                this.setMode(2);
            } else {
                this.setMode(1);
            }
        }
    }

    public Properties getStateInformation() {
        return this.stateInformation;
    }

    public void setStateInformation(Properties props) {
        this.cachedRegion = null;
        this.stateInformation = props;
        this.setLoggingFile(props.getProperty("loggingFile"));
        this.setDriverConf(props);
        try {
            String region = props.getProperty("region");
            if (region != null && region.trim().length() > 0) {
                this.setRegion(region);
            } else {
                this.setRegion(null);
            }
        }
        catch (ApolloAdapterException exception) {
            throw new NonFatalDataAdapterException(exception.getMessage());
        }
    }

    protected CurationSet getCurationSetWithoutClearingData() throws ApolloAdapterException {
        this.validateDatabaseProperties(this.getStateInformation());
        try {
            this.initialiseDriver();
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException("Didn't specify enough information to configure database access: " + exception.getMessage());
        }
        this.validateRegionSpecified(this.getStateInformation());
        CurationSet curationSet = new CurationSet();
        try {
            if (this.getMode() == 0 || this.getMode() == 2) {
                AssemblyLocation al = (AssemblyLocation)this.getLocation();
                curationSet.setChromosome(al.getChromosome());
                System.out.println("Set chromosome to " + al.getChromosome());
                curationSet.setLow(al.getStart());
                curationSet.setHigh(al.getEnd());
                curationSet.setStrand(0);
            } else if (this.getMode() == 1) {
                CloneFragmentLocation cfl = (CloneFragmentLocation)this.getLocation();
                curationSet.setChromosome(this.region);
                curationSet.setLow(cfl.getStart());
                curationSet.setHigh(cfl.getEnd());
            } else {
                throw new ApolloAdapterException("Unkown mode.");
            }
            this.genomeSeq = this.getSequence(new DbXref(this.region, this.region, this.region));
            curationSet.setRefSequence(this.genomeSeq);
            curationSet.setOrganism(this.getOrganism());
        }
        catch (AdaptorException e) {
            throw new ApolloAdapterException("Load failed. Are you sure " + this.region + "is a real sequence?", (Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new ApolloAdapterException("Load failed. Are you sure " + this.region + "is a real sequence?", (Exception)((Object)e));
        }
        System.out.println("Now loading ANALYSES");
        curationSet.setResults((StrandedFeatureSetI)this.getAnalysisRegion(curationSet));
        System.out.println("Now loading ANNOTATIONS");
        curationSet.setAnnots(this.getAnnotatedRegion(curationSet));
        curationSet.setName(this.region);
        String assemblyType = null;
        try {
            assemblyType = this.getDriver().resolveMapName(this.getLocation().getMap());
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException(exception.getMessage(), (Exception)((Object)exception));
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException(exception.getMessage(), (Exception)((Object)exception));
        }
        curationSet.setAssemblyType(assemblyType);
        System.out.println("finished with chromosome " + curationSet.getChromosome());
        return curationSet;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        super.clearOldData();
        CurationSet curationSet = this.getCurationSetWithoutClearingData();
        return curationSet;
    }

    protected String getOrganism() {
        String database = this.getStateInformation().getProperty("database");
        String organism = null;
        try {
            int index = database.indexOf(95);
            index = database.indexOf(95, index + 1);
            if (index < database.length()) {
                String first = database.substring(0, 1);
                String last = database.substring(1, index);
                organism = first.toUpperCase() + last;
                System.out.println("Organism is " + organism);
            }
        }
        catch (Exception e) {
            System.out.println("Could not parse organism from " + database);
        }
        return organism;
    }

    protected LinearLocation getLocation() throws AdaptorException, ConfigurationException {
        if (this.getMode() == 0) {
            Region loc = new Region(this.region);
            if (Config.DEBUG) {
                System.out.println("loc" + loc);
            }
            if (loc != null) {
                AssemblyLocation al = new AssemblyLocation();
                if (al == null) {
                    return null;
                }
                al.setChromosome(loc.getChromosome());
                al.setStart(loc.getStart());
                al.setEnd(loc.getEnd());
                al.setStrand(0);
                this.location = al;
            }
        } else if (this.getMode() == 1) {
            if (this.cloneFragmentAdaptor == null) {
                this.initialiseDriver();
            }
            CloneFragment cf = this.cloneFragmentAdaptor.fetch(this.region);
            CloneFragmentLocation cfl = new CloneFragmentLocation();
            if (cf == null) {
                return null;
            }
            cfl.setCloneFragmentInternalID(cf.getInternalID());
            cfl.setStart(1);
            cfl.setEnd(cf.getLength());
            cfl.setStrand(0);
            this.location = cfl;
        } else if (this.getMode() == 2) {
            String stableID = this.region.substring(STABLE_ID_PREFIX.length(), this.region.length());
            logger.info((Object)("Fetching stable id:" + stableID));
            AssemblyLocation al = this.stableID2Location(stableID);
            if (al == null) {
                return null;
            }
            al.setChromosome(al.getChromosome());
            al.setStart(al.getStart());
            al.setEnd(al.getEnd());
            this.location = al;
            this.region = "Chr " + al.getChromosome() + " " + al.getStart() + " " + al.getEnd();
            this.setMode(0);
        }
        return (LinearLocation)this.location;
    }

    private AssemblyLocation stableID2Location(String stableID) throws AdaptorException, ConfigurationException {
        AssemblyLocation loc = null;
        this.initialiseDriver();
        Gene gene = ((GeneAdaptor)this.driver.getAdaptor("gene")).fetch(stableID);
        if (gene != null) {
            loc = (AssemblyLocation)gene.getLocation();
            logger.info((Object)("stable id = " + stableID + " loc = " + loc));
            return loc;
        }
        Transcript transcript = ((TranscriptAdaptor)this.driver.getAdaptor("transcript")).fetch(stableID);
        if (transcript != null) {
            loc = (AssemblyLocation)transcript.getGene().getLocation();
            logger.info((Object)("stable id = " + stableID + " loc = " + loc));
            return loc;
        }
        Translation translation = ((TranslationAdaptor)this.driver.getAdaptor("translation")).fetch(stableID);
        if (translation != null) {
            loc = (AssemblyLocation)translation.getTranscript().getGene().getLocation();
            logger.info((Object)("stable id = " + stableID + " loc = " + loc));
            return loc;
        }
        org.ensembl19.datamodel.Exon exon = ((ExonAdaptor)this.driver.getAdaptor("exon")).fetch(stableID);
        if (exon != null) {
            loc = (AssemblyLocation)exon.getGene().getLocation();
            logger.info((Object)("stable id = " + stableID + " loc = " + loc));
            return loc;
        }
        return null;
    }

    private List getGenes() throws ApolloAdapterException {
        SimpleTimer timer = new SimpleTimer().start();
        List genes = null;
        if (this.cachedRegion != null && this.cachedRegion.equals(this.region)) {
            genes = this.cachedGenes;
        } else {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Getting genes..."));
            try {
                if (this.geneAdaptor == null) {
                    this.initialiseDriver();
                }
                genes = this.geneAdaptor.fetch(this.createQuery());
                logger.debug((Object)("nGenes=" + genes.size()));
                for (int i = 0; i < genes.size(); ++i) {
                    Gene gene = (Gene)genes.get(i);
                    if (gene.getType() == null) {
                        gene.setType("UNKOWN");
                    }
                    if (gene.getAccessionID() != null) continue;
                    gene.setAccessionID("UNKOWN");
                }
                this.cachedGenes = genes;
                this.cachedRegion = this.region;
                this.cacheTranslations(genes);
            }
            catch (ConfigurationException e) {
                throw new ApolloAdapterException("Failed to retrieve data from ensj driver:" + e.getMessage());
            }
            catch (AdaptorException e) {
                throw new ApolloAdapterException("Failed to retrieve data from ensj driver:" + e.getMessage());
            }
        }
        this.geneLoadTime = timer.stop().getDuration();
        logger.info((Object)this.loadMessage(" genes", genes, this.geneLoadTime));
        return genes;
    }

    private void cacheTranslations(List genes) {
        this.translationCache.clear();
        for (int g = 0; g < genes.size(); ++g) {
            Gene gene = (Gene)genes.get(g);
            List transcripts = gene.getTranscripts();
            for (int t = 0; t < transcripts.size(); ++t) {
                Transcript transcript = (Transcript)transcripts.get(t);
                Translation translation = transcript.getTranslation();
                if (translation == null) continue;
                this.translationCache.put(new Long(translation.getInternalID()), translation);
            }
        }
    }

    protected StrandedFeatureSetI getAnnotatedRegion(CurationSet curationSet) throws ApolloAdapterException {
        StrandedFeatureSet root = new StrandedFeatureSet((FeatureSetI)new AnnotatedFeature(), new AnnotatedFeature());
        if (this.getStateAsBoolean("include.Gene")) {
            List genes = this.getGenes();
            System.out.println("got " + genes.size() + " genes ");
            Iterator geneIter = genes.iterator();
            while (geneIter.hasNext()) {
                Gene gene = (Gene)geneIter.next();
                AnnotatedFeatureI apolloGene = this.createGene(gene);
                root.addFeature(apolloGene);
            }
        }
        return root;
    }

    private void addDnaProteinAlignments(Vector v) throws AdaptorException, ConfigurationException {
        if (this.dnaProteinAlignmentAdaptor == null) {
            logger.warn((Object)"Unable to retrieve DNA protein alignments, adaptor unvailable");
            return;
        }
        SimpleTimer timer = new SimpleTimer().start();
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(30.0), "Getting protein features..."));
        List features = this.dnaProteinAlignmentAdaptor.fetch((Location)this.getLocation());
        int nFeatures = features.size();
        for (int i = 0; i < nFeatures; ++i) {
            DnaProteinAlignment psf = (DnaProteinAlignment)features.get(i);
            SeqFeature proteinHit = new SeqFeature();
            proteinHit.setLow(psf.getHitLocation().getStart());
            proteinHit.setHigh(psf.getHitLocation().getEnd());
            proteinHit.setName(psf.getHitAccesion());
            proteinHit.setId(psf.getHitAccesion());
            proteinHit.setScore(psf.getScore());
            SeqFeature genomeHit = new SeqFeature();
            LinearLocation loc = (LinearLocation)psf.getLocation();
            genomeHit.setLow(loc.getStart());
            genomeHit.setHigh(loc.getEnd());
            genomeHit.setStrand(loc.getStrand());
            genomeHit.setName(psf.getDisplayName());
            genomeHit.setId(psf.getDisplayName());
            genomeHit.setFeatureType(psf.getAnalysis().getLogicalName());
            genomeHit.setScore(psf.getScore());
            FeaturePair fp = new FeaturePair(genomeHit, proteinHit);
            v.add(fp);
        }
        this.dnaProteinLoadTime = timer.stop().getDuration();
        logger.info((Object)this.loadMessage(" dna protein alignments", v, this.dnaProteinLoadTime));
    }

    private void addDnaDnaAlignments(Vector v) throws AdaptorException, ConfigurationException {
        if (this.dnaDnaAlignmentAdaptor == null) {
            logger.warn((Object)"Unable to retrieve DNA protein alignments, adaptor unvailable");
            return;
        }
        SimpleTimer timer = new SimpleTimer().start();
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(40.0), "Getting dna features..."));
        List features = this.dnaDnaAlignmentAdaptor.fetch((Location)this.getLocation());
        int nFeatures = features.size();
        for (int i = 0; i < nFeatures; ++i) {
            DnaDnaAlignment psf = (DnaDnaAlignment)features.get(i);
            SeqFeature proteinHit = new SeqFeature();
            proteinHit.setLow(psf.getHitLocation().getStart());
            proteinHit.setHigh(psf.getHitLocation().getEnd());
            proteinHit.setName(psf.getHitAccesion());
            proteinHit.setId(psf.getHitAccesion());
            proteinHit.setScore(psf.getScore());
            SeqFeature genomeHit = new SeqFeature();
            LinearLocation loc = (LinearLocation)psf.getLocation();
            genomeHit.setLow(loc.getStart());
            genomeHit.setHigh(loc.getEnd());
            genomeHit.setStrand(loc.getStrand());
            genomeHit.setName(psf.getHitAccesion());
            genomeHit.setId(psf.getHitAccesion());
            genomeHit.setFeatureType(psf.getAnalysis().getLogicalName());
            genomeHit.setScore(psf.getScore());
            FeaturePair fp = new FeaturePair(genomeHit, proteinHit);
            v.add(fp);
        }
        this.dnaDnaLoadTime = timer.stop().getDuration();
        logger.info((Object)this.loadMessage("dna dna alignments", v, this.dnaDnaLoadTime));
    }

    private void addSimplePeptides(Vector v) throws AdaptorException, ConfigurationException, ApolloAdapterException {
        if (this.simplePeptideAdaptor == null) {
            logger.warn((Object)"Unable to retrieve Simple Peptides, adaptor unvailable");
            return;
        }
        this.getGenes();
        SimpleTimer timer = new SimpleTimer().start();
        ArrayList features = new ArrayList();
        Iterator iter = this.translationCache.values().iterator();
        while (iter.hasNext()) {
            Translation t = (Translation)iter.next();
            features.addAll(this.simplePeptideAdaptor.fetch(t));
        }
        if (features.size() == 0) {
            return;
        }
        logger.info((Object)("Loaded simple peptides = " + features.size()));
        for (int i = 0; i < features.size(); ++i) {
            SimplePeptideFeature feature = (SimplePeptideFeature)features.get(i);
            int start = feature.getPeptideStart();
            int end = feature.getPeptideEnd();
            String displayName = feature.getDisplayName();
            double score = feature.getScore();
            Long translationKey = new Long(feature.getTranslationInternalID());
            Translation translation = (Translation)this.translationCache.get(translationKey);
            if (translation == null) {
                logger.warn((Object)("Skipping SimplePeptideFeature ( " + feature.getInternalID() + " ) because related translation (" + translationKey + ") not cached. "));
                continue;
            }
            feature.setTranslation(translation);
            for (Location loc = feature.getLocation(); loc != null; loc = loc.next()) {
                SeqFeature peptideHit = new SeqFeature();
                peptideHit.setLow(start);
                peptideHit.setHigh(end);
                peptideHit.setName(displayName);
                SeqFeature genomeHit = new SeqFeature();
                genomeHit.setLow(loc.getStart());
                genomeHit.setHigh(loc.getEnd());
                genomeHit.setStrand(loc.getStrand());
                genomeHit.setName(feature.getDisplayName());
                genomeHit.setId(feature.getDisplayName());
                genomeHit.setFeatureType(feature.getAnalysis().getLogicalName());
                genomeHit.setScore(score);
                FeaturePair fp = new FeaturePair(genomeHit, peptideHit);
                v.add(fp);
            }
        }
        this.simplePeptideLoadTime = timer.stop().getDuration();
        logger.info((Object)this.loadMessage("simple peptides", v, this.simplePeptideLoadTime));
    }

    private void addFeatures(Vector v) throws AdaptorException, ConfigurationException {
        if (this.simpleFeatureAdaptor == null) {
            logger.warn((Object)"Unable to retrieve features (simple), adaptor unvailable");
            return;
        }
        SimpleTimer timer = new SimpleTimer().start();
        List features = this.simpleFeatureAdaptor.fetch((Location)this.getLocation());
        int nFeature = features.size();
        for (int i = 0; i < nFeature; ++i) {
            Feature f = (Feature)features.get(i);
            int strand = 1;
            SeqFeature genomeHit = new SeqFeature();
            LinearLocation loc = (LinearLocation)f.getLocation();
            if (loc.getStrand() == -1) {
                strand = 1;
            }
            genomeHit.setLow(loc.getStart());
            genomeHit.setHigh(loc.getEnd());
            genomeHit.setStrand(strand);
            genomeHit.setName(f.getDisplayName());
            genomeHit.setId(f.getDisplayName());
            if (f.getAnalysis() != null) {
                genomeHit.setFeatureType(f.getAnalysis().getLogicalName());
            } else {
                System.out.println("No analysis for feature");
            }
            v.add(genomeHit);
        }
        this.featureLoadTime = timer.stop().getDuration();
        logger.info((Object)this.loadMessage("features (simple)", v, this.featureLoadTime));
    }

    private void addRepeatFeatures(Vector v) throws AdaptorException, ConfigurationException {
        if (this.repeatFeatureAdaptor == null) {
            logger.warn((Object)"Unable to retrieve repeats, adaptor unvailable");
            return;
        }
        SimpleTimer timer = new SimpleTimer().start();
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Getting repeats..."));
        List repeats = this.repeatFeatureAdaptor.fetch((Location)this.getLocation());
        int nRepeats = repeats.size();
        for (int i = 0; i < nRepeats; ++i) {
            RepeatFeature rf = (RepeatFeature)repeats.get(i);
            SeqFeature repeatHit = new SeqFeature();
            LinearLocation hitLoc = (LinearLocation)rf.getHitLocation();
            repeatHit.setLow(hitLoc.getStart());
            repeatHit.setHigh(hitLoc.getEnd());
            repeatHit.setName(rf.getHitDisplayName());
            SeqFeature genomeHit = new SeqFeature();
            LinearLocation loc = (LinearLocation)rf.getLocation();
            genomeHit.setLow(loc.getStart());
            genomeHit.setHigh(loc.getEnd());
            genomeHit.setStrand(loc.getStrand());
            RepeatConsensus rc = rf.getRepeatConsensus();
            if (rc != null) {
                genomeHit.setName(rc.getName());
                genomeHit.setId(rc.getName());
                repeatHit.setName(rc.getName());
                repeatHit.setId(rc.getName());
            } else {
                genomeHit.setName(rf.getDisplayName());
                genomeHit.setId(rf.getDisplayName());
                repeatHit.setName(rf.getHitDisplayName());
                repeatHit.setId(rf.getHitDisplayName());
            }
            genomeHit.setFeatureType(rf.getAnalysis().getLogicalName());
            repeatHit.setScore(rf.getScore());
            genomeHit.setScore(rf.getScore());
            FeaturePair fp = new FeaturePair(genomeHit, repeatHit);
            v.add(fp);
        }
        this.repeatLoadTime = timer.stop().getDuration();
        logger.info((Object)this.loadMessage("repeat", v, this.repeatLoadTime));
    }

    private void addPredictionTranscripts(StrandedFeatureSet root) throws AdaptorException, ConfigurationException, ApolloAdapterException {
        if (this.predictionTranscriptAdaptor == null) {
            logger.warn((Object)"Unable to retrieve prediction transcripts, adaptor unavailable");
            return;
        }
        SimpleTimer timer = new SimpleTimer().start();
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(80.0), "Getting prediction transcripts..."));
        List predictions = this.predictionTranscriptAdaptor.fetch((Location)this.getLocation());
        int nPredictions = predictions.size();
        Hashtable<String, StrandedFeatureSetI> transTypeHash = new Hashtable<String, StrandedFeatureSetI>();
        for (int i = 0; i < nPredictions; ++i) {
            StrandedFeatureSetI subRoot;
            PredictionTranscript pt = (PredictionTranscript)predictions.get(i);
            String predType = pt.getAnalysis().getLogicalName();
            if (!transTypeHash.containsKey(predType)) {
                subRoot = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
                subRoot.getForwardSet().setFeatureType(predType);
                subRoot.getReverseSet().setFeatureType(predType);
                transTypeHash.put(predType, subRoot);
            } else {
                subRoot = (StrandedFeatureSetI)transTypeHash.get(predType);
            }
            FeatureSet transFeature = new FeatureSet();
            transFeature.setFeatureType(predType);
            transFeature.setName(predType + ":" + pt.getInternalID());
            transFeature.setId("" + pt.getInternalID());
            Iterator pes = pt.getExons().iterator();
            while (pes.hasNext()) {
                PredictionExon pe = (PredictionExon)pes.next();
                SeqFeature predExon = new SeqFeature();
                LinearLocation loc = (LinearLocation)pe.getLocation();
                predExon.setLow(loc.getStart());
                predExon.setHigh(loc.getEnd());
                predExon.setStrand(loc.getStrand());
                predExon.setName(transFeature.getName());
                predExon.setId(transFeature.getName());
                predExon.setFeatureType(predType);
                if (pe.getPvalue() > 0.0) {
                    predExon.setScore(pe.getPvalue());
                } else {
                    predExon.setScore(pe.getScore());
                }
                transFeature.setStrand(loc.getStrand());
                transFeature.addFeature(predExon);
            }
            transFeature.setTranslationStart(transFeature.getStart());
            transFeature.setTranslationEnd(transFeature.getEnd());
            transFeature.sort(transFeature.getStrand());
            subRoot.addFeature(transFeature);
        }
        Enumeration e = transTypeHash.keys();
        while (e.hasMoreElements()) {
            StrandedFeatureSetI sfs = (StrandedFeatureSetI)transTypeHash.get(e.nextElement());
            root.addFeature(sfs.getForwardSet());
            root.addFeature(sfs.getReverseSet());
        }
        logger.info((Object)this.loadMessage("prediction transcripts (conversion to Apollo object model)", Collections.EMPTY_LIST, timer.stop().getDuration()));
    }

    private void addVariations(Vector v) throws AdaptorException, ConfigurationException {
        if (this.variationAdaptor == null) {
            logger.warn((Object)"Unable to retrieve variations (simple), adaptor unvailable");
            return;
        }
        SimpleTimer timer = new SimpleTimer().start();
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(60.0), "Getting SNPs..."));
        List variations = this.variationAdaptor.fetch((Location)this.getLocation());
        int nVariation = variations.size();
        for (int i = 0; i < nVariation; ++i) {
            Variation variation = (Variation)variations.get(i);
            SeqFeature seqFeature = new SeqFeature();
            LinearLocation loc = (LinearLocation)variation.getLocation();
            seqFeature.setLow(loc.getStart());
            seqFeature.setHigh(loc.getEnd());
            seqFeature.setStrand(loc.getStrand());
            String nameID = Long.toString(variation.getInternalID());
            seqFeature.setName(nameID);
            seqFeature.setId(nameID);
            seqFeature.setFeatureType("Variation");
            v.add(seqFeature);
        }
        this.variationLoadTime = timer.stop().getDuration();
        logger.info((Object)this.loadMessage("variations", v, this.variationLoadTime));
    }

    private void buildFeatureSet(StrandedFeatureSet root, Vector flatFeatures) {
        FeatureSetBuilder fsb = new FeatureSetBuilder();
        fsb.makeSetFeatures(root, flatFeatures, Config.getPropertyScheme());
    }

    private FeatureSetI getAnalysisRegion(CurationSet curationSet) throws ApolloAdapterException {
        StrandedFeatureSet root = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        try {
            boolean skimpy;
            Vector flat = new Vector();
            Style style = Config.getStyle();
            if (this.getStateAsBoolean("include.Gene") && !style.getShowAnnotations()) {
                this.getGenes();
            }
            this.addContigs(root);
            int loc_size = Math.abs(this.getLocation().getEnd() - this.getLocation().getStart() + 1);
            boolean bl = skimpy = loc_size > style.getFeatureLoadSize();
            if (!skimpy) {
                if (this.getStateAsBoolean("include.DnaProteinAlignment")) {
                    this.addDnaProteinAlignments(flat);
                }
                if (this.getStateAsBoolean("include.DnaDnaAlignment")) {
                    this.addDnaDnaAlignments(flat);
                }
                if (this.getStateAsBoolean("include.SimplePeptideFeature")) {
                    if (this.getMode() == 1) {
                        throw new ApolloAdapterException("Simple Peptide Features are not supported for Clone Fragment-fetches");
                    }
                    this.addSimplePeptides(flat);
                }
                if (this.getStateAsBoolean("include.Feature")) {
                    this.addFeatures(flat);
                }
                if (this.getStateAsBoolean("include.RepeatFeature")) {
                    this.addRepeatFeatures(flat);
                }
                if (this.getStateAsBoolean("include.Variation")) {
                    this.addVariations(flat);
                }
            }
            SimpleTimer timer = new SimpleTimer().start();
            if (Config.getPFetchServer() != null) {
                for (int j = 0; j < flat.size(); ++j) {
                    SeqFeatureI sf = (SeqFeatureI)flat.elementAt(j);
                    this.setSequence(sf, curationSet);
                }
            }
            this.buildFeatureSet(root, flat);
            logger.info((Object)("Time it took to build feature set = " + timer.stop().getDuration() + "ms"));
            if (this.getStateAsBoolean("include.Gene") && !style.getShowAnnotations()) {
                this.addTranscripts(root);
            }
            if (!skimpy && this.getStateAsBoolean("include.PredictionTranscript")) {
                this.addPredictionTranscripts(root);
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Done"));
        }
        catch (AdaptorException e) {
            throw new ApolloAdapterException("problem loading data: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new ApolloAdapterException("problem loading data: " + e.getMessage(), (Exception)((Object)e));
        }
        return root;
    }

    private void addContigs(StrandedFeatureSet root) throws ApolloAdapterException {
        try {
            if (this.getMode() != 0) {
                return;
            }
            AssemblyElement[] elements = ((MySQLLocationConverter)this.getLocationConverter()).getPartialAssembly((AssemblyLocation)this.location).getElements();
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(20.0), "Getting contigs..."));
            for (int i = 0; i < elements.length; ++i) {
                AssemblyElement element = elements[i];
                CloneFragment cloneFragment = this.cloneFragmentAdaptor.fetch(element.getCloneFragmentInternalID());
                String cloneAccession = cloneFragment.getClone().getAccessionID();
                String contigName = cloneFragment.getName();
                SeqFeature genomicFeature = new SeqFeature();
                genomicFeature.setLow(element.getChromosomeStart());
                genomicFeature.setHigh(element.getChromosomeEnd());
                genomicFeature.setStrand(element.getCloneFragmentOri());
                genomicFeature.setName(contigName);
                genomicFeature.setId(contigName);
                genomicFeature.setFeatureType("sequence");
                SeqFeature contigFeature = new SeqFeature();
                contigFeature.setLow(element.getCloneFragmentStart());
                contigFeature.setHigh(element.getCloneFragmentEnd());
                contigFeature.setStrand(element.getCloneFragmentOri());
                contigFeature.setName(contigName);
                contigFeature.setId(contigName);
                contigFeature.setFeatureType("sequence");
                FeatureSet subset = new FeatureSet();
                subset.setStrand(element.getCloneFragmentOri());
                subset.setFeatureType("sequence");
                subset.addFeature(new FeaturePair(genomicFeature, contigFeature));
                genomicFeature.setRefFeature(subset);
                contigFeature.setRefFeature(subset);
                if (element.getCloneFragmentOri() == 1) {
                    root.getForwardSet().addFeature(subset);
                    continue;
                }
                if (element.getCloneFragmentOri() == -1) {
                    root.getReverseSet().addFeature(subset);
                    continue;
                }
                throw new ApolloAdapterException("Found a contig - id: " + element.getCloneFragmentInternalID() + "without strand");
            }
        }
        catch (AdaptorException exception) {
            throw new ApolloAdapterException("Problem adding contigs: " + exception.getMessage(), (Exception)((Object)exception));
        }
    }

    private void setSequence(SeqFeatureI sf, CurationSet curationSet) {
        if (sf instanceof FeaturePair) {
            FeaturePair pair = (FeaturePair)sf;
            String name = pair.getHname();
            SequenceI seq = curationSet.getSequence(name);
            if (seq == null) {
                seq = new PFetchSequence(name, Config.getController());
                curationSet.addSequence(seq);
            }
            pair.getHitFeature().setRefSequence(seq);
        }
    }

    public static void main(String[] args) throws Exception {
        DataAdapterRegistry registry = new DataAdapterRegistry();
        registry.installDataAdapter("apollo.dataadapter.ensj.EnsJAdapter");
        registry.installDataAdapter("apollo.dataadapter.SerialDiskAdapter");
        registry.installDataAdapter("apollo.dataadapter.gamexml.GAMEAdapter");
        DataAdapterChooser chooser = new DataAdapterChooser(registry, ApolloDataAdapterI.OP_READ_DATA, "Load data", null, false);
        chooser.setPropertiesFile(new File("/home/craig/dev/apollo/data/apollo.history"));
        chooser.show();
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getLoggingFile() {
        return this.loggingFile;
    }

    public void setLoggingFile(String v) {
        this.loggingFile = v;
    }

    public Properties getDriverConf() {
        return this.driverConf;
    }

    protected Driver getDriver() {
        return this.driver;
    }

    protected int getMode() {
        return this.mode;
    }

    public void setDriverConf(Properties v) {
        this.driverConf = v;
    }

    private void initialiseDriver() throws ConfigurationException {
        try {
            LoggingManager.configure((String)this.loggingFile);
            this.driver = DriverManager.load((Properties)this.driverConf);
            this.geneAdaptor = (GeneAdaptor)this.driver.getAdaptor("gene");
            this.cloneFragmentAdaptor = (CloneFragmentAdaptor)this.driver.getAdaptor("clone_fragment");
            this.dnaProteinAlignmentAdaptor = (DnaProteinAlignmentAdaptor)this.driver.getAdaptor("dna_protein_alignment");
            this.dnaDnaAlignmentAdaptor = (DnaDnaAlignmentAdaptor)this.driver.getAdaptor("dna_dna_alignment");
            this.simpleFeatureAdaptor = (SimpleFeatureAdaptor)this.driver.getAdaptor("simple_feature");
            this.simplePeptideAdaptor = (SimplePeptideAdaptor)this.driver.getAdaptor("simple_peptide_feature");
            this.repeatFeatureAdaptor = (RepeatFeatureAdaptor)this.driver.getAdaptor("RepeatMask");
            this.predictionTranscriptAdaptor = (PredictionTranscriptAdaptor)this.driver.getAdaptor("prediction_transcript");
            this.variationAdaptor = (VariationAdaptor)this.driver.getAdaptor("variation");
            this.setLocationConverter((LocationConverter)this.driver.getAdaptor("location_converter"));
            SimpleTimer timer = new SimpleTimer().start();
            this.simpleFeatureAdaptor.fetch((Location)AssemblyLocation.valueOf((String)"1:1-1"));
            logger.info((Object)this.loadMessage("assemblyElements cache", Collections.EMPTY_LIST, timer.stop().getDuration()));
            this.initialisedDriver = true;
        }
        catch (ParseException exception) {
            throw new ConfigurationException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new ConfigurationException(exception.getMessage());
        }
    }

    private AnnotatedFeatureI createGene(Gene ensjGene) {
        AnnotatedFeature gene = new AnnotatedFeature();
        String source = ensjGene.getType();
        String id = Long.toString(ensjGene.getInternalID());
        gene.setId(id);
        gene.setName(this.getName((Accessioned)ensjGene, id));
        gene.setDescription(ensjGene.getDescription());
        Location loc = ensjGene.getLocation();
        gene.setStrand(loc.getStrand());
        Iterator transcripts = ensjGene.getTranscripts().iterator();
        while (transcripts.hasNext()) {
            apollo.datamodel.Transcript transcript = this.createTranscript((Transcript)transcripts.next());
            gene.addFeature(transcript);
            transcript.setOwner(source);
        }
        Vector synonyms = gene.getSynonyms();
        for (int i = 0; i < synonyms.size(); ++i) {
            String synonym = (String)synonyms.get(i);
            gene.addSynonym(synonym);
        }
        return gene;
    }

    private apollo.datamodel.Transcript createTranscript(Transcript ensjTranscript) {
        apollo.datamodel.Transcript transcript = new apollo.datamodel.Transcript();
        String id = Long.toString(ensjTranscript.getInternalID());
        transcript.setId(id);
        transcript.setName(this.getName((Accessioned)ensjTranscript, id));
        Location loc = ensjTranscript.getLocation();
        transcript.setStrand(loc.getStrand());
        Iterator exons = ensjTranscript.getExons().iterator();
        while (exons.hasNext()) {
            Exon exon = this.createExon((org.ensembl19.datamodel.Exon)exons.next());
            transcript.addExon(exon);
            logger.debug((Object)("exon low = " + exon.getLow() + " exon high = " + exon.getHigh()));
        }
        this.setTranslationStartEndFromEnsjTranscript(transcript, ensjTranscript);
        return transcript;
    }

    private void setTranslationStartEndFromEnsjTranscript(FeatureSetI set, Transcript ensjTranscript) {
        if (ensjTranscript.getTranslation() != null) {
            List locs = null;
            try {
                locs = ensjTranscript.getTranslation().getCodingLocations();
            }
            catch (InvalidLocationException e) {
                locs = Collections.EMPTY_LIST;
            }
            int nLocs = locs.size();
            if (nLocs == 0) {
                String desc = Long.toString(ensjTranscript.getInternalID());
                String t = ensjTranscript.getAccessionID();
                if (t != null) {
                    desc = desc + " (" + t + ")";
                }
                logger.warn((Object)("Failed to translate transcript: " + desc));
                return;
            }
            LinearLocation firstLoc = (LinearLocation)locs.get(0);
            LinearLocation lastLoc = (LinearLocation)locs.get(nLocs - 1);
            if (set.getStrand() == 1) {
                logger.debug((Object)("Forward strand transcript: coding start = " + firstLoc.getStart() + " coding end = " + lastLoc.getEnd()));
                logger.debug((Object)("                         : set low = " + set.getLow() + " set high = " + set.getHigh()));
                set.setTranslationStart(firstLoc.getStart());
                set.setTranslationEnd(lastLoc.getEnd());
            } else {
                logger.debug((Object)("Reverse strand transcript: coding start = " + firstLoc.getEnd() + " coding end = " + lastLoc.getStart()));
                logger.debug((Object)("                         : set low = " + set.getLow() + " set high = " + set.getHigh()));
                set.setTranslationStart(firstLoc.getEnd());
                set.setTranslationEnd(lastLoc.getStart());
            }
        }
    }

    private Exon createExon(org.ensembl19.datamodel.Exon ensjExon) {
        Exon exon = new Exon();
        String id = Long.toString(ensjExon.getInternalID());
        exon.setId(id);
        exon.setName(this.getName((Accessioned)ensjExon, id));
        LinearLocation loc = (LinearLocation)ensjExon.getLocation();
        exon.setStrand(loc.getStrand());
        exon.setLow(loc.getStart());
        exon.setHigh(loc.getEnd());
        return exon;
    }

    private void addTranscripts(StrandedFeatureSet root) throws ApolloAdapterException {
        List genes = null;
        Hashtable<String, StrandedFeatureSetI> geneTypeHash = new Hashtable<String, StrandedFeatureSetI>();
        SimpleTimer timer = new SimpleTimer().start();
        try {
            if (this.geneAdaptor == null) {
                this.initialiseDriver();
            }
            genes = this.getGenes();
        }
        catch (ConfigurationException exception) {
            throw new ApolloAdapterException("Failed to retrieve data from ensj driver:" + exception.getMessage(), (Exception)((Object)exception));
        }
        Iterator geneIter = genes.iterator();
        while (geneIter.hasNext()) {
            StrandedFeatureSetI subRoot;
            Gene gene = (Gene)geneIter.next();
            logger.debug((Object)("gene type = " + gene.getType()));
            if (!geneTypeHash.containsKey(gene.getType())) {
                System.out.println("Adding gene type for " + gene.getType());
                subRoot = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
                subRoot.getForwardSet().setFeatureType(gene.getType());
                subRoot.getReverseSet().setFeatureType(gene.getType());
                geneTypeHash.put(gene.getType(), subRoot);
            } else {
                System.out.println("Using gene type hash for " + gene.getType());
                subRoot = (StrandedFeatureSetI)geneTypeHash.get(gene.getType());
            }
            FeatureSet geneFeature = new FeatureSet();
            geneFeature.setFeatureType(gene.getType());
            geneFeature.setName(this.getName((Accessioned)gene));
            geneFeature.setId(this.getName((Accessioned)gene));
            Iterator transcriptIter = gene.getTranscripts().iterator();
            while (transcriptIter.hasNext()) {
                Transcript transcript = (Transcript)transcriptIter.next();
                FeatureSet transcriptFeature = new FeatureSet();
                transcriptFeature.setFeatureType(gene.getType());
                transcriptFeature.setName(this.getName((Accessioned)transcript));
                transcriptFeature.setId(this.getName((Accessioned)transcript));
                System.out.println("Added " + transcriptFeature.getName() + " to " + geneFeature.getName() + " a " + geneFeature.getFeatureType());
                Iterator exonIter = transcript.getExons().iterator();
                while (exonIter.hasNext()) {
                    org.ensembl19.datamodel.Exon exon = (org.ensembl19.datamodel.Exon)exonIter.next();
                    LinearLocation l = (LinearLocation)exon.getLocation();
                    SeqFeature exonFeature = new SeqFeature(l.getStart(), l.getEnd(), gene.getType());
                    exonFeature.setStrand(l.getStrand());
                    String id = Long.toString(exon.getInternalID());
                    exonFeature.setName(this.getName((Accessioned)exon, id));
                    exonFeature.setFeatureType(gene.getType());
                    exonFeature.setId(id);
                    exonFeature.setScore(100.0);
                    transcriptFeature.setStrand(l.getStrand());
                    geneFeature.setStrand(l.getStrand());
                    transcriptFeature.addFeature(exonFeature, true);
                }
                this.setTranslationStartEndFromEnsjTranscript(transcriptFeature, transcript);
                geneFeature.addFeature(transcriptFeature, true);
            }
            subRoot.addFeature(geneFeature);
        }
        Enumeration e = geneTypeHash.keys();
        while (e.hasMoreElements()) {
            StrandedFeatureSetI sfs = (StrandedFeatureSetI)geneTypeHash.get(e.nextElement());
            root.addFeature(sfs.getForwardSet());
            root.addFeature(sfs.getReverseSet());
        }
        logger.info((Object)this.loadMessage("genes (conversion to Apollo object model)", genes, timer.stop().getDuration()));
    }

    private Query createQuery() throws AdaptorException, ConfigurationException {
        Query q = new Query();
        q.setLocation((Location)this.getLocation());
        q.setIncludeChildren(true);
        return q;
    }

    private String getName(Accessioned item, String defaultName) {
        String name = item.getAccessionID();
        if (name == null) {
            name = defaultName;
        }
        return name;
    }

    private String getName(Accessioned item) {
        return this.getName(item, Long.toString(item.getInternalID()));
    }

    private String loadMessage(String type, Collection data, long time) {
        long total = this.dnaProteinLoadTime + this.simplePeptideLoadTime + this.featureLoadTime + this.repeatLoadTime + this.predictionTranscriptsLoadTime + this.geneLoadTime + this.sequenceLoadTime;
        return type + " features: num = " + data.size() + ", load time = " + time + "ms" + " (total = " + total + ")";
    }

    private boolean getStateAsBoolean(String type) {
        logger.debug((Object)("stateInformation = " + PropertiesUtil.toString((Properties)this.stateInformation)));
        return PropertiesUtil.booleanValue((Properties)this.stateInformation, (String)type, (boolean)false);
    }

    protected String getRegion() {
        return this.region;
    }

    protected SequenceI getReferenceSequence() {
        return this.genomeSeq;
    }

    List getChromosomes() throws DataAdapterException, ConfigurationException {
        ArrayList<String> returnList = new ArrayList<String>();
        String jdbcDriver = this.getStateInformation().getProperty("jdbc_driver");
        String host = this.getStateInformation().getProperty("host");
        String port = this.getStateInformation().getProperty("port");
        String database = this.getStateInformation().getProperty("database");
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
        String user = this.getStateInformation().getProperty("user");
        String password = this.getStateInformation().getProperty("password");
        if (jdbcDriver == null || jdbcDriver.trim().length() <= 0 || host == null || host.trim().length() <= 0 || port == null || port.trim().length() <= 0 || user == null || user.trim().length() <= 0) {
            return new ArrayList();
        }
        if (password == null) {
            password = "";
        }
        try {
            Class.forName(jdbcDriver).newInstance();
        }
        catch (IllegalAccessException exception) {
            throw new ApolloAdapterException("Cannot access the driver class " + jdbcDriver + "\n" + exception.getMessage(), exception);
        }
        catch (InstantiationException exception) {
            throw new ApolloAdapterException("Cannot create the driver class " + jdbcDriver + "\n" + exception.getMessage(), exception);
        }
        catch (ClassNotFoundException exception) {
            throw new ApolloAdapterException("Cannot find the driver class " + jdbcDriver + "\n" + exception.getMessage(), exception);
        }
        try {
            Connection connection = java.sql.DriverManager.getConnection(url, user, password);
            Statement statement = connection.createStatement();
            ResultSet names = statement.executeQuery("select name from chromosome");
            while (names.next()) {
                String chromosomeName = names.getString(1);
                returnList.add(chromosomeName);
            }
        }
        catch (SQLException exception) {
            throw new ApolloAdapterException(exception.getMessage(), exception);
        }
        Collections.sort(returnList);
        return returnList;
    }

    private LocationConverter getLocationConverter() {
        return this.locationConverter;
    }

    private void setLocationConverter(LocationConverter converter) {
        this.locationConverter = converter;
    }

    private void setMode(int mode) {
        this.mode = mode;
    }

    public void clearStateInformation() {
        this.stateInformation = new StateInformation();
    }

    private void validateDatabaseProperties(Properties properties) throws ApolloAdapterException {
        String host = properties.getProperty("host");
        String port = properties.getProperty("port");
        String database = properties.getProperty("database");
        if (host == null || host.trim().length() <= 0) {
            throw new ApolloAdapterException("database host name must be provided");
        }
        if (port == null || port.trim().length() <= 0) {
            throw new ApolloAdapterException("database port  must be provided");
        }
        if (database == null || database.trim().length() <= 0) {
            throw new ApolloAdapterException("ensembl database name must be provided");
        }
    }

    protected void validateRegionSpecified(Properties properties) throws ApolloAdapterException {
        String region = this.getRegion();
        Region loc = null;
        CloneFragment cf = null;
        CloneFragmentLocation cfl = null;
        AssemblyLocation al = null;
        if (region == null) {
            throw new ApolloAdapterException("Must specify a region to load");
        }
        if (this.getMode() == 0) {
            try {
                loc = new Region(region);
            }
            catch (RuntimeException exception) {
                throw new ApolloAdapterException("Specified chromosome/start/end could not be parsed as such");
            }
        }
        if (this.getMode() == 1) {
            if (this.cloneFragmentAdaptor == null) {
                throw new IllegalStateException("Fatal problem - uninitialised clone fragment adapter!");
            }
            try {
                cf = this.cloneFragmentAdaptor.fetch(region);
            }
            catch (AdaptorException exception) {
                throw new ApolloAdapterException("Could not fetch clone fragment with specified id");
            }
            cfl = new CloneFragmentLocation();
            if (cf == null) {
                throw new ApolloAdapterException("Clone Fragment with specified ID does not exist");
            }
        } else if (this.getMode() == 2) {
            String stableID = region.substring(STABLE_ID_PREFIX.length(), region.length());
            logger.info((Object)("Fetching stable id:" + stableID));
            try {
                al = this.stableID2Location(stableID);
            }
            catch (ConfigurationException exception) {
                throw new ApolloAdapterException("Driver Configuration problem fetching object with stable ID " + stableID);
            }
            catch (AdaptorException exception) {
                throw new ApolloAdapterException("Could not fetch object with stable ID " + stableID);
            }
            if (al == null) {
                throw new ApolloAdapterException("Could not find anything with the input stable id");
            }
        } else {
            throw new ApolloAdapterException("Must specify whether location is Chromosome, Clone or Stable Id");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

