/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ensembl19.gui.DriverConfigPanel;

public class DriverDialog
extends JDialog
implements ActionListener {
    boolean useCustom = false;
    private DriverConfigPanel seqDriverConfigPanel;
    JCheckBox customBox;
    JButton ok;
    JButton cancel;
    Properties stateInformation;

    public DriverDialog(JFrame frame, Properties props) {
        super(frame, "Sequence DB settings", true);
        this.stateInformation = props;
        this.init();
        if (frame == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.customBox) {
            this.useCustom = this.customBox.isSelected();
        } else if (evt.getSource() == this.ok) {
            this.commitIfComplete();
        } else if (evt.getSource() == this.cancel) {
            this.hide();
            this.dispose();
        }
    }

    private void commitIfComplete() {
        if (this.customBox.isSelected()) {
            String seqDriverConfFiles = this.seqDriverConfigPanel.getServer() + ":" + this.seqDriverConfigPanel.getDriver();
            this.stateInformation.put("seqDriverConfFiles", seqDriverConfFiles);
            System.out.println("Driver string = " + seqDriverConfFiles);
        }
        this.hide();
        this.dispose();
    }

    public void init() {
        this.seqDriverConfigPanel = new DriverConfigPanel();
        this.customBox = new JCheckBox();
        this.customBox.setSelected(this.useCustom);
        this.customBox.addActionListener(this);
        JPanel mainP = new JPanel();
        mainP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        mainP.add((Component)new JLabel("Use custom database"), gbc);
        gbc.gridwidth = 0;
        mainP.add((Component)this.customBox, gbc);
        gbc.gridwidth = 0;
        mainP.add((Component)this.seqDriverConfigPanel, gbc);
        JPanel enclosureP = new JPanel();
        enclosureP.setLayout(new BorderLayout());
        enclosureP.add((Component)mainP, "Center");
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel buttonP = new JPanel();
        buttonP.add(this.ok);
        buttonP.add(this.cancel);
        this.getContentPane().add((Component)enclosureP, "Center");
        this.getContentPane().add((Component)buttonP, "South");
        this.pack();
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        JButton show = new JButton("Show");
        JButton set = new JButton("Set");
        show.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DriverDialog dd = new DriverDialog(frame, new Properties());
                dd.setVisible(true);
            }
        });
        set.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        frame.getContentPane().setLayout(new GridLayout(2, 1));
        frame.getContentPane().add(show);
        frame.getContentPane().add(set);
        frame.pack();
        frame.setVisible(true);
    }
}

