/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.dataadapter.ensj19.DataSourceConfigurationPanel;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CompositeDataSourceConfigurationPanel
extends JPanel {
    private HashMap choosers = new HashMap();
    private JComboBox chooserDropdown;
    private ActionListener chooserActionListener;
    private String previousChooserKey;
    private String[] chooserNames;
    private String defaultChooserName;
    public ActionListener interactionListener;
    private boolean linkChooserInteractions;
    static /* synthetic */ Class class$javax$swing$JDialog;

    public CompositeDataSourceConfigurationPanel(String[] chooserNames) {
        this(chooserNames, true);
    }

    public CompositeDataSourceConfigurationPanel(String[] chooserNames, boolean linkChooserInteractions) {
        this.chooserNames = chooserNames;
        this.linkChooserInteractions = linkChooserInteractions;
        this.setDefaultChooserName(chooserNames[0]);
        this.initialiseChoosers(chooserNames);
        this.buildGUI();
    }

    public CompositeDataSourceConfigurationPanel() {
        this(new String[]{"default", "sequence", "variation"});
    }

    private void initialiseChoosers(String[] chooserNames) {
        for (int i = 0; i < chooserNames.length; ++i) {
            DataSourceConfigurationPanel panel = new DataSourceConfigurationPanel();
            panel.setInteractionListener(this.getInteractionListener());
            if (this.getLinkChooserInteractions() && chooserNames[i].equals(this.getDefaultChooserName())) {
                panel.getFindButton().removeActionListener(panel.getHostListener());
                panel.getFindButton().addActionListener(new DatabaseFindListener());
            }
            panel.setBorder(BorderFactory.createTitledBorder("Configuration for: " + chooserNames[i] + " data source"));
            this.getChoosers().put(chooserNames[i], panel);
        }
    }

    public Properties getPrefixedProperties() {
        Properties returnProperties = new Properties();
        Iterator chooserNames = this.getChoosers().keySet().iterator();
        while (chooserNames.hasNext()) {
            String chooserName = (String)chooserNames.next();
            DataSourceConfigurationPanel panel = this.getChooser(chooserName);
            if (!chooserName.equals(this.getDefaultChooserName())) {
                Properties subProperties = panel.getProperties();
                Iterator<Object> names = subProperties.keySet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    String value = subProperties.getProperty(name);
                    name = chooserName + "." + name;
                    returnProperties.put(name, value);
                }
                continue;
            }
            returnProperties.putAll((Map<?, ?>)panel.getProperties());
        }
        return returnProperties;
    }

    public void setProperties(Properties properties) {
        String[] chooserNames = this.getChooserNames();
        boolean giveUp = false;
        for (int i = 0; i < chooserNames.length && !giveUp; ++i) {
            String chooserName = chooserNames[i];
            Iterator<Object> names = properties.keySet().iterator();
            DataSourceConfigurationPanel panel = this.getChooser(chooserName);
            Properties subProperties = new Properties();
            chooserName = chooserName + ".";
            while (names.hasNext()) {
                String name = (String)names.next();
                String value = properties.getProperty(name);
                if (!name.startsWith(chooserName)) continue;
                name = name.substring(chooserName.length());
                subProperties.put(name, value);
            }
            if (subProperties.size() > 0) {
                panel.setProperties(subProperties);
                continue;
            }
            panel.setProperties(properties);
        }
    }

    private void buildGUI() {
        this.chooserDropdown = new JComboBox();
        this.chooserDropdown.setPreferredSize(new Dimension(300, 20));
        this.chooserDropdown.setModel(new DefaultComboBoxModel(new Vector(this.getChoosers().keySet())));
        if (this.getChoosers().containsKey(this.getDefaultChooserName())) {
            this.chooserDropdown.setSelectedItem(this.getDefaultChooserName());
            this.setPreviousChooserKey(this.getDefaultChooserName());
        }
        this.chooserActionListener = new ChooserActionListener();
        this.chooserDropdown.addActionListener(this.getChooserActionListener());
        JPanel dropdownPanel = new JPanel();
        dropdownPanel.setLayout(new FlowLayout());
        dropdownPanel.add(new JLabel("Data Source:"));
        dropdownPanel.add(this.chooserDropdown);
        this.setLayout(new GridBagLayout());
        this.add((Component)dropdownPanel, GuiUtil.makeConstraintAt(0, 0, 1));
        for (int i = 0; i < this.getChooserNames().length; ++i) {
            if (this.getDefaultChooserName().equals(this.getChooserNames()[i])) {
                this.getChooser(this.getChooserNames()[i]).setVisible(true);
            } else {
                this.getChooser(this.getChooserNames()[i]).setVisible(false);
            }
            this.add((Component)this.getChooser(this.getChooserNames()[i]), GuiUtil.makeConstraintAt(0, i + 1, 1));
        }
    }

    private String[] getChooserNames() {
        return this.chooserNames;
    }

    private String getPreviousChooserKey() {
        return this.previousChooserKey;
    }

    private void setPreviousChooserKey(String key) {
        this.previousChooserKey = key;
    }

    public DataSourceConfigurationPanel getChooser(String key) {
        return (DataSourceConfigurationPanel)this.choosers.get(key);
    }

    private HashMap getChoosers() {
        return this.choosers;
    }

    private JComboBox getChooserDropdown() {
        return this.chooserDropdown;
    }

    public String getSelectedChooser() {
        return (String)this.getChooserDropdown().getSelectedItem();
    }

    private ActionListener getChooserActionListener() {
        return this.chooserActionListener;
    }

    public ActionListener getInteractionListener() {
        if (this.interactionListener == null) {
            this.interactionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            };
        }
        return this.interactionListener;
    }

    public void setInteractionListener(ActionListener listener) {
        this.interactionListener = listener;
        for (int i = 0; i < this.getChooserNames().length; ++i) {
            this.getChooser(this.getChooserNames()[i]).setInteractionListener(listener);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)new CompositeDataSourceConfigurationPanel(), "Center");
        frame.pack();
        frame.show();
    }

    private void setDefaultChooserName(String name) {
        this.defaultChooserName = name;
    }

    private String getDefaultChooserName() {
        return this.defaultChooserName;
    }

    public void populateEnsemblDatabases() {
        Properties defaultPanelProperties = this.getChooser(this.getDefaultChooserName()).getProperties();
        String jdbcDriver = defaultPanelProperties.getProperty("jdbc_driver");
        String host = defaultPanelProperties.getProperty("host");
        String port = defaultPanelProperties.getProperty("port");
        String url = "jdbc:mysql://" + host + ":" + port + "/";
        String user = defaultPanelProperties.getProperty("user");
        String password = defaultPanelProperties.getProperty("password");
        ArrayList<String> coreList = new ArrayList<String>();
        if (jdbcDriver == null || jdbcDriver.trim().length() <= 0 || host == null || host.trim().length() <= 0 || port == null || port.trim().length() <= 0 || user == null || user.trim().length() <= 0) {
            return;
        }
        if (password == null) {
            password = "";
        }
        this.initialiseDatabaseDriver(defaultPanelProperties);
        try {
            Connection conn = DriverManager.getConnection(url, user, password);
            Statement statement = conn.createStatement();
            ResultSet databases = statement.executeQuery("show databases");
            while (databases.next()) {
                String databaseName = databases.getString(1);
                coreList.add(databaseName);
            }
            coreList.add(0, "");
            Iterator chooserNames = this.getChoosers().keySet().iterator();
            while (chooserNames.hasNext()) {
                String chooserName = (String)chooserNames.next();
                DataSourceConfigurationPanel chooser = (DataSourceConfigurationPanel)this.getChoosers().get(chooserName);
                chooser.detachEnsemblDatabaseDropdownListener();
                chooser.getEnsemblDatabaseDropdown().setModel(new DefaultComboBoxModel(new Vector(coreList)));
                chooser.attachEnsemblDatabaseDropdownListener();
            }
        }
        catch (SQLException exception) {
            JOptionPane.showMessageDialog(null, "I cannot connect to the MySQL instance on the host to find the databases: \n" + host + ":" + port + " user: " + user + " - \n " + exception.getMessage());
        }
    }

    protected void initialiseDatabaseDriver(Properties defaultPanelProperties) {
        String jdbcDriver = defaultPanelProperties.getProperty("jdbc_driver");
        String host = defaultPanelProperties.getProperty("host");
        String port = defaultPanelProperties.getProperty("port");
        if (jdbcDriver == null || jdbcDriver.trim().length() <= 0 || host == null || host.trim().length() <= 0 || port == null || port.trim().length() <= 0) {
            return;
        }
        try {
            Class.forName(jdbcDriver).newInstance();
        }
        catch (IllegalAccessException exception) {
            JOptionPane.showMessageDialog(null, "Cannot access the driver class " + jdbcDriver + "\n" + exception.getMessage());
        }
        catch (InstantiationException exception) {
            JOptionPane.showMessageDialog(null, "Cannot create the driver class " + jdbcDriver + "\n" + exception.getMessage());
        }
        catch (ClassNotFoundException exception) {
            JOptionPane.showMessageDialog(null, "Cannot find the driver class " + jdbcDriver + "\n" + exception.getMessage());
        }
    }

    private boolean getLinkChooserInteractions() {
        return this.linkChooserInteractions;
    }

    public void addExternalDataSourceChangeListener(ActionListener listener) {
        Iterator choosers = this.getChoosers().values().iterator();
        DataSourceConfigurationPanel chooser = null;
        while (choosers.hasNext()) {
            chooser = (DataSourceConfigurationPanel)choosers.next();
            chooser.addExternalDataChangeListener(listener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ChooserActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            String currentKey = (String)CompositeDataSourceConfigurationPanel.this.getChooserDropdown().getSelectedItem();
            if (CompositeDataSourceConfigurationPanel.this.getPreviousChooserKey() != null) {
                CompositeDataSourceConfigurationPanel.this.getChooser(CompositeDataSourceConfigurationPanel.this.getPreviousChooserKey()).setVisible(false);
            }
            CompositeDataSourceConfigurationPanel.this.getChooser(currentKey).setVisible(true);
            CompositeDataSourceConfigurationPanel.this.setPreviousChooserKey(currentKey);
            JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = CompositeDataSourceConfigurationPanel.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, CompositeDataSourceConfigurationPanel.this);
            dialog.pack();
        }
    }

    public class DatabaseFindListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            CompositeDataSourceConfigurationPanel.this.populateEnsemblDatabases();
        }
    }
}

