/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.dataadapter.ensj19.OtterAnnotationSourceChooser;
import apollo.dataadapter.ensj19.SourceChooserWithHistory;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ensembl19.gui.FileChooserWithHistory;

public abstract class AnnotationSourceChooser
extends JPanel {
    private JLabel inputFileLabel = new JLabel("Input File");
    private JLabel inputServerLabel = new JLabel("Annotation Server / Port");
    private JLabel inputDataSetLabel = new JLabel("Annotation Dataset");
    private JLabel outputFileLabel = new JLabel("Output File");
    private JLabel outputDataSetLabel = new JLabel("Output Dataset");
    private JLabel serverPortLabel = new JLabel(":");
    private JTextField annotationUserTextField;
    private JLabel annotationUserLabel = new JLabel("Author");
    private JTextField annotationUserEmailTextField;
    private JTextField serverPortTextField;
    private JLabel annotationUserEmailLabel = new JLabel("Email");
    private JCheckBox editingEnabledCheckBox;
    private FileChooserWithHistory inputFileTextField;
    private SourceChooserWithHistory inputServerTextField;
    private JComboBox inputDataSetList;
    private FileChooserWithHistory outputFileTextField;
    private JComboBox outputDataSetList;
    private JButton findButton;

    public AnnotationSourceChooser() {
        this(new Vector(), new Vector(), new Vector());
    }

    public AnnotationSourceChooser(Vector inputFileHistory, Vector inputServerHistory, Vector outputFileHistory) {
        RemoveDatasetsListenerForPort keyListener = new RemoveDatasetsListenerForPort();
        RemoveDatasetsListenerForServer itemListener = new RemoveDatasetsListenerForServer();
        this.inputFileTextField = new FileChooserWithHistory(null, inputFileHistory, (JComponent)this, "xml");
        this.outputFileTextField = new FileChooserWithHistory(null, outputFileHistory, (JComponent)this, "xml");
        this.inputServerTextField = new SourceChooserWithHistory(inputServerHistory);
        this.inputDataSetList = new JComboBox();
        this.inputDataSetList.setPreferredSize(this.inputServerTextField.getSourceHistoryList().getPreferredSize());
        this.inputDataSetList.setEditable(false);
        this.serverPortTextField = new JTextField(6);
        this.outputDataSetList = new JComboBox();
        this.outputDataSetList.setPreferredSize(this.inputServerTextField.getSourceHistoryList().getPreferredSize());
        this.outputDataSetList.setEditable(true);
        this.annotationUserTextField = new JTextField();
        this.annotationUserTextField.setPreferredSize(this.inputServerTextField.getSourceHistoryList().getPreferredSize());
        this.annotationUserEmailTextField = new JTextField();
        this.annotationUserEmailTextField.setPreferredSize(this.inputServerTextField.getSourceHistoryList().getPreferredSize());
        this.editingEnabledCheckBox = new JCheckBox("Editing Enabled");
        this.findButton = new JButton("Find...");
        this.findButton.addActionListener(new FindDataSetsListener());
        this.serverPortTextField.addKeyListener(keyListener);
        this.inputServerTextField.addItemListener(itemListener);
        this.layoutComponents();
    }

    private void layoutComponents() {
        int row = 0;
        JPanel fileIOPanel = new JPanel();
        JPanel serverIOPanel = new JPanel();
        fileIOPanel.setBorder(BorderFactory.createTitledBorder("File Based Annotations"));
        serverIOPanel.setBorder(BorderFactory.createTitledBorder("Server Based Annotations"));
        fileIOPanel.setLayout(new GridBagLayout());
        row = 0;
        fileIOPanel.add((Component)this.getInputFileLabel(), GuiUtil.makeConstraintAt(0, row, 1));
        fileIOPanel.add((Component)this.getInputFileTextField(), GuiUtil.makeConstraintAt(1, row, 2));
        fileIOPanel.add((Component)this.getOutputFileLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        fileIOPanel.add((Component)this.getOutputFileTextField(), GuiUtil.makeConstraintAt(1, row, 2));
        serverIOPanel.setLayout(new GridBagLayout());
        row = 0;
        serverIOPanel.add((Component)this.getAnnotationUserLabel(), GuiUtil.makeConstraintAt(0, row, 1));
        serverIOPanel.add((Component)this.getAnnotationUserTextField(), GuiUtil.makeConstraintAt(1, row, 1));
        serverIOPanel.add((Component)this.getEditingEnabledCheckBox(), GuiUtil.makeConstraintAt(2, row, 3));
        serverIOPanel.add((Component)this.getAnnotationUserEmailLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        serverIOPanel.add((Component)this.getAnnotationUserEmailTextField(), GuiUtil.makeConstraintAt(1, row, 1));
        serverIOPanel.add((Component)this.getInputServerLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        serverIOPanel.add((Component)this.getInputServerTextField(), GuiUtil.makeConstraintAt(1, row, 2));
        serverIOPanel.add((Component)this.getServerPortLabel(), GuiUtil.makeConstraintAt(2, row, 1));
        serverIOPanel.add((Component)this.getServerPortTextField(), GuiUtil.makeConstraintAt(3, row, 1));
        serverIOPanel.add((Component)this.getInputDataSetLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        serverIOPanel.add((Component)this.getInputDataSetList(), GuiUtil.makeConstraintAt(1, row, 1));
        serverIOPanel.add((Component)this.getFindButton(), GuiUtil.makeConstraintAt(3, row, 1));
        this.setLayout(new GridBagLayout());
        row = 0;
        this.add((Component)serverIOPanel, GuiUtil.makeConstraintAt(0, row, 3));
        this.add((Component)fileIOPanel, GuiUtil.makeConstraintAt(0, ++row, 3));
    }

    private JLabel getAnnotationUserLabel() {
        return this.annotationUserLabel;
    }

    private JTextField getAnnotationUserTextField() {
        return this.annotationUserTextField;
    }

    private JLabel getAnnotationUserEmailLabel() {
        return this.annotationUserEmailLabel;
    }

    private JTextField getAnnotationUserEmailTextField() {
        return this.annotationUserEmailTextField;
    }

    public String getAnnotationUser() {
        return this.getAnnotationUserTextField().getText();
    }

    public void setAnnotationUser(String user) {
        this.getAnnotationUserTextField().setText(user);
    }

    public String getAnnotationUserEmail() {
        return this.getAnnotationUserEmailTextField().getText();
    }

    public void setAnnotationUserEmail(String email) {
        this.getAnnotationUserEmailTextField().setText(email);
    }

    private JCheckBox getEditingEnabledCheckBox() {
        return this.editingEnabledCheckBox;
    }

    private JLabel getInputServerLabel() {
        return this.inputServerLabel;
    }

    private void setInputServerLabel(JLabel inputServerLabel) {
        this.inputServerLabel = inputServerLabel;
    }

    private JLabel getInputDataSetLabel() {
        return this.inputDataSetLabel;
    }

    private void setInputDataSetLabel(JLabel newValue) {
        this.inputDataSetLabel = newValue;
    }

    private JLabel getInputFileLabel() {
        return this.inputFileLabel;
    }

    private void setInputFileLabel(JLabel inputFileLabel) {
        this.inputFileLabel = inputFileLabel;
    }

    private JLabel getOutputFileLabel() {
        return this.outputFileLabel;
    }

    private void setOutputFileLabel(JLabel outputFileLabel) {
        this.outputFileLabel = outputFileLabel;
    }

    private JLabel getOutputDataSetLabel() {
        return this.outputDataSetLabel;
    }

    private void setOutputDataSetLabel(JLabel outputDataSetLabel) {
        this.outputDataSetLabel = outputDataSetLabel;
    }

    private FileChooserWithHistory getInputFileTextField() {
        return this.inputFileTextField;
    }

    private void setInputFileTextField(FileChooserWithHistory inputFileTextField) {
        this.inputFileTextField = inputFileTextField;
    }

    private FileChooserWithHistory getOutputFileTextField() {
        return this.outputFileTextField;
    }

    private void setOutputFileTextField(FileChooserWithHistory outputFileTextField) {
        this.outputFileTextField = outputFileTextField;
    }

    private JComboBox getInputDataSetList() {
        return this.inputDataSetList;
    }

    private void setInputDataSetList(JComboBox inputDataSetList) {
        this.inputDataSetList = inputDataSetList;
    }

    private SourceChooserWithHistory getInputServerTextField() {
        return this.inputServerTextField;
    }

    private void setInputServerTextField(SourceChooserWithHistory inputServerTextField) {
        this.inputServerTextField = inputServerTextField;
    }

    private JComboBox getOutputDataSetList() {
        return this.outputDataSetList;
    }

    private void setOutputDataSetList(JComboBox outputDataSetList) {
        this.outputDataSetList = outputDataSetList;
    }

    private JTextField getServerPortTextField() {
        return this.serverPortTextField;
    }

    private JLabel getServerPortLabel() {
        return this.serverPortLabel;
    }

    public String getSelectedInputFileName() {
        return this.getInputFileTextField().getSelected();
    }

    public String getSelectedOutputFileName() {
        if (this.getOutputFileTextField().getSelected() == null || this.getOutputFileTextField().getSelected().trim().length() <= 0) {
            return this.getSelectedInputFileName();
        }
        return this.getOutputFileTextField().getSelected();
    }

    public String getSelectedInputServerName() {
        return (String)this.getInputServerTextField().getSourceHistoryList().getSelectedItem();
    }

    public void setSelectedInputServerName(String name) {
        this.getInputServerTextField().getSourceHistoryList().setSelectedItem(name);
    }

    public String getSelectedInputDataSetName() {
        return (String)this.getInputDataSetList().getSelectedItem();
    }

    public void setSelectedInputDataSetName(String name) {
        this.getInputDataSetList().setSelectedItem(name);
    }

    public String getSelectedOutputDataSetName() {
        if (this.getOutputDataSetList().getSelectedItem() == null || ((String)this.getOutputDataSetList().getSelectedItem()).trim().length() <= 0) {
            return this.getSelectedInputDataSetName();
        }
        return (String)this.getOutputDataSetList().getSelectedItem();
    }

    public boolean isEditingEnabled() {
        return this.getEditingEnabledCheckBox().isSelected();
    }

    public Vector getInputFileHistory() {
        return this.getInputFileTextField().getHistory();
    }

    public void setInputFileHistory(Vector historyVector) {
        this.getInputFileTextField().setHistory(historyVector);
    }

    public Vector getInputServerHistory() {
        return this.getInputServerTextField().getSourceHistory();
    }

    public void setInputServerHistory(Vector historyVector) {
        this.getInputServerTextField().setSourceHistory(historyVector);
    }

    public Vector getOutputFileHistory() {
        return this.getOutputFileTextField().getHistory();
    }

    public void setOutputFileHistory(Vector historyVector) {
        this.getOutputFileTextField().setHistory(historyVector);
    }

    public void setSelectedInputFileName(String name) {
        this.getInputFileTextField().setSelected(name);
    }

    public void setSelectedOutputFileName(String name) {
        this.getOutputFileTextField().setSelected(name);
    }

    public String getSelectedServerPort() {
        return this.getServerPortTextField().getText();
    }

    public void setSelectedServerPort(String port) {
        this.getServerPortTextField().setText(port);
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame("test");
        testFrame.getContentPane().add((Component)new OtterAnnotationSourceChooser(), "Center");
        testFrame.pack();
        testFrame.show();
    }

    protected abstract List getDataSetsForServer(String var1, String var2);

    public JButton getFindButton() {
        return this.findButton;
    }

    public void setFindButton(JButton testButton) {
        this.findButton = testButton;
    }

    public class FindDataSetsListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            if (AnnotationSourceChooser.this.getInputServerTextField().getSelectedSource() != null && AnnotationSourceChooser.this.getServerPortTextField().getText() != null && AnnotationSourceChooser.this.getServerPortTextField().getText().trim().length() > 0) {
                List dataSetList = AnnotationSourceChooser.this.getDataSetsForServer(AnnotationSourceChooser.this.getInputServerTextField().getSelectedSource(), AnnotationSourceChooser.this.getServerPortTextField().getText());
                Vector vector = new Vector(dataSetList);
                AnnotationSourceChooser.this.getInputDataSetList().setModel(new DefaultComboBoxModel(vector));
            }
        }
    }

    public class RemoveDatasetsListenerForServer
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            AnnotationSourceChooser.this.getInputDataSetList().setModel(new DefaultComboBoxModel());
        }
    }

    public class RemoveDatasetsListenerForPort
    extends KeyAdapter {
        public void keyPressed(KeyEvent event) {
            AnnotationSourceChooser.this.getInputDataSetList().setModel(new DefaultComboBoxModel());
        }
    }
}

